/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import com.baidu.tts.loopj.Base64;
import com.baidu.tts.loopj.Base64DataException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private final Base64.Coder coder;
    private final int flags;
    private byte[] buffer = null;
    private int bpos = 0;
    private static byte[] EMPTY = new byte[0];

    public Base64OutputStream(OutputStream outputStream, int n2) {
        this(outputStream, n2, true);
    }

    public Base64OutputStream(OutputStream outputStream, int n2, boolean bl2) {
        super(outputStream);
        this.flags = n2;
        if (bl2) {
            this.coder = new Base64.Encoder(n2, null);
            return;
        }
        this.coder = new Base64.Decoder(n2, null);
    }

    public void write(int n2) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        if (this.bpos >= this.buffer.length) {
            Base64OutputStream base64OutputStream = this;
            base64OutputStream.internalWrite(base64OutputStream.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
        this.buffer[this.bpos++] = (byte)n2;
    }

    private void flushBuffer() throws IOException {
        if (this.bpos > 0) {
            Base64OutputStream base64OutputStream = this;
            base64OutputStream.internalWrite(base64OutputStream.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return;
        }
        this.flushBuffer();
        this.internalWrite(byArray, n2, n3, false);
    }

    public void close() throws IOException {
        IOException iOException;
        block7: {
            iOException = null;
            try {
                this.flushBuffer();
                this.internalWrite(EMPTY, 0, 0, true);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if ((this.flags & 0x10) == 0) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
            }
            catch (IOException iOException3) {
                if (iOException == null) break block7;
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private void internalWrite(byte[] byArray, int n2, int n3, boolean bl2) throws IOException {
        Base64OutputStream base64OutputStream = this;
        this.coder.output = base64OutputStream.embiggen(base64OutputStream.coder.output, this.coder.maxOutputSize(n3));
        if (!this.coder.process(byArray, n2, n3, bl2)) {
            throw new Base64DataException("bad base-64");
        }
        this.out.write(this.coder.output, 0, this.coder.op);
    }

    private byte[] embiggen(byte[] byArray, int n2) {
        if (byArray == null || byArray.length < n2) {
            return new byte[n2];
        }
        return byArray;
    }
}

