package com.epath.shitu.epathmap.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;


public class ShadeLayout extends FrameLayout {

    public RectF mLayer;                   // 画布图层大小
    public Path mClipPath;                 // 剪裁区域路径
    public Region mAreaRegion;             // 内容区域
    public int mEdgeFix = 10;              // 边缘修复
    public boolean mRoundAsCircle = true; // 圆形
    public Paint mPaint;                   // 画笔

    private boolean isOpenClip = false;//控制是否裁剪

    private int topClipMargin = 0;
    private float circleCenterX;
    private float circleCenterY;
    private float circleR;
    private boolean isOpenIntercept;


    public ShadeLayout(@NonNull Context context) {
        this(context, null);
    }

    public ShadeLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadeLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init();
    }

    private void init() {
        mLayer = new RectF();
        mClipPath = new Path();
        mAreaRegion = new Region();
        mPaint = new Paint();
        mPaint.setColor(Color.WHITE);
        mPaint.setAntiAlias(true);
    }


    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        mLayer.set(0, 0, w, h);
        refreshRegion(this);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if(isOpenClip) {
            canvas.saveLayer(mLayer, null, Canvas.ALL_SAVE_FLAG);
            super.dispatchDraw(canvas);
            onClipDraw(canvas);
            canvas.restore();
        }else{
            super.dispatchDraw(canvas);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
//        refreshRegion(this);
//        canvas.save();
//        canvas.clipPath(mClipPath);
        super.draw(canvas);
//        canvas.restore();
    }

    public void refreshRegion(View view) {
        int w = (int) mLayer.width();
        int h = (int) mLayer.height();
        RectF areas = new RectF();
        areas.left = view.getPaddingLeft();
        areas.top = view.getPaddingTop();
        areas.right = w - view.getPaddingRight();
        areas.bottom = h - view.getPaddingBottom();
        mClipPath.reset();
        if (mRoundAsCircle) {
            float d = areas.width() >= areas.height() ? areas.height() : areas.width();
            float r = d / 2;
            PointF center = new PointF(w / 2, h / 2);

            circleCenterX = center.x;
            circleCenterY = center.y + 1000 + topClipMargin;
            circleR = r + 1000;

            mClipPath.addCircle(circleCenterX, circleCenterY, circleR, Path.Direction.CW);
        }
        mClipPath.moveTo(-mEdgeFix, -mEdgeFix);  // 通过空操作让Path区域占满画布
        mClipPath.moveTo(w + mEdgeFix, h + mEdgeFix);
        Region clip = new Region((int) areas.left, (int) areas.top,
                (int) areas.right, (int) areas.bottom);
        mAreaRegion.setPath(mClipPath, clip);
    }

    public void onClipDraw(Canvas canvas) {

        mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        mPaint.setColor(Color.WHITE);
        mPaint.setStyle(Paint.Style.FILL);
        canvas.drawPath(mClipPath, mPaint);
    }

    public void setOpenClip(boolean openClip) {
        isOpenClip = openClip;
    }

    public void setTopClipMargin(int topClipMargin){
        this.topClipMargin = topClipMargin;
        refreshRegion(this);
        invalidate();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if(isOpenIntercept) {
            boolean inCircle = isPointInCircle(ev.getX(), ev.getY(), circleCenterX, circleCenterY, circleR);
            return !inCircle;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setIsOpenIntercept(boolean isOpenIntercept){
        this.isOpenIntercept = isOpenIntercept;
    }

    public boolean isPointInCircle(float x1, float y1, float circleCenterX, float circleCenterY, float r)
    {
        //到圆心的距离 是否大于半径。半径是R
        //如O(x,y)点圆心，任意一点P（x1,y1） （x-x1）*(x-x1)+(y-y1)*(y-y1)>R*R 那么在圆外 反之在圆内
        if (!((circleCenterX - x1)*(circleCenterX - x1) + (circleCenterY - y1)*(circleCenterY - y1) > r*r))
        {
            return true;        //当前点在圆内
        }
        else
        {
            return false;       //当前点在圆外
        }
    }
}
