package com.epath.shitu.epathmap.ui.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.epath.shitu.epathmap.R;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.epath.shitu.epathmap.ui.adapter.BaseRecyclerAdapter;
import com.epath.shitu.epathmap.ui.item.LocShareFriendItem;
import com.epath.shitu.epathmap.ui.item.OnItemClickListener;
import com.epath.shitu.epathmap.ui.utils.FixLinearLayoutManager;
import com.shitu.location.epathmap.utils.DateUtils;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.L;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LocShareFriendsDialog {

    private final TextView tvInLine;
    private final TextView tvAllLine;
    private final TextView tvStopShare;
    private BottomSheetBehavior dialog;
    private View contentView;
    private LinearLayout llLine;
    private Context context;
    private RecyclerView recyclerView;
    private BaseRecyclerAdapter adapter;
    private int height, currentHeight;
    private List<LocationRegionData> list = new ArrayList<>();
    private String currentObjectId = "";//选中item的objectId
    private OnItemClickListener onItemClickListener;
    private int inLine = 0;
    private int allLineNumber;

    public LocShareFriendsDialog(Context context, View contentView, String groupId, List<LocationRegionData> list0, OnItemClickListener onItemClickListener0,
                                 OnItemClickListener onNavClickListener, View.OnClickListener onQuitClickListener,
                                 View.OnClickListener onShareClickListener, BottomSheetSlideListener bottomSheetSlideListener) {
        this.contentView = contentView;
        this.context = context;
        this.list = list0;
        this.onItemClickListener = onItemClickListener0;
        recyclerView = (RecyclerView) contentView.findViewById(R.id.recyclerView);
        TextView tvGroupId = (TextView) contentView.findViewById(R.id.tv_group_id);
        llLine = (LinearLayout) contentView.findViewById(R.id.ll_line);
        tvInLine = (TextView) contentView.findViewById(R.id.tv_inLine);
        tvAllLine = (TextView) contentView.findViewById(R.id.tv_outLine);
        tvStopShare = (TextView) contentView.findViewById(R.id.tv_stop_share);

        tvGroupId.setText(groupId);
        tvStopShare.setOnClickListener(view -> dismiss());
        llLine.setOnClickListener(view -> dismiss());

        contentView.findViewById(R.id.tv_quit).setOnClickListener(onQuitClickListener);
        contentView.findViewById(R.id.tv_share).setOnClickListener(onShareClickListener);
        FixLinearLayoutManager layoutManager = new FixLinearLayoutManager(context, LinearLayoutManager.VERTICAL, false);
        layoutManager.setRecycleChildrenOnDetach(true);
        recyclerView.setLayoutManager(layoutManager);
        if (list.size() > 0 && list.get(0) != null) {
            currentObjectId = list.get(0).getObjectId();
            list.get(0).setSelected(true);
        }
        allLineNumber = list.size();
        tvAllLine.setText(allLineNumber + "");
        for (int i = 0; i < list.size(); i++) {
            LocationRegionData locationRegionData = list.get(i);
            Date updatedAt = locationRegionData.getUpdatedAt();
            String time = DateUtils.getTimeBeforeNow(updatedAt.getTime());
            if (time.contains(context.getString(R.string.epath_minutes_ago))) {
                int pos = time.lastIndexOf(context.getString(R.string.epath_minutes_ago));
                String substring = time.substring(0, pos);
                try {
                    int lastMinute = Integer.parseInt(substring);
                    if (lastMinute >= 5) {
                        allLineNumber--;
                    }
                } catch (Exception e) {
                    L.e("ddd", e.toString());
                }
            } else if (time.contains(context.getString(R.string.epath_hours_ago))) {
                allLineNumber--;
            }
        }
        tvInLine.setText(allLineNumber + "/");

        adapter = new BaseRecyclerAdapter(list);
        LocShareFriendItem item = new LocShareFriendItem(context);
        item.setOnItemClickListener(position -> {
            for (LocationRegionData locationRegionData : list) {
                locationRegionData.setSelected(false);
            }
            currentObjectId = list.get(position).getObjectId();
            list.get(position).setSelected(true);
            onItemClickListener.onClick(position);
            adapter.notifyDataSetChanged();
        });
        item.setOnItemNavClickListener(position -> {
            onNavClickListener.onClick(position);
        });
        adapter.addItemFactory(item);
        recyclerView.setAdapter(adapter);

        int size = list.size();
        if (size > 2) {
            size = 2;
        }
        dialog = BottomSheetBehavior.from(contentView);
        dialog.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback() {
            @Override
            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                try {
                    switch (newState) {
                        case BottomSheetBehavior.STATE_HIDDEN:

                            break;
                        case BottomSheetBehavior.STATE_COLLAPSED:
//                        currentHeight = DensityUtils.dp2px(context, 40);
//
//                        llLine.setVisibility(View.GONE);
                            break;
                        case BottomSheetBehavior.STATE_EXPANDED:
//                        currentHeight = height;
//
//                        llLine.setVisibility(View.VISIBLE);
                            break;
                    }
                    bottomSheetSlideListener.onStateChanged(newState);
                } catch (Exception e) {
                    L.e("bottomSheet", e.toString());
                }

            }

            @Override
            public void onSlide(@NonNull View bottomSheet, float slideOffset) {

            }
        });
        height = DensityUtils.dp2px(context, 55 + 70 * (size + 1));
        currentHeight = height;
        int margin = DensityUtils.dp2px(context, 16);
        recyclerView.setLayoutParams(new LinearLayout.LayoutParams(RecyclerView.LayoutParams.MATCH_PARENT,
                DensityUtils.dp2px(context, 1 + 70 * size)));
        CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
                DensityUtils.getScreenWidth(context) - margin * 2,
                CoordinatorLayout.LayoutParams.WRAP_CONTENT);
        lp.setMargins(margin, 0, margin, 0);
        lp.setBehavior(dialog);
        contentView.setLayoutParams(lp);
        dismiss();

    }

    public void notifyDataSetChanged(List<LocationRegionData> list0) {
        if (dialog != null) {
            list.clear();
            list.addAll(list0);
            allLineNumber = list.size();
            tvAllLine.setText(allLineNumber + "");
            for (int i = 0; i < list.size(); i++) {
                LocationRegionData locationRegionData = list.get(i);
                Date updatedAt = locationRegionData.getUpdatedAt();
                String time = DateUtils.getTimeBeforeNow(updatedAt.getTime());
                if (time.contains(context.getString(R.string.epath_minutes_ago))) {
                    int pos = time.lastIndexOf(context.getString(R.string.epath_minutes_ago));
                    String substring = time.substring(0, pos);
                    try {
                        int lastMinute = Integer.parseInt(substring);
                        if (lastMinute >= 5) {
                            allLineNumber--;
                        }
                    } catch (Exception e) {
                        L.e("ddd", e.toString());
                    }
                } else if (time.contains(context.getString(R.string.epath_hours_ago))) {
                    allLineNumber--;
                }
            }
            tvInLine.setText(allLineNumber + "/");
            boolean checked = false;
            for (int i = 0; i < list.size(); i++) {
                LocationRegionData item = list.get(i);
                if (currentObjectId.equals(item.getObjectId())) {
                    checked = true;
                    item.setSelected(true);
                    //onItemClickListener.onClick(i);
                    break;
                }
            }
            if (!checked && list.size() > 0) {
                currentObjectId = list.get(0).getObjectId();
                list.get(0).setSelected(true);
                // onItemClickListener.onClick(0);
            }
            adapter.reset(list);
            int size = list.size();
            if (size > 2) {
                size = 2;
            }
            height = DensityUtils.dp2px(context, 55 + 70 * (size + 1));
            if (dialog.getState() == BottomSheetBehavior.STATE_EXPANDED) {
                currentHeight = height;
            }
            recyclerView.setLayoutParams(new LinearLayout.LayoutParams(RecyclerView.LayoutParams.MATCH_PARENT,
                    DensityUtils.dp2px(context, 1 + 70 * size)));
            int margin = DensityUtils.dp2px(context, 16);
            CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
                    DensityUtils.getScreenWidth(context) - margin * 2,
                    CoordinatorLayout.LayoutParams.WRAP_CONTENT);
            lp.setMargins(margin, 0, margin, 0);
            lp.setBehavior(dialog);
            contentView.setLayoutParams(lp);

        }
    }

    public int getCurrentHeight() {
        return currentHeight;
    }

    public void show() {
        if (dialog != null) {
            contentView.setVisibility(View.VISIBLE);
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
        }

    }


    public void dismiss() {
        if (dialog != null && dialog.getState() != BottomSheetBehavior.STATE_HIDDEN) {
            dialog.setState(BottomSheetBehavior.STATE_HIDDEN);
            contentView.setVisibility(View.GONE);
        }
    }

    public interface BottomSheetSlideListener {
        void onStateChanged(int state);
    }

}
