package com.epath.shitu.epathmap.ui.item;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.epath.shitu.epathmap.R;
import com.epath.shitu.epathmap.ui.utils.ImageLoader;
import com.shitu.location.epathmap.model.parse.MapData;


public class MapProjectItem extends BaseRecyclerItemFactory<MapProjectItem.LocationRegionDataRecyclerItem> {

    Context context;

    public MapProjectItem(Context context) {
        this.context = context;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof MapData;
    }

    @Override
    public LocationRegionDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionDataRecyclerItem(parent, this);
    }

    public class LocationRegionDataRecyclerItem extends BaseRecyclerItem<MapData, MapProjectItem> {

        private TextView tvName;
        private ImageView ivMap;
        private RelativeLayout rlRoot;

        protected LocationRegionDataRecyclerItem(ViewGroup parent, MapProjectItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_map_project, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvName = (TextView) convertView.findViewById(R.id.tv_name);
            ivMap = (ImageView) convertView.findViewById(R.id.iv_map);
            rlRoot = (RelativeLayout) convertView.findViewById(R.id.rl_root);
        }

        @Override
        protected void onConfigViews(final Context context) {

        }

        @Override
        protected void onSetData(int position, MapData item) {
            tvName.setText(item.getName());
            if (!TextUtils.isEmpty(item.getPicture())) {
                ImageLoader.loadCircle(context, item.getPicture(), ivMap);
            } else {
                ivMap.setImageResource(R.drawable.ic_img_default);
            }
            if (item.isSelected()) {
                rlRoot.setBackgroundResource(R.color.tvGrey18);
            } else {
                rlRoot.setBackgroundResource(R.color.white);
            }
        }

    }


}
