package com.epath.shitu.epathmap.ui.activity;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.ImageView;

import com.epath.shitu.epathmap.R;
import com.epath.shitu.epathmap.base.BasePresenterActivity;
import com.epath.shitu.epathmap.presenter.IView.EpathSearchView;
import com.epath.shitu.epathmap.presenter.EpathSearchPresenter;
import com.epath.shitu.epathmap.ui.fragment.EpSearchGenreFragment;
import com.epath.shitu.epathmap.ui.fragment.EpSearchHistoryFragment;
import com.epath.shitu.epathmap.utils.KeyboardVisibilityEvent.KeyboardVisibilityEvent;
import com.epath.shitu.epathmap.utils.KeyboardVisibilityEvent.Unregister;
import com.shitu.location.epathmap.model.bean.DataHolder;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.LocationRegionIconData;
import com.shitu.location.epathmap.model.bean.LocationRegionTagData;
import com.shitu.location.epathmap.utils.KeyboardUtils;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.shitu.location.epathmap.utils.SpUtils;
import com.shitu.location.epathmap.utils.T;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

public class EpSearchActivity extends BasePresenterActivity<EpathSearchPresenter> implements View.OnClickListener,
        EpathSearchView {

    private ImageView ivSearch;
    private EditText etSearch;
    private EpSearchGenreFragment searchGenreFragment;
    private EpSearchHistoryFragment searchHistoryFragment;
    public static final String
            REQUEST_ID = "id",
            REQUEST_TYPE = "type",
            REQUEST_TYPE_START = "start",
            REQUEST_TYPE_TARGET = "target",
            REQUEST_REGIONS = "regions";
    private String id, type;
    private ArrayList<LocationRegionData> locationRegionDatas;
    private Unregister keyboardRegister;

    protected static Intent getIntent(Context context, String id, String type) {
        Intent intent = new Intent(context, EpSearchActivity.class);
        intent.putExtra(REQUEST_ID, id);
        intent.putExtra(REQUEST_TYPE, type);
//        intent.putExtra(REQUEST_REGIONS, locationRegionDatas);
        return intent;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_search;
    }

    @Override
    public void finish() {
        super.finish();
        KeyboardUtils.hideKeyboard(this);
    }

    @Override
    protected void initView(Bundle savedInstanceState) {

        super.initSwipeBack();


        ivSearch = (ImageView) findViewById(R.id.iv_search);
        etSearch = (EditText) findViewById(R.id.et_search);
        findViewById(R.id.iv_back).setOnClickListener(this);
        ivSearch.setOnClickListener(this);
        id = getIntent().getStringExtra(REQUEST_ID);
        type = getIntent().getStringExtra(REQUEST_TYPE);
        locationRegionDatas = DataHolder.getInstance().getLocationRegions();
//        locationRegionDatas = getIntent().getParcelableArrayListExtra(REQUEST_REGIONS);
        showFragment(savedInstanceState);
        if (type.equals(REQUEST_TYPE_TARGET)) {
            etSearch.setHint(R.string.epath_destination);
        } else {
            etSearch.setHint(R.string.epath_starting_point);
        }
        etSearch.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH ||
                    (event != null && event.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                String search = etSearch.getText().toString();
                if (TextUtils.isEmpty(search.trim())) {
                    T.showShort(R.string.epath_empty_search_content);
                } else {
                    KeyboardUtils.hideKeyboard(this);
                    queryByName(search, MixpanelConstants.SEARCH_FROM_SEARCH_TEXT);
                }
                return true;
            }
            return false;
        });
        keyboardRegister = KeyboardVisibilityEvent.registerEventListener(this, isOpen -> {
            if (isOpen) {
                getSupportFragmentManager().beginTransaction()
                        .show(searchHistoryFragment)
                        .hide(searchGenreFragment)
                        .commit();

            } else {
                getSupportFragmentManager().beginTransaction()
                        .show(searchGenreFragment)
                        .hide(searchHistoryFragment)
                        .commit();
            }
        });
    }

    @Override
    protected void onDestroy() {
        if (keyboardRegister != null) {
            keyboardRegister.unregister();
        }
        super.onDestroy();
    }

    private void showFragment(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            searchGenreFragment = (EpSearchGenreFragment) getSupportFragmentManager().findFragmentByTag("genre");
            searchHistoryFragment = (EpSearchHistoryFragment) getSupportFragmentManager().findFragmentByTag("history");
            getSupportFragmentManager().beginTransaction()
                    .show(searchGenreFragment)
                    .hide(searchHistoryFragment)
                    .commit();
        } else {
            searchGenreFragment = EpSearchGenreFragment.getInstance(id, type);
            searchHistoryFragment = EpSearchHistoryFragment.getInstance(id, type);
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.flContent, searchGenreFragment, "genre")
                    .add(R.id.flContent, searchHistoryFragment, "history")
                    .hide(searchHistoryFragment)
                    .commit();
        }
    }

    @Override
    protected void initData() {

    }

    private void setSearchHistory(String content) {
        String json = SpUtils.getSearchHistoryJson(context);
        try {
            JSONArray jsonArray = new JSONArray();
            if (!TextUtils.isEmpty(json)) {
                jsonArray = new JSONArray(json);
            }
            boolean firstAdd = true;
            for (int i = 0; i < jsonArray.length(); i++) {
                if (jsonArray.optString(i).equals(content)) {
                    firstAdd = false;
                    break;
                }
            }
            if (firstAdd) {
                jsonArray.put(content);
            }
            SpUtils.setSearchHistory(context, jsonArray.toString());
            searchHistoryFragment.loadHistory();
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void queryByName(String content, String from) {
        setSearchHistory(content);
        presenter.queryByContent(id, content, from, locationRegionDatas);
    }

    //读写sd业务逻辑
    @Override
    public void doSDCardAndRecordAudio() {
        startSpeechDialog(result -> {
            queryByName(result, MixpanelConstants.SEARCH_FROM_SEARCH_VOICE);
        });
    }


    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.iv_back) {
            finish();
        } else if (v.getId() == R.id.iv_search) {
            if (hasPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.RECORD_AUDIO, Manifest.permission.RECORD_AUDIO)) {
                doSDCardAndRecordAudio();
            } else {
                requestPermission(MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO, Manifest.permission.WRITE_EXTERNAL_STORAGE, Manifest.permission.RECORD_AUDIO);
            }
        }
    }


    @Override
    public void queryByContentSuccess(String content, String from, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(content, searchRegionDatas.size(), from);
        if (searchRegionDatas.size() == 0) {
            T.showShort(getString(R.string.epath_no_search_result, content));
        } else {
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_CONTENT, content);
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            setResult(RESULT_OK, intent);
            finish();
        }
    }

    @Override
    public void queryByGenreSuccess(LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> list) {

    }

    @Override
    public void queryRegionIconDataSuccess(List<LocationRegionIconData> locationRegionIconDatas) {

    }

    @Override
    public void queryRegionTagDataSuccess(List<LocationRegionTagData> locationRegionTagDatas) {

    }

    @Override
    public void queryHotGenreSuccess(List<String> tags, List<LocationRegionIconData> locationRegionIconDatas) {

    }
}
