package com.epath.shitu.epathmap.presenter;

import com.epath.shitu.epathmap.base.BasePresenter;

import com.epath.shitu.epathmap.presenter.IView.EpathSearchView;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.LocationRegionIconData;
import com.shitu.location.epathmap.model.bean.LocationRegionTagData;
import com.shitu.location.epathmap.model.parse.POI;
import com.shitu.location.epathmap.model.parse.POIGenre;
import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.model.parse.Synonym;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.shitu.location.epathmap.model.bean.LocationRegionData;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * author:lfei
 */
public class EpathSearchPresenter extends BasePresenter<EpathSearchView> {

    private List<LocationRegionIconData> locationRegionIconDatas = new ArrayList<>();
    private List<LocationRegionTagData> locationRegionTagDatas = new ArrayList<>();

    private void queryByContent(String id, List<String> synonyms, String from, ArrayList<LocationRegionData> locationRegionDatas) {
        if (synonyms == null || synonyms.size() == 0) {
            return;
        }
        String content = synonyms.get(0);
        ParseObject parseObject = ParseObject.createWithoutData("MappingProject", id);
        List<ParseQuery<POI>> queries = new ArrayList<>();
        for (int i = 0; i < synonyms.size(); i++) {
            String synonym = synonyms.get(i);
            ParseQuery<POI> poiParseQuery = ParseQuery.getQuery(POI.class)
                    .whereEqualTo("project", parseObject)
                    .whereContains("name", synonym);

            ParseQuery<POI> poiParseQuery1 = ParseQuery.getQuery(POI.class)
                    .whereEqualTo("project", parseObject)
                    .whereContains("name", synonym.toUpperCase());

            ParseQuery<POI> poiParseQuery2 = ParseQuery.getQuery(POI.class)
                    .whereEqualTo("project", parseObject)
                    .whereContains("name", synonym.toLowerCase());

            queries.add(poiParseQuery);
            queries.add(poiParseQuery1);
            queries.add(poiParseQuery2);
        }
        ParseQuery.or(queries)
                .orderByAscending("floor")
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    ArrayList<LocationRegionData> searchRegionDatas = new ArrayList<>();
                    if (objects.size() > 0) {
                        for (POI poi : objects) {
                            LocationRegionData data = new LocationRegionData(poi.getName(), poi.getFloorName(),
                                    poi.getLongitude(), poi.getLatitude());
                            searchRegionDatas.add(data);
                        }
                    }
                    for (LocationRegionData locationRegionData : locationRegionDatas) {
                        if (locationRegionData.getName().toUpperCase().contains(content.toUpperCase())) {
                            searchRegionDatas.add(locationRegionData);
                            continue;
                        }
                    }
                    if (isViewAttached()) {
                        getView().queryByContentSuccess(content, from, searchRegionDatas);
                    }
                });
    }

    public void queryByContent(String id, String content, String from, ArrayList<LocationRegionData> locationRegionDatas) {
        List<String> synonyms = new ArrayList<>();
        ParseQuery.getQuery(Synonym.class)
                .whereEqualTo(Synonym.SYNONYM, content)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    if (objects.size() > 0) {
                        JSONArray jsonArray = objects.get(0).getJSONArray(Synonym.SYNONYM);
                        for (int i = 0; i < jsonArray.length(); i++) {
                            synonyms.add(jsonArray.optString(i));
                        }
                    }
                    if (synonyms.size() == 0) {
                        synonyms.add(content);
                    }
                    queryByContent(id, synonyms, from, locationRegionDatas);
                });

    }

    public void queryByGenre(String id, LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> locationRegionDatas) {
        if (locationRegionIconData.isUseMap()) {
            ArrayList<LocationRegionData> searchRegionDatas = new ArrayList<>();
            for (LocationRegionData item : locationRegionDatas) {
                String type = item.getType();
                String subType = item.getSubtype();
                String type2 = locationRegionIconData.getType();
                String subType2 = locationRegionIconData.getSubtype();
                if (type != null && type2 != null && type.equals(type2) &&
                        subType != null && subType2 != null && subType.equals(subType2)) {
                    searchRegionDatas.add(item);
                } else if (type != null && type2 != null && type.equals(type2) && subType2 == null) {
                    searchRegionDatas.add(item);
                }
            }
            if (isViewAttached()) {
                getView().queryByGenreSuccess(locationRegionIconData, searchRegionDatas);
            }
            return;
        }
        ParseObject projectObject = ParseObject.createWithoutData("MappingProject", id);
        ParseQuery.getQuery(POI.class).whereEqualTo("project", projectObject)
                .whereMatchesQuery("genre", ParseQuery.getQuery(POIGenre.class)
                        .whereEqualTo("objectId", locationRegionIconData.getObjectId()))
                .addAscendingOrder("floor")
                .addAscendingOrder("name")
                .setLimit(1000)
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    ArrayList<LocationRegionData> searchRegionDatas = new ArrayList<>();
                    for (POI poi : objects) {
                        LocationRegionData data = new LocationRegionData(poi.getName(), poi.getFloorName(),
                                poi.getLongitude(), poi.getLatitude());
                        searchRegionDatas.add(data);
                    }
                    if (isViewAttached()) {
                        getView().queryByGenreSuccess(locationRegionIconData, searchRegionDatas);
                    }
                });
    }

    public void querySearchViewData(String id) {
        ParseQuery.getQuery(Project.class)
                .include("genre")
                .orderByAscending("order")
                .setLimit(1000)
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .getInBackground(id, (object, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    object.getGenres().getQuery()
                            .whereEqualTo("isIcon", true)
                            .orderByAscending("order")
                            .whereNotEqualTo("visible", false)
                            .setLimit(1000)
                            .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                            .findInBackground((objects, e1) -> {
                                if (e1 != null) {
                                    handleError(e1);
                                    return;
                                }
                                locationRegionIconDatas.clear();
                                for (POIGenre poiGenre : objects) {
                                    LocationRegionIconData locationRegionIconData = new LocationRegionIconData();
                                    locationRegionIconData.setObjectId(poiGenre.getObjectId());
                                    locationRegionIconData.setName(poiGenre.getName());
                                    locationRegionIconData.setType(poiGenre.getType());
                                    locationRegionIconData.setSubtype(poiGenre.getSubtype());
                                    locationRegionIconData.setIconUrl(poiGenre.getIconUrl());
                                    locationRegionIconData.setOrder(poiGenre.getOrder());
                                    locationRegionIconData.setUseMap(poiGenre.useMap());
                                    locationRegionIconDatas.add(locationRegionIconData);
                                }
                                if (isViewAttached()) {
                                    getView().queryRegionIconDataSuccess(locationRegionIconDatas);
                                }
                            });
                });

        ParseQuery.getQuery(POI.class)
                .whereEqualTo("project", ParseObject.createWithoutData("MappingProject", id))
                .whereNotEqualTo("genre", null)
                .include("genre")
                .setLimit(1000)
                .whereMatchesQuery("genre",
                        ParseQuery.getQuery(POIGenre.class)
                                .whereEqualTo("isIcon", false)
                                .whereNotEqualTo("visible", false))
                .orderByAscending("genre")
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    locationRegionTagDatas.clear();
                    if (objects.size() > 0) {
                        List<LocationRegionData> locationRegionDatas = new ArrayList<>();
                        POI poi = objects.get(0);
                        POIGenre poiGenre = (POIGenre) poi.getGenre();
                        LocationRegionTagData locationRegionTagData = new LocationRegionTagData();
                        locationRegionTagData.setName(poiGenre.getName());
                        locationRegionTagData.setType(poiGenre.getType());
                        locationRegionTagData.setUseMap(poiGenre.useMap());
                        locationRegionTagData.setOrder(poiGenre.getOrder());
                        locationRegionTagData.setIconUrl(poiGenre.getIconUrl());
                        locationRegionDatas.add(new LocationRegionData(poi.getName(), poi.getFloorName(),
                                poi.getLongitude(), poi.getLatitude(), poi.getOrder(), poi.getIconUrl()));
                        for (int i = 1; i < objects.size(); i++) {
                            POI poi2 = objects.get(i);
                            POIGenre poiGenre2 = (POIGenre) poi2.getGenre();
                            if (poiGenre.getName().equals(poiGenre2.getName())) {
                                locationRegionDatas.add(new LocationRegionData(poi2.getName(), poi2.getFloorName(),
                                        poi2.getLongitude(), poi2.getLatitude(), poi2.getOrder(),
                                        poi2.getIconUrl()));
                            } else {
                                Collections.sort(locationRegionDatas);
                                locationRegionTagData.setLocationRegionDatas(locationRegionDatas);
                                locationRegionTagDatas.add(locationRegionTagData);
                                poi = poi2;
                                poiGenre = poiGenre2;
                                locationRegionTagData = new LocationRegionTagData();
                                locationRegionTagData.setName(poiGenre.getName());
                                locationRegionTagData.setType(poiGenre.getType());
                                locationRegionTagData.setUseMap(poiGenre.useMap());
                                locationRegionTagData.setOrder(poiGenre.getOrder());
                                locationRegionTagData.setIconUrl(poiGenre.getIconUrl());
                                locationRegionDatas = new ArrayList<>();
                                locationRegionDatas.add(new LocationRegionData(poi.getName(), poi.getFloorName(),
                                        poi.getLongitude(), poi.getLatitude(), poi.getOrder(),
                                        poi.getIconUrl()));
                            }
                        }
                        Collections.sort(locationRegionDatas);
                        locationRegionTagData.setLocationRegionDatas(locationRegionDatas);
                        locationRegionTagDatas.add(locationRegionTagData);
                        Collections.sort(locationRegionTagDatas);
                    }
                    if (isViewAttached()) {
                        getView().queryRegionTagDataSuccess(locationRegionTagDatas);
                    }
                });
    }

    public void queryHotGenre(String id) {
        ParseQuery.getQuery(Project.class)
                .include("genre")
                .orderByAscending("order")
                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .getInBackground(id, (object, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    object.getGenres().getQuery()
                            .whereEqualTo("hot", true)
                            .orderByAscending("order")
                            .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                            .findInBackground((objects, e1) -> {
                                if (e1 != null) {
                                    handleError(e1);
                                    return;
                                }
                                locationRegionIconDatas.clear();
                                List<String> tags = new ArrayList<>();
                                for (POIGenre poiGenre : objects) {
                                    tags.add(poiGenre.getName());
                                    LocationRegionIconData locationRegionIconData = new LocationRegionIconData();
                                    locationRegionIconData.setName(poiGenre.getName());
                                    locationRegionIconData.setType(poiGenre.getType());
                                    locationRegionIconData.setSubtype(poiGenre.getSubtype());
                                    locationRegionIconData.setIconUrl(poiGenre.getIconUrl());
                                    locationRegionIconData.setOrder(poiGenre.getOrder());
                                    locationRegionIconData.setUseMap(poiGenre.useMap());
                                    locationRegionIconDatas.add(locationRegionIconData);
                                }
                                if (isViewAttached()) {
                                    getView().queryHotGenreSuccess(tags, locationRegionIconDatas);
                                }
                            });
                });
    }
}
