package com.epath.shitu.epathmap.base;

import com.shitu.location.epathmap.utils.EpException;
import com.parse.ParseException;

/**
 * author:lfei
 */
public class BasePresenter<T extends IBaseView> implements IPresenter<T> {

    private T mView;

    @Override
    public void attachView(T mvpView) {
        this.mView = mvpView;
    }

    @Override
    public void detachView() {
        this.mView = null;
    }

    public boolean isViewAttached() {
        return mView != null;
    }

    public T getView() {
        return mView;
    }

    public void checkViewAttached() {
        if (!isViewAttached()) throw new MvpViewNotAttachedException();
    }


    public static class MvpViewNotAttachedException extends RuntimeException {
        public MvpViewNotAttachedException() {
            super("Please call Presenter.attachView(MvpView) before" +
                    " requesting data to the Presenter");
        }
    }

    public void handleError(ParseException e) {
        e.printStackTrace();
        EpException epException = new EpException(e, e.getCode());
        if (isViewAttached()) {
            getView().handleThrowable(epException);
        }
    }


}