/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.text.TextUtils;
import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.ResponseHandlerInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

class SimpleMultipartEntity
implements HttpEntity {
    private static final String LOG_TAG = "SimpleMultipartEntity";
    private static final String STR_CR_LF = "\r\n";
    private static final byte[] CR_LF = "\r\n".getBytes();
    private static final byte[] TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: binary\r\n".getBytes();
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final String boundary;
    private final byte[] boundaryLine;
    private final byte[] boundaryEnd;
    private boolean isRepeatable;
    private final List<FilePart> fileParts = new ArrayList<FilePart>();
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ResponseHandlerInterface progressHandler;
    private long bytesWritten;
    private long totalSize;

    public SimpleMultipartEntity(ResponseHandlerInterface responseHandlerInterface) {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        for (int i2 = 0; i2 < 30; ++i2) {
            stringBuilder.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        this.boundary = stringBuilder.toString();
        this.boundaryLine = ("--" + this.boundary + STR_CR_LF).getBytes();
        this.boundaryEnd = ("--" + this.boundary + "--\r\n").getBytes();
        this.progressHandler = responseHandlerInterface;
    }

    public void addPart(String string, String string2, String string3) {
        try {
            this.out.write(this.boundaryLine);
            this.out.write(this.createContentDisposition(string));
            this.out.write(this.createContentType(string3));
            this.out.write(CR_LF);
            this.out.write(string2.getBytes());
            this.out.write(CR_LF);
            return;
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.e(LOG_TAG, "addPart ByteArrayOutputStream exception", iOException);
            return;
        }
    }

    public void addPartWithCharset(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "UTF-8";
        }
        this.addPart(string, string2, "text/plain; charset=".concat(String.valueOf(string3)));
    }

    public void addPart(String string, String string2) {
        this.addPartWithCharset(string, string2, null);
    }

    public void addPart(String string, File file) {
        this.addPart(string, file, null);
    }

    public void addPart(String string, File file, String string2) {
        this.fileParts.add(new FilePart(string, file, this.normalizeContentType(string2)));
    }

    public void addPart(String string, File file, String string2, String string3) {
        this.fileParts.add(new FilePart(string, file, this.normalizeContentType(string2), string3));
    }

    public void addPart(String object, String string, InputStream inputStream, String string2) throws IOException {
        int n2;
        this.out.write(this.boundaryLine);
        this.out.write(this.createContentDisposition((String)object, string));
        this.out.write(this.createContentType(string2));
        this.out.write(TRANSFER_ENCODING_BINARY);
        this.out.write(CR_LF);
        object = new byte[4096];
        while ((n2 = inputStream.read((byte[])object)) != -1) {
            this.out.write((byte[])object, 0, n2);
        }
        this.out.write(CR_LF);
        this.out.flush();
    }

    private String normalizeContentType(String string) {
        if (string == null) {
            return "application/octet-stream";
        }
        return string;
    }

    private byte[] createContentType(String string) {
        return ("Content-Type: " + this.normalizeContentType(string) + STR_CR_LF).getBytes();
    }

    private byte[] createContentDisposition(String string) {
        return ("Content-Disposition: form-data; name=\"" + string + "\"\r\n").getBytes();
    }

    private byte[] createContentDisposition(String string, String string2) {
        return ("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string2 + "\"\r\n").getBytes();
    }

    private void updateProgress(long l2) {
        this.bytesWritten += l2;
        this.progressHandler.sendProgressMessage(this.bytesWritten, this.totalSize);
    }

    public long getContentLength() {
        long l2 = this.out.size();
        Iterator<FilePart> iterator = this.fileParts.iterator();
        while (iterator.hasNext()) {
            long l3 = iterator.next().getTotalLength();
            if (l3 < 0L) {
                return -1L;
            }
            l2 += l3;
        }
        return l2 + (long)this.boundaryEnd.length;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public boolean isChunked() {
        return false;
    }

    public void setIsRepeatable(boolean bl2) {
        this.isRepeatable = bl2;
    }

    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    public boolean isStreaming() {
        return false;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.bytesWritten = 0L;
        this.totalSize = (int)this.getContentLength();
        this.out.writeTo(outputStream);
        SimpleMultipartEntity simpleMultipartEntity = this;
        simpleMultipartEntity.updateProgress(simpleMultipartEntity.out.size());
        Iterator<FilePart> iterator = this.fileParts.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeTo(outputStream);
        }
        outputStream.write(this.boundaryEnd);
        SimpleMultipartEntity simpleMultipartEntity2 = this;
        simpleMultipartEntity2.updateProgress(simpleMultipartEntity2.boundaryEnd.length);
    }

    public Header getContentEncoding() {
        return null;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getContent() is not supported. Use writeTo() instead.");
    }

    private class FilePart {
        public File file;
        public byte[] header;

        public FilePart(String string, File file, String string2, String string3) {
            this.header = this.createHeader(string, TextUtils.isEmpty((CharSequence)string3) ? file.getName() : string3, string2);
            this.file = file;
        }

        public FilePart(String string, File file, String string2) {
            this.header = this.createHeader(string, file.getName(), string2);
            this.file = file;
        }

        private byte[] createHeader(String string, String string2, String string3) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(SimpleMultipartEntity.this.boundaryLine);
                byteArrayOutputStream.write(SimpleMultipartEntity.this.createContentDisposition(string, string2));
                byteArrayOutputStream.write(SimpleMultipartEntity.this.createContentType(string3));
                byteArrayOutputStream.write(TRANSFER_ENCODING_BINARY);
                byteArrayOutputStream.write(CR_LF);
            }
            catch (IOException iOException) {
                AsyncHttpClient.log.e(SimpleMultipartEntity.LOG_TAG, "createHeader ByteArrayOutputStream exception", iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }

        public long getTotalLength() {
            long l2 = this.file.length() + (long)CR_LF.length;
            return (long)this.header.length + l2;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            int n2;
            outputStream.write(this.header);
            SimpleMultipartEntity.this.updateProgress(this.header.length);
            FileInputStream fileInputStream = new FileInputStream(this.file);
            byte[] byArray = new byte[4096];
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                SimpleMultipartEntity.this.updateProgress(n2);
            }
            outputStream.write(CR_LF);
            SimpleMultipartEntity.this.updateProgress(CR_LF.length);
            outputStream.flush();
            AsyncHttpClient.silentCloseInputStream(fileInputStream);
        }
    }
}

