package com.epath.shitu.epathmap.ui.widget;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

public class RotateCameraXImageView extends android.support.v7.widget.AppCompatImageView {

    private Camera camera;
    private int measuredHeight;
    private int measuredWidth;
    private int centerY;
    private int centerX;

    public RotateCameraXImageView(Context context) {
        this(context,null);
    }

    public RotateCameraXImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs,0);
    }

    public RotateCameraXImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        init();
    }

    private void init(){
        camera = new Camera();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        measuredHeight = getMeasuredHeight();
        measuredWidth = getMeasuredWidth();

        centerY = measuredHeight / 2;
        centerX = measuredWidth / 2;

    }

    @Override
    protected void onDraw(Canvas canvas) {

        int save = canvas.save();
        camera.save();
        camera.rotateX(45);

        canvas.translate(centerX,centerY);

        camera.applyToCanvas(canvas);

        camera.restore();

        canvas.translate(-centerX,-centerY);

        super.onDraw(canvas);

        canvas.restoreToCount(save);

    }

}
