package com.epath.shitu.epathmap.ui.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;

import com.epath.shitu.epathmap.R;

import com.epath.shitu.epathmap.ui.adapter.BaseRecyclerAdapter;
import com.epath.shitu.epathmap.ui.item.OnItemClickListener;
import com.epath.shitu.epathmap.ui.item.RegionSearchDataItem;
import com.epath.shitu.epathmap.ui.utils.FixLinearLayoutManager;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.model.bean.LocationRegionData;

import java.util.List;

public class RegionSearchDialog {

    private Context context;
    private BottomSheetBehavior dialog;
    private RecyclerView recyclerView;
    private LinearLayout llLine, llMore;
    private View contentView;
    private BaseRecyclerAdapter adapter;
    private int height, currentHeight;

    public RegionSearchDialog(Context context, View contentView, List<LocationRegionData> list, String type, OnItemClickListener onItemClickListener,
                              OnItemClickListener onNavClickListener) {
        this.context = context;
        this.contentView = contentView;
        recyclerView = (RecyclerView) contentView.findViewById(R.id.recyclerView);
        llLine = (LinearLayout) contentView.findViewById(R.id.ll_line);
        llMore = (LinearLayout) contentView.findViewById(R.id.ll_more);
        llLine.setOnClickListener(view -> dismiss());
        llMore.setOnClickListener(v -> show());
        FixLinearLayoutManager layoutManager = new FixLinearLayoutManager(context, LinearLayoutManager.VERTICAL, false);
        layoutManager.setRecycleChildrenOnDetach(true);
        recyclerView.setLayoutManager(layoutManager);
        if (list.size() > 0) {
            list.get(0).setSelected(true);
        }
        adapter = new BaseRecyclerAdapter(list);
        RegionSearchDataItem item = new RegionSearchDataItem(context, type);
        item.setOnItemClickListener(position -> {
            onItemClickListener.onClick(position);
            for (LocationRegionData locationRegionData : list) {
                locationRegionData.setSelected(false);
            }
            list.get(position).setSelected(true);
            adapter.notifyDataSetChanged();
        });
        item.setOnItemNavClickListener(position -> {
            onNavClickListener.onClick(position);
            dismiss();
        });
        adapter.addItemFactory(item);
        recyclerView.setAdapter(adapter);

        int size = list.size();
        if (size > 3) {
            size = 3;
        }
        height = DensityUtils.dp2px(context, 20 + 80 * size);
        currentHeight = height;
        dialog = BottomSheetBehavior.from(contentView);
        dismiss();
        int margin = DensityUtils.dp2px(context, 16);

//        CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
//                DensityUtils.getScreenWidth(context) - margin * 2,
//                height);
//        lp.setMargins(margin, 0, margin, 0);

        CoordinatorLayout.LayoutParams lp = new CoordinatorLayout.LayoutParams(
                DensityUtils.getScreenWidth(context),
                height);
//        lp.setMargins(margin, 0, margin, 0);

        lp.setBehavior(dialog);
        contentView.setLayoutParams(lp);
    }

    public int getCurrentHeight() {
        return currentHeight;
    }

    public void show() {
        if (dialog != null) {
            contentView.setVisibility(View.VISIBLE);
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
        }
    }

    public void setOnDismissListener(BottomSheetSlideListener bottomSheetSlideListener) {
        dialog.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback() {

            @Override
            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                try {
                    switch (newState) {
                        case BottomSheetBehavior.STATE_HIDDEN:

                            break;
                        case BottomSheetBehavior.STATE_COLLAPSED:
                            currentHeight = DensityUtils.dp2px(context, 40);
                            llMore.setVisibility(View.VISIBLE);
                            llLine.setVisibility(View.GONE);
                            break;
                        case BottomSheetBehavior.STATE_EXPANDED:
                            currentHeight = height;
                            llMore.setVisibility(View.GONE);
                            llLine.setVisibility(View.VISIBLE);
                            break;
                    }
                    bottomSheetSlideListener.onStateChanged(newState);
                } catch (Exception e) {
                    L.e("bottomSheet", e.toString());
                }


            }

            @Override
            public void onSlide(@NonNull View bottomSheet, float slideOffset) {

            }
        });
    }

    public void dismiss() {
        if (dialog != null && dialog.getState() != BottomSheetBehavior.STATE_HIDDEN) {
            dialog.setState(BottomSheetBehavior.STATE_HIDDEN);
            contentView.setVisibility(View.GONE);
        }
    }

    public interface BottomSheetSlideListener {
        void onStateChanged(int state);
    }

}
