package com.epath.shitu.epathmap.ui.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.epath.shitu.epathmap.EpathMapSDK;
import com.epath.shitu.epathmap.R;
import com.epath.shitu.epathmap.ui.utils.TextViewUtilis;
import com.shitu.location.epathmap.utils.L;

/**
 * 点击地图区块弹窗
 */
public class RegionDialog {

    private final RegionDismissListener onDismissListener;
    private PopupWindow popupWindow;
    private BottomSheetDialog sheetDialog;
    private BottomSheetBehavior dialog;


    private View contentView;
    private TextView tvRegionName;
    private TextView tvFloorName;
    private LinearLayout llBottom;
    private Context context;

    public RegionDialog(Context context,
                        View contentView,
                        View.OnClickListener onNavBtnClickListener,
                        View.OnClickListener sendLocationClickListener,
                        RegionDismissListener onDismissListener) {
        this.context = context;
//        LayoutInflater inflater = LayoutInflater.from(context);
//        contentView = inflater.inflate(R.layout.dialog_region, null);
        this.contentView = contentView;
        tvRegionName = (TextView) contentView.findViewById(R.id.tv_region_name);
        tvFloorName = (TextView) contentView.findViewById(R.id.tv_floor_name);
        llBottom = (LinearLayout) contentView.findViewById(R.id.ll_bottom);

        contentView.findViewById(R.id.iv_nav).setOnClickListener(onNavBtnClickListener);
        contentView.findViewById(R.id.tv_send_loc).setOnClickListener(sendLocationClickListener);

        this.onDismissListener = onDismissListener;

//        sheetDialog = new BottomSheetDialog(context);
//        sheetDialog.setContentView(contentView);
//        sheetDialog.setOnDismissListener(onDismissListener);
//        sheetDialog.getWindow().setDimAmount(0);

        dialog = BottomSheetBehavior.from(contentView);


        contentView.findViewById(R.id.fl_close).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                expandOrCollapsed();
            }
        });

        setOnDismissListener();

//        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
//                ViewGroup.LayoutParams.WRAP_CONTENT, false);
//        popupWindow.setOutsideTouchable(false);
//        popupWindow.setAnimationStyle(R.style.EpathDialogBottom);
    }

    public void setRegionName(String name) {
        if (name.contains("(") && name.contains(")")) {
            tvRegionName.setText(TextViewUtilis.setPartColor(context, name, name.lastIndexOf("("), name.length(), R.color.tvGrey3));
        } else {
            tvRegionName.setText(name);
        }
    }

    public void setFloorName(String name) {
        tvFloorName.setText(name);
    }

    public void show(View view) {
//        if (sheetDialog.isShowing()) {
//            return;
//        }

        if (dialog != null) {
            contentView.setVisibility(View.VISIBLE);
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
        }

        if (EpathMapSDK.getShareToWechatListener() == null) {
            llBottom.setVisibility(View.GONE);
        } else {
            llBottom.setVisibility(View.VISIBLE);
        }
//        sheetDialog.show();
//        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public void dismiss() {
//        if (sheetDialog != null && sheetDialog.isShowing()) {
//            sheetDialog.dismiss();
//        }

        if (dialog != null && dialog.getState() != BottomSheetBehavior.STATE_HIDDEN) {
            dialog.setState(BottomSheetBehavior.STATE_HIDDEN);
            contentView.setVisibility(View.GONE);
        }
    }

    public void setBottomVisible(boolean visible) {
        if (visible) {
            llBottom.setVisibility(View.VISIBLE);
        } else {
            llBottom.setVisibility(View.GONE);
        }
    }

    public String getRegionName() {
        return tvRegionName.getText().toString();
    }

    public String getFloorName() {
        String name = tvFloorName.getText().toString();
        if (name.startsWith("在")) {
            name = name.substring(1, name.length());
        }
        return name;
    }

    public void setOnDismissListener() {
        dialog.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback() {

            @Override
            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                try {
                    switch (newState) {
                        case BottomSheetBehavior.STATE_HIDDEN:
//                            onDismissListener.onDismiss();
                            break;
                        case BottomSheetBehavior.STATE_COLLAPSED:
                            onDismissListener.onDismiss();
                            dismiss();
                            break;
                        case BottomSheetBehavior.STATE_EXPANDED:

                            break;
                    }
                } catch (Exception e) {
                    L.e("bottomSheet", e.toString());
                }
            }

            @Override
            public void onSlide(@NonNull View bottomSheet, float slideOffset) {

            }
        });
    }


    public void expandOrCollapsed() {
        if (dialog != null && dialog.getState() == BottomSheetBehavior.STATE_EXPANDED) {
            dialog.setState(BottomSheetBehavior.STATE_COLLAPSED);
        } else if (dialog != null && dialog.getState() == BottomSheetBehavior.STATE_COLLAPSED) {
            dialog.setState(BottomSheetBehavior.STATE_EXPANDED);
        }
    }


    public interface RegionDismissListener{
        void onDismiss();
    }


}
