package com.epath.shitu.epathmap.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.Nullable;

import com.epath.shitu.epathmap.R;


import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.utils.EpException;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.epathmap.utils.TUtil;
import com.parse.ParseException;

/**
 * author:lfei
 */
public abstract class BaseEpathActivity<P extends BasePresenter> extends BaseActivity implements IBaseView {

    public P presenter;
    public Project project;
    public Vibrator vibrator;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        presenter = TUtil.getT(this, 0);
        presenter.attachView(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onDestroy() {
        presenter.detachView();
        if (vibrator != null) {
            vibrator.cancel();
        }
        super.onDestroy();
    }

    @Override
    public void handleThrowable(EpException ex) {
        String message = ex.getMsg();
        if (ex.getCode() == ParseException.OBJECT_NOT_FOUND) {
            T.showShort(R.string.epath_no_result);
        } else if (ex.getCode() != ParseException.CACHE_MISS) {
            T.showShort(message);
        }
    }

    /**
     * 手机振动服务
     */
    public void vibrate() {
        vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        long[] pattern = {0, 200};
        vibrator.vibrate(pattern, -1);
    }


}
