package com.shitu.epathmap.utils.voice;

import android.content.Context;
import android.text.TextUtils;

import com.baidu.tts.chainofresponsibility.logger.LoggerProxy;
import com.baidu.tts.client.SpeechError;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.SynthesizerTool;
import com.baidu.tts.client.TtsMode;
import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;
import com.shitu.epathmap.utils.NumUtil;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.utils.Constants;
import com.shitu.location.epathmap.utils.EpConstants;
import com.shitu.location.epathmap.utils.L;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * author:lfei
 */

public class VoiceManager implements SpeechListener {

    Context context;
    private Speecher speecher;
    ArrayList<String> speakList = new ArrayList<>();
    private TimerSpeakTask task;
    private boolean isStartFlag = false;
    private String lastBuilding;
    static long temp = 0;
    static Date curentTime = null;
    private Boolean isPlaying = false;
    private long timeStep;
    private String asseFiletMD5Speech;
    private String asseFiletMD5Text;
    private ScheduledExecutorService scheduledThreadPool;

    // 定义一个私有构造方法
    private VoiceManager() {

    }

    //定义一个静态私有变量(不初始化，不使用final关键字，使用volatile保证了多线程访问时instance变量的可见性，避免了instance初始化时其他变量属性还没赋值完时，被另外线程调用)
    private static volatile VoiceManager instance;

    //定义一个共有的静态方法，返回该类型实例
    public static VoiceManager getInstance(Context context,String configs) {
        // 对象实例化时与否判断（不使用同步代码块，instance不等于null时，直接返回对象，提高运行效率）
        if (instance == null) {
            //同步代码块（对象未初始化时，使用同步代码块，保证多线程访问时对象在第一次创建后，不再重复被创建）
            synchronized (VoiceManager.class) {
                //未初始化，则初始instance变量
                if (instance == null) {
                    instance = new VoiceManager(context,configs);
                    temp = System.currentTimeMillis() - 5000;
                }
            }
        }
        return instance;
    }

    private VoiceManager(Context context,String configs) {
        this.context = context;
        scheduledThreadPool = Executors.newScheduledThreadPool(1);
        task = new TimerSpeakTask();
        startNavTimerTask();
        speecher = SpeecherFactory.provideSpeecher(context,configs,this);
    }

    private void startNavTimerTask() {
        scheduledThreadPool.scheduleAtFixedRate(task,0,100,TimeUnit.MILLISECONDS);
        isStartFlag = true;
    }

    public void stopSpeaking() {
        if (speecher != null) {
            speecher.stop();
        }
    }

    @Override
    public void onSpeechFinish() {
        curentTime = new Date();
        temp = curentTime.getTime();
        isPlaying = false;
    }

    @Override
    public void onError() {
        curentTime = new Date();
        isPlaying = false;
        temp = curentTime.getTime();
    }

    @Override
    public void onSpeechStart() {
        isPlaying = true;

    }

    private class TimerSpeakTask extends TimerTask {
        @Override
        public void run() {
            if (!speakList.isEmpty()) {
                kdxfTextToVoice(speakList.remove(0));
            }
        }
    }

    //添加到集合进行任务添加播报
    public boolean textToVoice(String s) {
        //判断是否在播放其他的,如果正在播放不添加到播报里面
        if (!isPlaying) {
            //没有忙 ,可以添加到队列里面
            //判断是否已经结束后的时间是否 > 3
            curentTime = new Date();
            timeStep = curentTime.getTime() - temp;
            if (timeStep > EpConstants.VOICE_TIMER_STEP) {
                speakList.add(s);
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public void kdxfTextToVoice(String s) {
        //需要合成的文本text的长度不能超过1024个GBK字节。
        int result = runSpeak(s, curentTime + "");
        if (result < 0) {
            toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
        }
    }


    public void clear() {
        speakList.clear();
    }

    public void destroy() {
        speecher.release();
        scheduledThreadPool.shutdown();
        isStartFlag = false;
        instance = null;
    }

    //强制播报信息,取消之前的播报信息
    public boolean textToVoice(String s, boolean isForcePlay) {
        //需要合成的文本text的长度不能超过1024个GBK字节。
        if (isForcePlay) {
            clear();
            speecher.stop();
            int result = runSpeak(s,(String)null);
            //        int result = this.mSpeechSynthesizer.synthesize();
            if (result < 0) {
                toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
            }
            return true;
        } else {
            return textToVoice(s);
        }
    }

    private String replaceNumberIfEn(String s) {
        if(!Locale.getDefault().getLanguage().equals("zh")){
            if(s.contains("120")){
                s = s.replace("120","One hundred and twenty");
            }else if(s.contains("45")){
                s = s.replace("45","Forty-five");
            }
            String regEx="[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(s);
            String num = m.replaceAll("").trim();
            if(!TextUtils.isEmpty(num)){
                return s.replace(num,NumUtil.analyze(num));
            }
        }
            return s;
    }

    public boolean textToVoiceFloor(String s, boolean isForcePlay) {
        if (!TextUtils.isEmpty(s)) {
            s = s.replace("-", context.getString(R.string.epath_negative));
        }
        //需要合成的文本text的长度不能超过1024个GBK字节。
        if (isForcePlay) {
            clear();
            speecher.stop();
            int result = runSpeak(s,(String)null);
            //        int result = this.mSpeechSynthesizer.synthesize();
            if (result < 0) {
                toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
            }
            return true;
        } else {
            return textToVoice(s);
        }
    }

    private int runSpeak(String s,String utteranceld) {
            return this.speecher.speak(s, utteranceld);
    }

    public void toPrint(String str) {
        L.d("kdxf---", str);
    }
}
