/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.utils.voice.aws;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.Log;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.polly.AmazonPollyPresigningClient;
import com.amazonaws.services.polly.model.DescribeVoicesRequest;
import com.amazonaws.services.polly.model.OutputFormat;
import com.amazonaws.services.polly.model.SynthesizeSpeechPresignRequest;
import com.amazonaws.services.polly.model.Voice;
import com.shitu.epathmap.utils.voice.SpeechListener;
import com.shitu.epathmap.utils.voice.Speecher;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;

public class AwsSpeecher
implements Speecher {
    private String COGNITO_POOL_ID;
    Regions MY_REGION;
    private URL presignedSynthesizeSpeechUrl;
    private String TAG = "AwsSpeecher";
    private Context context;
    MediaPlayer mediaPlayer;
    private AmazonPollyPresigningClient client;
    private Voice enVoice;
    private Voice zhVoice;
    private SpeechListener speechListener;

    public AwsSpeecher(Context context, List<String> list) {
        this.context = context.getApplicationContext();
        this.COGNITO_POOL_ID = list.get(0);
        this.MY_REGION = Regions.fromName((String)list.get(1));
        new Thread(){

            @Override
            public void run() {
                AwsSpeecher.this.initPolly();
            }
        }.start();
        this.setupNewMediaPlayer();
    }

    private void initPolly() {
        Object object = new CognitoCachingCredentialsProvider(this.context, this.COGNITO_POOL_ID, this.MY_REGION);
        this.client = new AmazonPollyPresigningClient((AWSCredentialsProvider)object);
        object = new DescribeVoicesRequest();
        object = this.client.describeVoices((DescribeVoicesRequest)object).getVoices();
        this.enVoice = null;
        object = object.iterator();
        while (object.hasNext()) {
            Voice voice = (Voice)object.next();
            if ("Salli".equals(voice.getName())) {
                this.enVoice = voice;
                continue;
            }
            if (!"Zhiyu".equals(voice.getName())) continue;
            this.zhVoice = voice;
        }
    }

    void setupNewMediaPlayer() {
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (AwsSpeecher.this.speechListener != null) {
                    AwsSpeecher.this.speechListener.onSpeechFinish();
                }
                mediaPlayer.release();
                AwsSpeecher.this.setupNewMediaPlayer();
            }
        });
        this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (AwsSpeecher.this.speechListener != null) {
                    AwsSpeecher.this.speechListener.onSpeechStart();
                }
                mediaPlayer.start();
            }
        });
        this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                if (AwsSpeecher.this.speechListener != null) {
                    AwsSpeecher.this.speechListener.onError();
                }
                return false;
            }
        });
    }

    public void playVoice(String object) {
        object = new SynthesizeSpeechPresignRequest().withText((String)object).withVoiceId(Locale.getDefault().getLanguage().equals("zh") ? this.zhVoice.getId() : this.enVoice.getId()).withOutputFormat(OutputFormat.Mp3);
        object = this.client.getPresignedSynthesizeSpeechUrl((SynthesizeSpeechPresignRequest)object);
        Log.i((String)this.TAG, (String)("Playing speech from presigned URL: " + object));
        if (this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.setupNewMediaPlayer();
        }
        this.mediaPlayer.setAudioStreamType(3);
        try {
            this.mediaPlayer.setDataSource(((URL)object).toString());
        }
        catch (IOException iOException) {
            Log.e((String)this.TAG, (String)("Unable to set data source for the media player! " + iOException.getMessage()));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        try {
            this.mediaPlayer.prepareAsync();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public int speak(String string2) {
        this.playVoice(string2);
        return 0;
    }

    @Override
    public int speak(String string2, String string3) {
        this.playVoice(string2);
        return 0;
    }

    @Override
    public int pause() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
        }
        return 0;
    }

    @Override
    public int resume() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        return 0;
    }

    @Override
    public int stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.setupNewMediaPlayer();
        }
        return 0;
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.setupNewMediaPlayer();
        }
    }

    @Override
    public void setSpeechListener(SpeechListener speechListener) {
        this.speechListener = speechListener;
    }
}

