package com.shitu.epathmap.utils.voice;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

import com.baidu.tts.chainofresponsibility.logger.LoggerProxy;
import com.google.gson.Gson;
import com.shitu.epathmap.model.bean.Configs;
import com.shitu.epathmap.utils.voice.aws.AwsSpeecher;
import com.shitu.epathmap.utils.voice.baidu.BaiduSpeecher;

import org.json.JSONObject;

import java.util.Map;

public class SpeecherFactory {


    private SpeecherFactory(){}

    public static Speecher provideSpeecher(Context context,String configsJson, SpeechListener listener){
        Speecher speecher = null;

        if(!TextUtils.isEmpty(configsJson)){
            Configs configs = new Gson().fromJson(configsJson, Configs.class);
            Configs.ApiBean api = configs.getApi();
            if(api!=null) {
                Configs.ApiBean.TtsBean tts = api.getTts();
                if(tts!=null){
                    switch (tts.getName()) {
                        case "aws":
                            speecher = new AwsSpeecher(context, tts.getKeys());
                            break;
                        default:
                            speecher = new BaiduSpeecher(context);
                    }
                }
            }
        }

        if(speecher == null){
            speecher = new BaiduSpeecher(context);
        }
        speecher.setSpeechListener(listener);

        return speecher;
    }


}
