package com.shitu.epathmap.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;

import com.shitu.epathmap.R;
import com.shitu.epathmap.base.BasePresenterFragment;
import com.shitu.epathmap.ui.activity.EpathMapActivity;
import com.shitu.epathmap.ui.activity.EpPoiMoreActivity;
import com.shitu.epathmap.ui.adapter.FloorBarConsoleAdapter;
import com.shitu.location.epathmap.model.bean.DataHolder;
import com.shitu.location.epathmap.model.bean.LocationRegionData;
import com.shitu.location.epathmap.model.bean.LocationRegionIconData;
import com.shitu.location.epathmap.model.bean.LocationRegionTagData;
import com.shitu.epathmap.presenter.IView.EpathSearchView;
import com.shitu.epathmap.presenter.EpathSearchPresenter;
import com.shitu.epathmap.ui.adapter.RecyclerviewPagerAdapter;
import com.shitu.epathmap.ui.widget.WrapContentViewPager;
import com.shitu.location.epathmap.utils.EpException;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.shitu.location.epathmap.utils.T;

import java.util.ArrayList;
import java.util.List;

import static android.app.Activity.RESULT_OK;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_ID;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE;
import static com.shitu.epathmap.ui.activity.EpSearchActivity.REQUEST_TYPE_TARGET;

/**
 * author:lfei
 */
public class EpSearchGenreFragment extends BasePresenterFragment<EpathSearchPresenter> implements
        SwipeRefreshLayout.OnRefreshListener, View.OnClickListener, EpathSearchView {
    private static final int MORECODE = 1111;
    private LinearLayout llMyLoc;
    private LinearLayout indicators;
    private SwipeRefreshLayout swipeRefreshLayout;
    private WrapContentViewPager viewPager;
    private RecyclerView recyclerView;
    private LinearLayout llGenre;
    private ArrayList<LocationRegionData> locationRegionDatas;
    private List<LocationRegionIconData> locationRegionIconDatas;
    private List<LocationRegionTagData> locationRegionTagDatas;
    private RecyclerviewPagerAdapter adapter0;
    private FloorBarConsoleAdapter adapter;
    private String id, type;

    public static EpSearchGenreFragment getInstance(String id, String type) {
        EpSearchGenreFragment fragment = new EpSearchGenreFragment();
        Bundle bundle = new Bundle();
        bundle.putString(REQUEST_ID, id);
        bundle.putString(REQUEST_TYPE, type);
//        bundle.putParcelableArrayList(REQUEST_REGIONS, locationRegionDatas);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.fragment_search_genre;
    }

    @Override
    protected void initView(Bundle saveInstanceState) {
        llMyLoc = (LinearLayout) view.findViewById(R.id.ll_my_loc);
        indicators = (LinearLayout) view.findViewById(R.id.indicators);
        swipeRefreshLayout = (SwipeRefreshLayout) view.findViewById(R.id.swipe_layout);
        viewPager = (WrapContentViewPager) view.findViewById(R.id.viewPager);
        recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
        llGenre = (LinearLayout) view.findViewById(R.id.ll_genre);
        llMyLoc.setOnClickListener(this);

        recyclerView.setLayoutManager(new LinearLayoutManager(context));
        swipeRefreshLayout.setColorSchemeResources(R.color.colorAccent);
        swipeRefreshLayout.setProgressViewOffset(false, -20, 150);
        swipeRefreshLayout.setOnRefreshListener(this);

        id = getArguments().getString(REQUEST_ID);
        type = getArguments().getString(REQUEST_TYPE);
//        locationRegionDatas = getArguments().getParcelableArrayList(REQUEST_REGIONS);
        locationRegionDatas = DataHolder.getInstance().getLocationRegions();
        if (locationRegionDatas == null) {
            T.showShort("获取locationRegionDatas失败！");
            return;
        }

        if (type.equals(REQUEST_TYPE_TARGET)) {
            llMyLoc.setVisibility(View.GONE);
        } else {
            llMyLoc.setVisibility(View.VISIBLE);
        }
    }

    @Override
    protected void initData() {
        locationRegionIconDatas = new ArrayList<>();
        adapter0 = new RecyclerviewPagerAdapter(context);
        adapter0.setDatas(locationRegionIconDatas, indicators);
        adapter0.setOnRegionIconDataClickListener(locationRegionIconData -> {
            presenter.queryByGenre(id, locationRegionIconData, locationRegionDatas);
        });
        viewPager.setAdapter(adapter0);
        viewPager.addOnPageChangeListener(adapter0);

        locationRegionTagDatas = new ArrayList<>();
        adapter = new FloorBarConsoleAdapter(R.layout.item_region_tag, locationRegionTagDatas, item -> {
            MixpanelEvent.search(item.getName(), 1, MixpanelConstants.SEARCH_FROM_SEARCH_POI);
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SELECT_REGION, item);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            activity.finish();
        });
        adapter.setOnItemChildClickListener((adapter1, view1, position) -> {
            LocationRegionTagData tagData = locationRegionTagDatas.get(position);
            ArrayList<LocationRegionData> locationRegionData = (ArrayList<LocationRegionData>) tagData.getLocationRegionDatas();
            Intent intent = new Intent();
            intent.setClass(getActivity(), EpPoiMoreActivity.class);
            intent.putExtra(EpPoiMoreActivity.SEARCH_TYPE, type);
            intent.putParcelableArrayListExtra(EpPoiMoreActivity.LIST_STR, locationRegionData);
            intent.putExtra(EpPoiMoreActivity.FLOOR_NAME, tagData.getName());
            startActivityForResult(intent, MORECODE);
        });
        adapter.openLoadAnimation();

//        RegionTagDataItem regionTagDataItem = new RegionTagDataItem(context, item -> {
//            MixpanelEvent.search(item.getName(), 1, MixpanelConstants.SEARCH_FROM_SEARCH_POI);
//            Intent intent = new Intent();
//            intent.putExtra(EpathMapActivity.RESULT_SELECT_REGION, item);
//            intent.putExtra(REQUEST_TYPE, type);
//            activity.setResult(activity.RESULT_OK, intent);
//            activity.finish();
//        });
//        adapter.addItemFactory(regionTagDataItem);
        recyclerView.setAdapter(adapter);
        onRefresh();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == MORECODE && resultCode == RESULT_OK) {
            activity.setResult(activity.RESULT_OK, data);
            activity.finish();
        }
    }

    @Override
    protected void lazyLoad() {

    }

    public void onClick(View v) {
        if (v.getId() == R.id.ll_my_loc) {
            Intent intent = new Intent();
            intent.putExtra(REQUEST_TYPE, EpathMapActivity.RESULT_SELECT_MY_LOCATION);
            activity.setResult(activity.RESULT_OK, intent);
            activity.finish();
        }
    }

    @Override
    public void onRefresh() {
//        swipeRefreshLayout.setRefreshing(true);
        presenter.querySearchViewData(id);
    }

    @Override
    public void queryByContentSuccess(String content, String from, ArrayList<LocationRegionData> list) {

    }

    @Override
    public void queryByGenreSuccess(LocationRegionIconData locationRegionIconData, ArrayList<LocationRegionData> searchRegionDatas) {
        MixpanelEvent.search(locationRegionIconData.getName(), searchRegionDatas.size(), MixpanelConstants.SEARCH_FROM_SEARCH_GENRE);
        if (searchRegionDatas.size() == 0) {
            T.showShort(R.string.epath_no_result);
        } else {
            Intent intent = new Intent();
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_CONTENT, locationRegionIconData.getName());
            intent.putExtra(EpathMapActivity.RESULT_SEARCH_RESULT, searchRegionDatas);
            intent.putExtra(REQUEST_TYPE, type);
            activity.setResult(activity.RESULT_OK, intent);
            activity.finish();
        }
    }

    @Override
    public void queryRegionIconDataSuccess(List<LocationRegionIconData> locationRegionIconDatas0) {
        locationRegionIconDatas.clear();
        locationRegionIconDatas.addAll(locationRegionIconDatas0);
        if (locationRegionIconDatas.isEmpty()) {
            llGenre.setVisibility(View.GONE);
        } else {
            llGenre.setVisibility(View.VISIBLE);
        }
        adapter0.notifyDataSetChanged();
        viewPager.setCurrentItem(0);
    }

    @Override
    public void queryRegionTagDataSuccess(List<LocationRegionTagData> locationRegionTagDatas0) {
        swipeRefreshLayout.setRefreshing(false);
        locationRegionTagDatas.clear();
        locationRegionTagDatas.addAll(locationRegionTagDatas0);
        adapter.notifyDataSetChanged();
    }

    @Override
    public void queryHotGenreSuccess(List<String> tags, List<LocationRegionIconData> locationRegionIconDatas) {

    }

    @Override
    public void handleThrowable(EpException ex) {
        super.handleThrowable(ex);
        swipeRefreshLayout.setRefreshing(false);
    }
}
