/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.base;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.view.MotionEvent;
import com.baidu.tts.client.SpeechSynthesizer;
import com.bugtags.library.Bugtags;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.RecognizerResult;
import com.iflytek.cloud.SpeechError;
import com.iflytek.cloud.ui.RecognizerDialog;
import com.iflytek.cloud.ui.RecognizerDialogListener;
import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.utils.h;
import com.shitu.epathmap.utils.JsonParser;
import com.shitu.epathmap.utils.VoiceManager;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.T;
import java.util.HashMap;
import java.util.LinkedHashMap;
import me.imid.swipebacklayout.lib.SwipeBackLayout;
import me.imid.swipebacklayout.lib.app.SwipeBackActivity;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseActivity
extends SwipeBackActivity {
    private HashMap<String, String> mIatResults = new LinkedHashMap<String, String>();
    public Context context;
    private RecognizerDialog recognizerDialog;
    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_LOCATION = 1;
    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO = 2;
    protected static final int MY_PERMISSIONS_REQUEST_ACCESS_FINE_WRITE_SD_AND_RECORD_AUDIO_BAIDU = 3;
    protected static final int MY_PERMISSIONS_REQUEST_CAMERA = 4;
    protected c recognizerResultListener;
    private SpeechSynthesizer mSpeechSynthesizer;
    private String mSampleDirPath;
    private static String SAMPLE_DIR_NAME = "baiduTTS";
    private static final String SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female.dat";
    private static final String SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male.dat";
    private static final String TEXT_MODEL_NAME = "bd_etts_text.dat";
    private static final String ENGLISH_SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female_en.dat";
    private static final String ENGLISH_SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male_en.dat";
    private static final String ENGLISH_TEXT_MODEL_NAME = "bd_etts_text_en.dat";
    public VoiceManager voiceManager;
    private SwipeBackLayout mSwipeBackLayout;

    protected void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(this.getLayoutId());
        this.context = this;
        this.setRequestedOrientation(1);
        this.setStatusBar();
        this.initView(bundle);
        this.initData();
    }

    protected void initSwipeBack() {
        this.setSwipeBackEnable(true);
        this.mSwipeBackLayout = this.getSwipeBackLayout();
        this.mSwipeBackLayout.setEdgeTrackingEnabled(1);
        this.mSwipeBackLayout.setEdgeSize(this.getResources().getDisplayMetrics().widthPixels / 4);
    }

    protected void onResume() {
        super.onResume();
        Bugtags.onResume((Activity)this);
    }

    protected void onPause() {
        super.onPause();
        Bugtags.onPause((Activity)this);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        Bugtags.onDispatchTouchEvent((Activity)this, (MotionEvent)motionEvent);
        return super.dispatchTouchEvent(motionEvent);
    }

    private Intent getAppDetailSettingIntent() {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            intent.setAction("android.intent.action.VIEW");
            intent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            intent.putExtra("com.android.settings.ApplicationPkgName", this.getPackageName());
        }
        return intent;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.recognizerDialog != null) {
            this.recognizerDialog.dismiss();
            this.recognizerDialog = null;
        }
    }

    protected abstract int getLayoutId();

    protected abstract void initView(Bundle var1);

    protected abstract void initData();

    protected void setStatusBar() {
        h.a((Activity)this, this.getResources().getColor(R.color.colorPrimaryDark));
    }

    public boolean hasPermission(String ... stringArray) {
        for (String string2 : stringArray) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)string2) == 0) continue;
            return false;
        }
        return true;
    }

    public void requestPermission(int n2, String ... stringArray) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(stringArray, n2);
        }
    }

    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        switch (n2) {
            case 2: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    T.showShort((int)R.string.epath_please_grant_permission_write);
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                this.doSDCardAndRecordAudio();
                return;
            }
            case 3: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    T.showShort((int)R.string.epath_please_grant_permission_write);
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                this.initBaiduVioce();
                return;
            }
            case 1: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    if (n2 == 0) {
                        T.showShort((int)R.string.epath_please_grant_location);
                    } else if (n2 == 1) {
                        T.showShort((int)R.string.epath_please_grant_permission_write);
                    }
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                this.permissionGranted();
                return;
            }
            case 4: {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    if (nArray[n2] != -1) continue;
                    T.showShort((int)R.string.epath_please_grant_permission_camera);
                    Intent intent = this.getAppDetailSettingIntent();
                    this.startActivity(intent);
                    this.finish();
                    return;
                }
                break;
            }
        }
    }

    public void initBaiduVioce() {
        this.voiceManager = VoiceManager.getInstance(EpathMapSDK.b);
    }

    public void doSDCardAndRecordAudio() {
    }

    public void permissionGranted() {
    }

    public void stopSpeaking() {
        if (this.mSpeechSynthesizer != null) {
            this.mSpeechSynthesizer.stop();
        }
    }

    public void volumeIsTooLow() {
        AudioManager audioManager = (AudioManager)this.getSystemService("audio");
        int n2 = audioManager.getStreamMaxVolume(3);
        if ((double)((float)audioManager.getStreamVolume(3) / (float)n2) < 0.8) {
            T.showShort((int)R.string.epath_volume_too_low);
        }
    }

    public void startSpeechDialog(c c2) {
        this.recognizerResultListener = c2;
        this.recognizerDialog = new RecognizerDialog((Context)this, new a());
        this.recognizerDialog.setParameter("language", "zh_cn");
        this.recognizerDialog.setParameter("accent", "mandarin");
        this.recognizerDialog.setListener(new b());
        this.recognizerDialog.show();
    }

    public void initGPS() {
        if (!((LocationManager)this.getSystemService("location")).isProviderEnabled("gps")) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle((CharSequence)"\u8bf7\u6253\u5f00GPS\u8fde\u63a5");
            builder.setMessage((CharSequence)"\u4e3a\u4e86\u7ed9\u60a8\u63d0\u4f9b\u66f4\u597d\u7684\u4f53\u9a8c\uff0c\u8bf7\u5148\u6253\u5f00GPS");
            builder.setPositiveButton((CharSequence)"\u8bbe\u7f6e", (DialogInterface.OnClickListener)new com.shitu.epathmap.base.a(this));
            builder.setNeutralButton((CharSequence)"\u53d6\u6d88", (DialogInterface.OnClickListener)new com.shitu.epathmap.base.b(this));
            builder.show();
        }
    }

    public static interface c {
        public void onSuccess(String var1);
    }

    final class b
    implements RecognizerDialogListener {
        b() {
        }

        @Override
        public final void onResult(RecognizerResult object, boolean bl2) {
            Object object2 = ((RecognizerResult)object).getResultString();
            L.d((String)" \u89e3\u6790\u524d", (String)object2);
            object2 = JsonParser.parseIatResult((String)object2);
            L.d((String)" \u89e3\u6790\u540e", (String)object2);
            String string22 = null;
            try {
                string22 = new JSONObject(((RecognizerResult)object).getResultString()).optString("sn");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            BaseActivity.this.mIatResults.put(string22, object2);
            object = new StringBuffer();
            for (String string22 : BaseActivity.this.mIatResults.keySet()) {
                ((StringBuffer)object).append((String)BaseActivity.this.mIatResults.get(string22));
            }
            try {
                if (BaseActivity.this.recognizerResultListener != null && bl2) {
                    int n2 = ((StringBuffer)object).lastIndexOf("\u3002");
                    if (((StringBuffer)object).length() > 1 && n2 > 0 && n2 < ((StringBuffer)object).length()) {
                        BaseActivity.this.recognizerResultListener.onSuccess(((StringBuffer)object).substring(0, n2));
                        return;
                    }
                    BaseActivity.this.recognizerResultListener.onSuccess(((StringBuffer)object).substring(0, ((StringBuffer)object).length() - 1));
                }
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                T.showShort((String)"\u7d22\u5f15\u6570\u7ec4\u8d8a\u754c!");
                return;
            }
        }

        @Override
        public final void onError(SpeechError speechError) {
        }
    }

    final class a
    implements InitListener {
        a() {
        }

        @Override
        public final void onInit(int n2) {
        }
    }
}

