/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.FileAsyncHttpResponseHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class RangeFileAsyncHttpResponseHandler
extends FileAsyncHttpResponseHandler {
    private static final String LOG_TAG = "RangeFileAsyncHttpRH";
    private long current = 0L;
    private boolean append = false;

    public RangeFileAsyncHttpResponseHandler(File file) {
        super(file);
    }

    public void sendResponseMessage(HttpResponse httpResponse) throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() == 416) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null);
                    return;
                }
            } else if (statusLine.getStatusCode() >= 300) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null, (Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                    return;
                }
            } else if (!Thread.currentThread().isInterrupted()) {
                Header header = httpResponse.getFirstHeader("Content-Range");
                if (header == null) {
                    this.append = false;
                    this.current = 0L;
                } else {
                    AsyncHttpClient.log.v(LOG_TAG, "Content-Range: " + header.getValue());
                }
                this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), this.getResponseData(httpResponse.getEntity()));
            }
        }
    }

    protected byte[] getResponseData(HttpEntity object) throws IOException {
        if (object != null) {
            InputStream inputStream = object.getContent();
            long l2 = object.getContentLength() + this.current;
            object = new FileOutputStream(this.getTargetFile(), this.append);
            if (inputStream != null) {
                try {
                    int n2;
                    byte[] byArray = new byte[4096];
                    while (this.current < l2 && (n2 = inputStream.read(byArray)) != -1 && !Thread.currentThread().isInterrupted()) {
                        this.current += (long)n2;
                        ((FileOutputStream)object).write(byArray, 0, n2);
                        this.sendProgressMessage(this.current, l2);
                    }
                }
                finally {
                    inputStream.close();
                    ((OutputStream)object).flush();
                    ((FileOutputStream)object).close();
                }
            }
        }
        return null;
    }

    public void updateRequestHeaders(HttpUriRequest httpUriRequest) {
        if (this.file.exists() && this.file.canWrite()) {
            this.current = this.file.length();
        }
        if (this.current > 0L) {
            this.append = true;
            httpUriRequest.setHeader("Range", "bytes=" + this.current + "-");
        }
    }
}

