/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import java.io.UnsupportedEncodingException;

public class Base64 {
    public static final int DEFAULT = 0;
    public static final int NO_PADDING = 1;
    public static final int NO_WRAP = 2;
    public static final int CRLF = 4;
    public static final int URL_SAFE = 8;
    public static final int NO_CLOSE = 16;

    public static byte[] decode(String string, int n2) {
        return Base64.decode(string.getBytes(), n2);
    }

    public static byte[] decode(byte[] byArray, int n2) {
        return Base64.decode(byArray, 0, byArray.length, n2);
    }

    public static byte[] decode(byte[] byArray, int n2, int n3, int n4) {
        Decoder decoder = new Decoder(n4, new byte[n3 * 3 / 4]);
        if (!decoder.process(byArray, n2, n3, true)) {
            throw new IllegalArgumentException("bad base-64");
        }
        if (decoder.op == decoder.output.length) {
            return decoder.output;
        }
        byte[] byArray2 = new byte[decoder.op];
        System.arraycopy(decoder.output, 0, byArray2, 0, decoder.op);
        return byArray2;
    }

    public static String encodeToString(byte[] byArray, int n2) {
        try {
            return new String(Base64.encode(byArray, n2), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public static String encodeToString(byte[] byArray, int n2, int n3, int n4) {
        try {
            return new String(Base64.encode(byArray, n2, n3, n4), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public static byte[] encode(byte[] byArray, int n2) {
        return Base64.encode(byArray, 0, byArray.length, n2);
    }

    public static byte[] encode(byte[] byArray, int n2, int n3, int n4) {
        Encoder encoder = new Encoder(n4, null);
        int n5 = n3 / 3 * 4;
        if (encoder.do_padding) {
            if (n3 % 3 > 0) {
                n5 += 4;
            }
        } else {
            switch (n3 % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    n5 += 2;
                    break;
                }
                case 2: {
                    n5 += 3;
                }
            }
        }
        if (encoder.do_newline && n3 > 0) {
            n5 += ((n3 - 1) / 57 + 1) * (encoder.do_cr ? 2 : 1);
        }
        encoder.output = new byte[n5];
        encoder.process(byArray, n2, n3, true);
        return encoder.output;
    }

    private Base64() {
    }

    static class Encoder
    extends Coder {
        public static final int LINE_GROUPS = 19;
        private static final byte[] ENCODE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        private static final byte[] ENCODE_WEBSAFE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
        private final byte[] tail;
        int tailLen;
        private int count;
        public final boolean do_padding;
        public final boolean do_newline;
        public final boolean do_cr;
        private final byte[] alphabet;

        public Encoder(int n2, byte[] byArray) {
            this.output = byArray;
            this.do_padding = (n2 & 1) == 0;
            this.do_newline = (n2 & 2) == 0;
            this.do_cr = (n2 & 4) != 0;
            this.alphabet = (n2 & 8) == 0 ? ENCODE : ENCODE_WEBSAFE;
            this.tail = new byte[2];
            this.tailLen = 0;
            this.count = this.do_newline ? 19 : -1;
        }

        public int maxOutputSize(int n2) {
            return n2 * 8 / 5 + 10;
        }

        public boolean process(byte[] byArray, int n2, int n3, boolean bl2) {
            byte[] byArray2 = this.alphabet;
            byte[] byArray3 = this.output;
            int n4 = 0;
            int n5 = this.count;
            int n6 = n2;
            n3 += n2;
            int n7 = -1;
            switch (this.tailLen) {
                case 0: {
                    break;
                }
                case 1: {
                    if (n6 + 2 > n3) break;
                    n7 = (this.tail[0] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
                    this.tailLen = 0;
                    break;
                }
                case 2: {
                    if (n6 + 1 > n3) break;
                    n7 = (this.tail[0] & 0xFF) << 16 | (this.tail[1] & 0xFF) << 8 | byArray[n6++] & 0xFF;
                    this.tailLen = 0;
                }
            }
            if (n7 != -1) {
                byArray3[n4++] = byArray2[n7 >> 18 & 0x3F];
                byArray3[n4++] = byArray2[n7 >> 12 & 0x3F];
                byArray3[n4++] = byArray2[n7 >> 6 & 0x3F];
                byArray3[n4++] = byArray2[n7 & 0x3F];
                if (--n5 == 0) {
                    if (this.do_cr) {
                        byArray3[n4++] = 13;
                    }
                    byArray3[n4++] = 10;
                    n5 = 19;
                }
            }
            while (n6 + 3 <= n3) {
                n7 = (byArray[n6] & 0xFF) << 16 | (byArray[n6 + 1] & 0xFF) << 8 | byArray[n6 + 2] & 0xFF;
                byArray3[n4] = byArray2[n7 >> 18 & 0x3F];
                byArray3[n4 + 1] = byArray2[n7 >> 12 & 0x3F];
                byArray3[n4 + 2] = byArray2[n7 >> 6 & 0x3F];
                byArray3[n4 + 3] = byArray2[n7 & 0x3F];
                n6 += 3;
                n4 += 4;
                if (--n5 != 0) continue;
                if (this.do_cr) {
                    byArray3[n4++] = 13;
                }
                byArray3[n4++] = 10;
                n5 = 19;
            }
            if (bl2) {
                if (n6 - this.tailLen == n3 - 1) {
                    int n8 = 0;
                    n7 = ((this.tailLen > 0 ? this.tail[n8++] : byArray[n6++]) & 0xFF) << 4;
                    this.tailLen -= n8;
                    byArray3[n4++] = byArray2[n7 >> 6 & 0x3F];
                    byArray3[n4++] = byArray2[n7 & 0x3F];
                    if (this.do_padding) {
                        byArray3[n4++] = 61;
                        byArray3[n4++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            byArray3[n4++] = 13;
                        }
                        byArray3[n4++] = 10;
                    }
                } else if (n6 - this.tailLen == n3 - 2) {
                    int n9 = 0;
                    n7 = ((this.tailLen > 1 ? this.tail[n9++] : byArray[n6++]) & 0xFF) << 10 | ((this.tailLen > 0 ? this.tail[n9++] : byArray[n6++]) & 0xFF) << 2;
                    this.tailLen -= n9;
                    byArray3[n4++] = byArray2[n7 >> 12 & 0x3F];
                    byArray3[n4++] = byArray2[n7 >> 6 & 0x3F];
                    byArray3[n4++] = byArray2[n7 & 0x3F];
                    if (this.do_padding) {
                        byArray3[n4++] = 61;
                    }
                    if (this.do_newline) {
                        if (this.do_cr) {
                            byArray3[n4++] = 13;
                        }
                        byArray3[n4++] = 10;
                    }
                } else if (this.do_newline && n4 > 0 && n5 != 19) {
                    if (this.do_cr) {
                        byArray3[n4++] = 13;
                    }
                    byArray3[n4++] = 10;
                }
            } else if (n6 == n3 - 1) {
                this.tail[this.tailLen++] = byArray[n6];
            } else if (n6 == n3 - 2) {
                this.tail[this.tailLen++] = byArray[n6];
                this.tail[this.tailLen++] = byArray[n6 + 1];
            }
            this.op = n4;
            this.count = n5;
            return true;
        }
    }

    static class Decoder
    extends Coder {
        private static final int[] DECODE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private static final int[] DECODE_WEBSAFE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        private static final int SKIP = -1;
        private static final int EQUALS = -2;
        private int state;
        private int value;
        private final int[] alphabet;

        public Decoder(int n2, byte[] byArray) {
            this.output = byArray;
            this.alphabet = (n2 & 8) == 0 ? DECODE : DECODE_WEBSAFE;
            this.state = 0;
            this.value = 0;
        }

        public int maxOutputSize(int n2) {
            return n2 * 3 / 4 + 10;
        }

        public boolean process(byte[] byArray, int n2, int n3, boolean bl2) {
            if (this.state == 6) {
                return false;
            }
            int n4 = n2;
            n3 += n2;
            int n5 = this.state;
            int n6 = this.value;
            int n7 = 0;
            byte[] byArray2 = this.output;
            int[] nArray = this.alphabet;
            while (n4 < n3) {
                if (n5 == 0) {
                    while (n4 + 4 <= n3 && (n6 = nArray[byArray[n4] & 0xFF] << 18 | nArray[byArray[n4 + 1] & 0xFF] << 12 | nArray[byArray[n4 + 2] & 0xFF] << 6 | nArray[byArray[n4 + 3] & 0xFF]) >= 0) {
                        byArray2[n7 + 2] = (byte)n6;
                        byArray2[n7 + 1] = (byte)(n6 >> 8);
                        byArray2[n7] = (byte)(n6 >> 16);
                        n7 += 3;
                        n4 += 4;
                    }
                    if (n4 >= n3) break;
                }
                int n8 = nArray[byArray[n4++] & 0xFF];
                switch (n5) {
                    case 0: {
                        if (n8 >= 0) {
                            n6 = n8;
                            ++n5;
                            break;
                        }
                        if (n8 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 1: {
                        if (n8 >= 0) {
                            n6 = n6 << 6 | n8;
                            ++n5;
                            break;
                        }
                        if (n8 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 2: {
                        if (n8 >= 0) {
                            n6 = n6 << 6 | n8;
                            ++n5;
                            break;
                        }
                        if (n8 == -2) {
                            byArray2[n7++] = (byte)(n6 >> 4);
                            n5 = 4;
                            break;
                        }
                        if (n8 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 3: {
                        if (n8 >= 0) {
                            n6 = n6 << 6 | n8;
                            byArray2[n7 + 2] = (byte)n6;
                            byArray2[n7 + 1] = (byte)(n6 >> 8);
                            byArray2[n7] = (byte)(n6 >> 16);
                            n7 += 3;
                            n5 = 0;
                            break;
                        }
                        if (n8 == -2) {
                            byArray2[n7 + 1] = (byte)(n6 >> 2);
                            byArray2[n7] = (byte)(n6 >> 10);
                            n7 += 2;
                            n5 = 5;
                            break;
                        }
                        if (n8 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 4: {
                        if (n8 == -2) {
                            ++n5;
                            break;
                        }
                        if (n8 == -1) break;
                        this.state = 6;
                        return false;
                    }
                    case 5: {
                        if (n8 == -1) break;
                        this.state = 6;
                        return false;
                    }
                }
            }
            if (!bl2) {
                this.state = n5;
                this.value = n6;
                this.op = n7;
                return true;
            }
            switch (n5) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 6;
                    return false;
                }
                case 2: {
                    byArray2[n7++] = (byte)(n6 >> 4);
                    break;
                }
                case 3: {
                    byArray2[n7++] = (byte)(n6 >> 10);
                    byArray2[n7++] = (byte)(n6 >> 2);
                    break;
                }
                case 4: {
                    this.state = 6;
                    return false;
                }
            }
            this.state = n5;
            this.op = n7;
            return true;
        }
    }

    static abstract class Coder {
        public byte[] output;
        public int op;

        Coder() {
        }

        public abstract boolean process(byte[] var1, int var2, int var3, boolean var4);

        public abstract int maxOutputSize(int var1);
    }
}

