package com.shitu.epathmap.presenter;

import com.shitu.epathmap.base.BasePresenter;

import com.shitu.epathmap.presenter.IView.EpFootprintView;
import com.shitu.location.epathmap.utils.DateUtils;
import com.shitu.location.epathmap.model.bean.BackgroundData;
import com.shitu.location.epathmap.model.parse.Background;
import com.parse.ParseObject;
import com.parse.ParseQuery;

import java.util.ArrayList;
import java.util.List;

/**
 * author:lfei
 */
public class EpFootprintPresenter extends BasePresenter<EpFootprintView> {

    private int page = 1, limit = 30;
    private List<Object> list = new ArrayList<>();
    private List<BackgroundData> backgroundDatas = new ArrayList<>();

    public void queryBackgroundData(String mapId, String deviceId) {
        List<BackgroundData> newBackgroundDatas = new ArrayList<>();
        ParseQuery.getQuery(Background.class)
                .whereEqualTo("project", ParseObject.createWithoutData("MappingProject", mapId))
                .whereEqualTo(Background.deviceId, deviceId)
                .orderByAscending(Background.enterAt)
                .setLimit(limit)
                .setSkip(limit * (page - 1))
                .findInBackground((objects, e) -> {
                    if (e != null) {
                        handleError(e);
                        return;
                    }
                    for (int i = 0; i < objects.size(); i++) {
                        Background background = objects.get(i);
                        BackgroundData backgroundData = new BackgroundData();
                        backgroundData.setLocationRegion(background.getLocationRegion());
                        backgroundData.setLocationRegions((ArrayList) background.getLocationRegions());
                        backgroundData.setFloorName(background.getFloorName());
                        backgroundData.setEnterAt(background.getEnterAt());
                        backgroundData.setLeaveAt(background.getLeaveAt());
                        backgroundData.setLonLat(background.getLonLat());
                        backgroundData.setDurationTime(background.getDurationTime());
                        backgroundData.setUserDescription(background.getUserDescription());
                        backgroundData.setPhoneNumber(background.getPhoneNumber());
                        newBackgroundDatas.add(backgroundData);
                    }
                    handleData(newBackgroundDatas);
                    if (isViewAttached()) {
                        getView().queryBackgroundDataSuccess(list);
                    }
                });
    }

    private void handleData(List<BackgroundData> newBackgroundDatas) {
        if (page == 1) {
            backgroundDatas.clear();
        }
        backgroundDatas.addAll(newBackgroundDatas);
        for (int i = 0; i < backgroundDatas.size(); i++) {
            backgroundDatas.get(i).setLastOne(false);
        }
        if (backgroundDatas.size() > 0) {
            list.clear();
            BackgroundData data = backgroundDatas.get(0);
            list.add(DateUtils.getSimpleDate2(data.getEnterAt()));
            if (backgroundDatas.size() == 1) {
                data.setLastOne(true);
            }
            list.add(data);
            for (int i = 0; i < backgroundDatas.size() - 1; i++) {
                BackgroundData data1 = backgroundDatas.get(i);
                BackgroundData data2 = backgroundDatas.get(i + 1);
                String date1 = DateUtils.getSimpleDate2(data1.getEnterAt());
                String date2 = DateUtils.getSimpleDate2(data2.getEnterAt());
                if (!date1.equals(date2)) {
                    if (list.size() > 1) {
                        data1.setLastOne(true);
                        list.set(list.size() - 1, data1);
                    }
                    list.add(date2);
                }
                if (i + 1 == backgroundDatas.size() - 1) {
                    data2.setLastOne(true);
                }
                list.add(data2);
            }
        }
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public boolean hasNext() {
        int size = backgroundDatas.size();
        return (size != 0 && size == page * limit) ? true : false;
    }

}
