package com.shitu.epathmap.ui.widget;

import android.app.Activity;
import android.content.Context;

public class ProgressDialog {

    private android.app.ProgressDialog progressDialog;
    private Context context;

    public ProgressDialog(Context context, String content, int max) {
        this.context = context;
        dismiss();
        progressDialog = new android.app.ProgressDialog(context);
        progressDialog.setMessage(content);
        progressDialog.setCancelable(false);
        progressDialog.setProgressStyle(android.app.ProgressDialog.STYLE_HORIZONTAL);
        progressDialog.setMax(max);
    }

    public ProgressDialog(Context context, String content, boolean cancelable) {
        this.context = context;
        dismiss();
        progressDialog = new android.app.ProgressDialog(context);
        progressDialog.setMessage(content);
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelable(cancelable);
    }

    public void setProgress(int progress) {
        progressDialog.setProgress(progress);
    }

    public boolean isShowing(){
        return progressDialog.isShowing();
    }

    public void show() {
        if (context instanceof Activity) {
            Activity activity = (Activity) context;
            if (activity == null || activity.isDestroyed() || activity.isFinishing()) {
                return;
            }
        }
        dismiss();
        progressDialog.show();
    }

    public void dismiss() {
        if (progressDialog != null && progressDialog.isShowing()) {
            progressDialog.dismiss();
        }
    }

}
