package com.shitu.epathmap.ui.item.footprint;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.item.BaseRecyclerItem;
import com.shitu.epathmap.ui.item.BaseRecyclerItemFactory;


public class BackGroundDataSectorItem extends BaseRecyclerItemFactory<BackGroundDataSectorItem.BackGroundDataRecyclerItem> {

    Context context;

    public BackGroundDataSectorItem(Context context) {
        this.context = context;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof String;
    }

    @Override
    public BackGroundDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new BackGroundDataRecyclerItem(parent, this);
    }


    public class BackGroundDataRecyclerItem extends BaseRecyclerItem<String, BackGroundDataSectorItem> {
        private TextView tvDate;

        protected BackGroundDataRecyclerItem(ViewGroup parent, BackGroundDataSectorItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_footprint_sector, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvDate = (TextView) convertView.findViewById(R.id.tv_date);
        }

        @Override
        protected void onConfigViews(final Context context) {
        }

        @Override
        protected void onSetData(int position, String item) {
            tvDate.setText(item);
        }

    }

}
