/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.tools;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileTools {
    public static boolean isFileExist(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static boolean isFileExist(Object ... objectArray) {
        File file = null;
        if (objectArray.length == 1) {
            Object object = objectArray[0];
            if (object instanceof File) {
                file = (File)object;
            } else if (object instanceof String) {
                String string = (String)object;
                file = FileTools.createFile(string);
            }
        } else if (objectArray.length == 2) {
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            file = FileTools.createFile(string, string2);
        } else {
            throw new UnknownError();
        }
        return file != null ? file.exists() : false;
    }

    public static String jointPathAndName(String string, String string2) {
        String string3 = null;
        string3 = string.endsWith(File.separator) ? string + string2 : string + File.separator + string2;
        return string3;
    }

    public static boolean deleteFile(String string) {
        File file = FileTools.createFile(string);
        return FileTools.deleteFile(file);
    }

    public static boolean deleteFile(File file) {
        return !file.exists() || file.delete();
    }

    public static boolean fileCopy(String string, String string2) throws FileNotFoundException {
        File file = FileTools.createFile(string);
        File file2 = FileTools.createFile(string2);
        return FileTools.fileCopy(file, file2);
    }

    public static boolean fileCopy(String string, String string2, String string3, String string4) throws FileNotFoundException {
        File file = FileTools.createFile(string, string2);
        File file2 = FileTools.createFile(string3, string4);
        return FileTools.fileCopy(file, file2);
    }

    public static boolean fileCopy(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) {
        return FileTools.fileCopy(new FileInputStream(fileDescriptor), new FileOutputStream(fileDescriptor2));
    }

    public static boolean fileCopy(File file, File file2) throws FileNotFoundException {
        return FileTools.fileCopy(new FileInputStream(file), new FileOutputStream(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        boolean bl2 = false;
        try {
            bl2 = FileTools.fileCopy(fileInputStream.getChannel(), fileOutputStream.getChannel());
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean fileCopy(FileChannel fileChannel, FileChannel fileChannel2) {
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                fileChannel.close();
                fileChannel2.close();
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
    }

    public static boolean writeFile(String string, File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file, false);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static void createDir(String string) {
        File file = new File(string);
        file.mkdirs();
    }

    public static String extractFileName(String string) {
        int n2 = string.lastIndexOf(File.separator);
        return string.substring(n2 + 1);
    }

    public static File getFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            if (string.endsWith(File.separator)) {
                file.mkdirs();
            } else {
                int n2 = string.lastIndexOf(File.separator);
                String string2 = string.substring(0, n2);
                File file2 = new File(string2);
                if (!file2.exists()) {
                    file2.mkdirs();
                }
            }
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getFile(String string, String string2) {
        String string3 = FileTools.jointPathAndName(string, string2);
        return FileTools.getFile(string3);
    }

    public static File createFile(String string) {
        return FileTools.getFile(string);
    }

    public static File createFile(String string, String string2) {
        return FileTools.getFile(FileTools.jointPathAndName(string, string2));
    }
}

