package com.shitu.epathmap.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.shitu.epathmap.R;

public class UpdateCarDialog {

    private final String content;
    private Dialog dialog;
    private View contentView;
    private Context context;
    private TextView tvContent;
    private TextView tvConfirm;
    private TextView tvCancle;


    public UpdateCarDialog(Context context, String content, View.OnClickListener confrimOnClickListener
            , View.OnClickListener cancleOnclickListener
    ) {
        this.context = context;
        this.content = content;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_custom_confirm_center, null);
        tvContent = (TextView) contentView.findViewById(R.id.tv_content);
        tvConfirm = (TextView) contentView.findViewById(R.id.tv_confirm);
        tvCancle = (TextView) contentView.findViewById(R.id.tv_cancle);
        tvConfirm.setOnClickListener(confrimOnClickListener);
        tvCancle.setOnClickListener(cancleOnclickListener);
        tvContent.setText(content);

        dialog = new Dialog(context,R.style.IpsmapDialogDimEnabled);
        dialog.setContentView(contentView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT));
//        dialog.setV
        dialog.setCanceledOnTouchOutside(true);
        Window win = dialog.getWindow();
        win.getDecorView().setPadding(0, 0, 0, 0);
        WindowManager.LayoutParams lp = win.getAttributes();
        lp.width = WindowManager.LayoutParams.WRAP_CONTENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
        win.setAttributes(lp);
        win.setGravity(Gravity.CENTER);
    }


    public void show() {
        if (dialog.isShowing()) {
            return;
        }
        dialog.show();
    }

    public void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

}
