package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;

import com.shitu.epathmap.R;

public class ConfirmDialog {

    private AlertDialog confirmDialog;

    public ConfirmDialog(Context context, String content,
                         DialogInterface.OnClickListener onClickOkListener,
                         DialogInterface.OnClickListener onClickCancelListener) {
        confirmDialog = new AlertDialog
                .Builder(context)
                .setTitle(content)
                .setCancelable(false)
                .setPositiveButton(R.string.ipsmap_confirm, onClickOkListener)
                .setNegativeButton(R.string.ipsmap_cancel, onClickCancelListener)
                .show();
    }

    public boolean isShowing() {
        return confirmDialog.isShowing();
    }

    public ConfirmDialog(Context context, String content, String btn1Text, String btn2Text,
                         DialogInterface.OnClickListener btn1Click,
                         DialogInterface.OnClickListener btn2Click) {
        confirmDialog = new AlertDialog
                .Builder(context)
                .setTitle(content)
                .setPositiveButton(btn1Text, btn1Click)
                .setNegativeButton(btn2Text, btn2Click)
                .show();
    }

    public ConfirmDialog(Context context, String content,
                         DialogInterface.OnClickListener onClickOkListener) {
        confirmDialog = new AlertDialog
                .Builder(context)
                .setTitle(content)
                .setPositiveButton(R.string.ipsmap_confirm, onClickOkListener)
                .show();
    }

    public void dismiss() {
        if (confirmDialog != null) {
            confirmDialog.dismiss();
        }
    }

}
