/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresApi;
import android.system.ErrnoException;
import android.system.Os;
import android.view.Surface;
import java.io.FileDescriptor;
import java.io.IOException;
import pl.droidsonroids.gif.GifError;
import pl.droidsonroids.gif.GifIOException;
import pl.droidsonroids.gif.m;

final class GifInfoHandle {
    private volatile long a;

    GifInfoHandle() {
    }

    private GifInfoHandle(String string) throws GifIOException {
        this.a = GifInfoHandle.openFile(string);
    }

    GifInfoHandle(AssetFileDescriptor assetFileDescriptor) throws IOException {
        try {
            this.a = GifInfoHandle.a(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset());
        }
        catch (Throwable throwable) {
            try {
                assetFileDescriptor.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            assetFileDescriptor.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static long a(FileDescriptor fileDescriptor, long l2) throws GifIOException {
        int n2;
        if (Build.VERSION.SDK_INT > 27) {
            try {
                n2 = GifInfoHandle.a(fileDescriptor);
            }
            catch (Exception exception) {
                throw new GifIOException(GifError.b.errorCode, exception.getMessage());
            }
        } else {
            n2 = GifInfoHandle.extractNativeFileDescriptor(fileDescriptor);
        }
        return GifInfoHandle.openNativeFileDescriptor(n2, l2);
    }

    @RequiresApi(value=21)
    private static int a(FileDescriptor fileDescriptor) throws GifIOException, ErrnoException {
        try {
            int n2 = GifInfoHandle.createTempNativeFileDescriptor();
            Os.dup2((FileDescriptor)fileDescriptor, (int)n2);
            return n2;
        }
        finally {
            Os.close((FileDescriptor)fileDescriptor);
        }
    }

    static GifInfoHandle a(ContentResolver contentResolver, Uri uri) throws IOException {
        if ("file".equals(uri.getScheme())) {
            return new GifInfoHandle(uri.getPath());
        }
        if ((contentResolver = contentResolver.openAssetFileDescriptor(uri, "r")) == null) {
            throw new IOException("Could not open AssetFileDescriptor for " + uri);
        }
        return new GifInfoHandle((AssetFileDescriptor)contentResolver);
    }

    static native long openNativeFileDescriptor(int var0, long var1) throws GifIOException;

    static native int extractNativeFileDescriptor(FileDescriptor var0) throws GifIOException;

    static native int createTempNativeFileDescriptor() throws GifIOException;

    static native long openFile(String var0) throws GifIOException;

    private static native long renderFrame(long var0, Bitmap var2);

    private static native void bindSurface(long var0, Surface var2, long[] var3);

    private static native void free(long var0);

    private static native boolean reset(long var0);

    private static native void setSpeedFactor(long var0, float var2);

    private static native int getLoopCount(long var0);

    private static native void setLoopCount(long var0, char var2);

    private static native int getDuration(long var0);

    private static native int getCurrentPosition(long var0);

    private static native void seekToTime(long var0, int var2, Bitmap var3);

    private static native void saveRemainder(long var0);

    private static native long restoreRemainder(long var0);

    private static native int getNativeErrorCode(long var0);

    private static native int getCurrentFrameIndex(long var0);

    private static native int getCurrentLoop(long var0);

    private static native void postUnbindSurface(long var0);

    private static native long[] getSavedState(long var0);

    private static native int restoreSavedState(long var0, long[] var2, Bitmap var3);

    private static native void setOptions(long var0, char var2, boolean var3);

    private static native int getWidth(long var0);

    private static native int getHeight(long var0);

    private static native int getNumberOfFrames(long var0);

    private static native boolean isOpaque(long var0);

    final synchronized long a(Bitmap bitmap) {
        return GifInfoHandle.renderFrame(this.a, bitmap);
    }

    final void a(Surface surface, long[] lArray) {
        GifInfoHandle.bindSurface(this.a, surface, lArray);
    }

    final synchronized void a() {
        GifInfoHandle.free(this.a);
        this.a = 0L;
    }

    final synchronized long b() {
        return GifInfoHandle.restoreRemainder(this.a);
    }

    final synchronized boolean c() {
        return GifInfoHandle.reset(this.a);
    }

    final synchronized void d() {
        GifInfoHandle.saveRemainder(this.a);
    }

    final synchronized int e() {
        return GifInfoHandle.getLoopCount(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(@IntRange(from=0L, to=65535L) int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("Loop count of range <0, 65535>");
        }
        GifInfoHandle gifInfoHandle = this;
        synchronized (gifInfoHandle) {
            GifInfoHandle.setLoopCount(this.a, (char)n2);
            return;
        }
    }

    final synchronized int f() {
        return GifInfoHandle.getNativeErrorCode(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(@FloatRange(from=0.0, fromInclusive=false) float f2) {
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Speed factor is not positive");
        }
        if (f2 < 4.656613E-10f) {
            f2 = 4.656613E-10f;
        }
        GifInfoHandle gifInfoHandle = this;
        synchronized (gifInfoHandle) {
            GifInfoHandle.setSpeedFactor(this.a, f2);
            return;
        }
    }

    final synchronized int g() {
        return GifInfoHandle.getDuration(this.a);
    }

    final synchronized int h() {
        return GifInfoHandle.getCurrentPosition(this.a);
    }

    final synchronized int i() {
        return GifInfoHandle.getCurrentFrameIndex(this.a);
    }

    final synchronized int j() {
        return GifInfoHandle.getCurrentLoop(this.a);
    }

    final synchronized void a(@IntRange(from=0L, to=0x7FFFFFFFL) int n2, Bitmap bitmap) {
        GifInfoHandle.seekToTime(this.a, n2, bitmap);
    }

    final synchronized boolean k() {
        return this.a == 0L;
    }

    protected final void finalize() throws Throwable {
        try {
            this.a();
            return;
        }
        finally {
            super.finalize();
        }
    }

    final synchronized void l() {
        GifInfoHandle.postUnbindSurface(this.a);
    }

    final synchronized long[] m() {
        return GifInfoHandle.getSavedState(this.a);
    }

    final synchronized int a(long[] lArray, Bitmap bitmap) {
        return GifInfoHandle.restoreSavedState(this.a, lArray, bitmap);
    }

    final void a(boolean bl2) {
        GifInfoHandle.setOptions(this.a, '\u0001', bl2);
    }

    final synchronized int n() {
        return GifInfoHandle.getWidth(this.a);
    }

    final synchronized int o() {
        return GifInfoHandle.getHeight(this.a);
    }

    final synchronized int p() {
        return GifInfoHandle.getNumberOfFrames(this.a);
    }

    final synchronized boolean q() {
        return GifInfoHandle.isOpaque(this.a);
    }

    static {
        m.a();
    }
}

