/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import com.baidu.tts.loopj.AsyncHttpClient;
import com.baidu.tts.loopj.TextHttpResponseHandler;
import org.apache.http.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonHttpResponseHandler
extends TextHttpResponseHandler {
    private static final String LOG_TAG = "JsonHttpRH";
    private boolean useRFC5179CompatibilityMode = true;

    public JsonHttpResponseHandler() {
        super("UTF-8");
    }

    public JsonHttpResponseHandler(String string) {
        super(string);
    }

    public JsonHttpResponseHandler(boolean bl2) {
        super("UTF-8");
        this.useRFC5179CompatibilityMode = bl2;
    }

    public JsonHttpResponseHandler(String string, boolean bl2) {
        super(string);
        this.useRFC5179CompatibilityMode = bl2;
    }

    public void onSuccess(int n2, Header[] headerArray, JSONObject jSONObject) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], JSONObject) was not overriden, but callback was received");
    }

    public void onSuccess(int n2, Header[] headerArray, JSONArray jSONArray) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], JSONArray) was not overriden, but callback was received");
    }

    public void onFailure(int n2, Header[] headerArray, Throwable throwable, JSONObject jSONObject) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], Throwable, JSONObject) was not overriden, but callback was received", throwable);
    }

    public void onFailure(int n2, Header[] headerArray, Throwable throwable, JSONArray jSONArray) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], Throwable, JSONArray) was not overriden, but callback was received", throwable);
    }

    public void onFailure(int n2, Header[] headerArray, String string, Throwable throwable) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], String, Throwable) was not overriden, but callback was received", throwable);
    }

    public void onSuccess(int n2, Header[] headerArray, String string) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], String) was not overriden, but callback was received");
    }

    public final void onSuccess(final int n2, final Header[] headerArray, final byte[] byArray) {
        if (n2 != 204) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        final Object object = JsonHttpResponseHandler.this.parseResponse(byArray);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            public void run() {
                                if (!JsonHttpResponseHandler.this.useRFC5179CompatibilityMode && object == null) {
                                    JsonHttpResponseHandler.this.onSuccess(n2, headerArray, (String)null);
                                    return;
                                }
                                if (object instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onSuccess(n2, headerArray, (JSONObject)object);
                                    return;
                                }
                                if (object instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onSuccess(n2, headerArray, (JSONArray)object);
                                    return;
                                }
                                if (object instanceof String) {
                                    if (JsonHttpResponseHandler.this.useRFC5179CompatibilityMode) {
                                        JsonHttpResponseHandler.this.onFailure(n2, headerArray, (String)object, (Throwable)new JSONException("Response cannot be parsed as JSON data"));
                                        return;
                                    }
                                    JsonHttpResponseHandler.this.onSuccess(n2, headerArray, (String)object);
                                    return;
                                }
                                JsonHttpResponseHandler.this.onFailure(n2, headerArray, (Throwable)new JSONException("Unexpected response type " + object.getClass().getName()), (JSONObject)null);
                            }
                        });
                        return;
                    }
                    catch (JSONException jSONException) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(n2, headerArray, (Throwable)jSONException, (JSONObject)null);
                            }
                        });
                        return;
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread(runnable).start();
                return;
            }
            runnable.run();
            return;
        }
        this.onSuccess(n2, headerArray, new JSONObject());
    }

    public final void onFailure(final int n2, final Header[] headerArray, final byte[] byArray, final Throwable throwable) {
        if (byArray != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        final Object object = JsonHttpResponseHandler.this.parseResponse(byArray);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            public void run() {
                                if (!JsonHttpResponseHandler.this.useRFC5179CompatibilityMode && object == null) {
                                    JsonHttpResponseHandler.this.onFailure(n2, headerArray, (String)null, throwable);
                                    return;
                                }
                                if (object instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onFailure(n2, headerArray, throwable, (JSONObject)object);
                                    return;
                                }
                                if (object instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onFailure(n2, headerArray, throwable, (JSONArray)object);
                                    return;
                                }
                                if (object instanceof String) {
                                    JsonHttpResponseHandler.this.onFailure(n2, headerArray, (String)object, throwable);
                                    return;
                                }
                                JsonHttpResponseHandler.this.onFailure(n2, headerArray, (Throwable)new JSONException("Unexpected response type " + object.getClass().getName()), (JSONObject)null);
                            }
                        });
                        return;
                    }
                    catch (JSONException jSONException) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(n2, headerArray, (Throwable)jSONException, (JSONObject)null);
                            }
                        });
                        return;
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread(runnable).start();
                return;
            }
            runnable.run();
            return;
        }
        AsyncHttpClient.log.v(LOG_TAG, "response body is null, calling onFailure(Throwable, JSONObject)");
        this.onFailure(n2, headerArray, throwable, (JSONObject)null);
    }

    protected Object parseResponse(byte[] object) throws JSONException {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        String string = JsonHttpResponseHandler.getResponseString((byte[])object, this.getCharset());
        object = string;
        if (string != null) {
            object = ((String)object).trim();
            if (this.useRFC5179CompatibilityMode) {
                if (((String)object).startsWith("{") || ((String)object).startsWith("[")) {
                    object2 = new JSONTokener((String)object).nextValue();
                }
            } else if (((String)object).startsWith("{") && ((String)object).endsWith("}") || ((String)object).startsWith("[") && ((String)object).endsWith("]")) {
                object2 = new JSONTokener((String)object).nextValue();
            } else if (((String)object).startsWith("\"") && ((String)object).endsWith("\"")) {
                object2 = ((String)object).substring(1, ((String)object).length() - 1);
            }
        }
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public boolean isUseRFC5179CompatibilityMode() {
        return this.useRFC5179CompatibilityMode;
    }

    public void setUseRFC5179CompatibilityMode(boolean bl2) {
        this.useRFC5179CompatibilityMode = bl2;
    }
}

