/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.epathmap.utils;

import android.content.Context;
import android.text.TextUtils;
import com.baidu.tts.chainofresponsibility.logger.LoggerProxy;
import com.baidu.tts.client.SpeechError;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.SynthesizerTool;
import com.baidu.tts.client.TtsMode;
import com.shitu.epathmap.EpathMapSDK;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.T;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class VoiceManager
implements SpeechSynthesizerListener {
    private String mSampleDirPath;
    private static String SAMPLE_DIR_NAME = "baiduTTS";
    private static final String SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female.dat";
    private static final String SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male.dat";
    private static final String TEXT_MODEL_NAME = "bd_etts_text.dat";
    private static final String ENGLISH_SPEECH_FEMALE_MODEL_NAME = "bd_etts_speech_female_en.dat";
    private static final String ENGLISH_SPEECH_MALE_MODEL_NAME = "bd_etts_speech_male_en.dat";
    private static final String ENGLISH_TEXT_MODEL_NAME = "bd_etts_text_en.dat";
    Context context;
    private SpeechSynthesizer mSpeechSynthesizer;
    ArrayList<String> speakList = new ArrayList();
    private Timer timerSpeak;
    private TimerSpeakTask task;
    private boolean isStartFlag = false;
    private String lastBuilding;
    static long temp = 0L;
    static Date curentTime = null;
    private Boolean isPlaying = false;
    private long timeStep;
    private String asseFiletMD5Speech;
    private String asseFiletMD5Text;
    private static volatile VoiceManager instance;

    private VoiceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VoiceManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<VoiceManager> clazz = VoiceManager.class;
        synchronized (VoiceManager.class) {
            if (instance != null) return instance;
            instance = new VoiceManager(context);
            temp = new Date().getTime() - 5000L;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return instance;
        }
    }

    private VoiceManager(Context context) {
        this.context = context;
        this.timerSpeak = new Timer();
        this.task = new TimerSpeakTask();
        this.startNavTimerTask();
        this.initialEnv();
        this.initialTts();
    }

    private void startNavTimerTask() {
        this.timerSpeak.schedule((TimerTask)this.task, 0L, 100L);
        this.isStartFlag = true;
    }

    public void stopSpeaking() {
        if (this.mSpeechSynthesizer != null) {
            this.mSpeechSynthesizer.stop();
        }
    }

    public boolean textToVoice(String string2) {
        if (!this.isPlaying.booleanValue()) {
            curentTime = new Date();
            this.timeStep = curentTime.getTime() - temp;
            if (this.timeStep > 3000L) {
                this.speakList.add(string2);
                return true;
            }
            return false;
        }
        return false;
    }

    public void kdxfTextToVoice(String string2) {
        if (this.mSpeechSynthesizer.speak(string2, "" + curentTime) < 0) {
            this.toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
        }
    }

    public void clear() {
        this.speakList.clear();
    }

    public void destroy() {
        this.mSpeechSynthesizer.release();
        this.timerSpeak.cancel();
        this.isStartFlag = false;
        instance = null;
    }

    public boolean textToVoice(String string2, boolean bl2) {
        if (bl2) {
            this.clear();
            this.mSpeechSynthesizer.stop();
            if (this.mSpeechSynthesizer.speak(string2) < 0) {
                this.toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
            }
            return true;
        }
        return this.textToVoice(string2);
    }

    public boolean textToVoiceFloor(String string2, boolean bl2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string2 = string2.replace("-", "\u8d1f");
        }
        if (bl2) {
            this.clear();
            this.mSpeechSynthesizer.stop();
            if (this.mSpeechSynthesizer.speak(string2) < 0) {
                this.toPrint("error,please look up error code in doc or URL:http://yuyin.baidu.com/docs/tts/122 ");
            }
            return true;
        }
        return this.textToVoice(string2);
    }

    private void initialTts() {
        this.mSpeechSynthesizer = SpeechSynthesizer.getInstance();
        this.mSpeechSynthesizer.setContext(EpathLocationSDK.context);
        this.mSpeechSynthesizer.setSpeechSynthesizerListener(this);
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE, this.mSampleDirPath + "/bd_etts_text.dat");
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE, this.mSampleDirPath + "/bd_etts_speech_female.dat");
        if (EpathLocationSDK.appIdBD != null && EpathLocationSDK.apiKeyBD != null && EpathLocationSDK.secretKeyBD != null) {
            this.mSpeechSynthesizer.setAppId(EpathLocationSDK.appIdBD);
            this.mSpeechSynthesizer.setAppId(EpathLocationSDK.appIdBD);
            this.mSpeechSynthesizer.setApiKey(EpathLocationSDK.apiKeyBD, EpathLocationSDK.secretKeyBD);
        } else {
            T.showLong((String)"\u521d\u59cb\u5316\u8bed\u97f3\u5931\u8d25001");
            this.mSpeechSynthesizer.setAppId("10467288");
            this.mSpeechSynthesizer.setApiKey("8eMSAqDrvtILjnPWZSLer0SD", "7159e6acffa07870ae618ca3eb8ed256");
        }
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_VOLUME, "9");
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_SPEAKER, "0");
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_MIX_MODE, SpeechSynthesizer.MIX_MODE_HIGH_SPEED_SYNTHESIZE);
        this.mSpeechSynthesizer.initTts(TtsMode.MIX);
        int n2 = this.mSpeechSynthesizer.loadEnglishModel(this.mSampleDirPath + "/bd_etts_text_en.dat", this.mSampleDirPath + "/bd_etts_speech_female_en.dat");
        this.toPrint("loadEnglishModel result=" + n2);
        LoggerProxy.printable(true);
        this.printEngineInfo();
    }

    private void printEngineInfo() {
        this.toPrint("EngineVersioin=" + SynthesizerTool.getEngineVersion());
        this.toPrint("EngineInfo=" + SynthesizerTool.getEngineInfo());
        String string2 = SynthesizerTool.getModelInfo(this.mSampleDirPath + "/bd_etts_text.dat");
        this.toPrint("textModelInfo=" + string2);
        string2 = SynthesizerTool.getModelInfo(this.mSampleDirPath + "/bd_etts_speech_female.dat");
        this.toPrint("speechModelInfo=" + string2);
    }

    public void toPrint(String string2) {
        L.d((String)"kdxf---", (String)string2);
    }

    private void initialEnv() {
        if (this.mSampleDirPath == null) {
            String string2 = this.context.getFilesDir().getAbsolutePath();
            L.e((String)"sdcardPath:", (String)string2);
            SAMPLE_DIR_NAME = "baiduTTS" + EpathMapSDK.c;
            this.mSampleDirPath = string2 + "/" + SAMPLE_DIR_NAME;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n2;
                String string2;
                File file;
                String string3;
                String string4;
                File file2;
                block10: {
                    VoiceManager.this.makeDir(VoiceManager.this.mSampleDirPath);
                    file2 = new File(VoiceManager.this.mSampleDirPath);
                    try {
                        string4 = VoiceManager.this.mSampleDirPath + "/bd_etts_speech_female.dat";
                        string3 = VoiceManager.getAsseFiletMD5(VoiceManager.this.context.getResources().getAssets().open(VoiceManager.SPEECH_FEMALE_MODEL_NAME));
                        L.e((String)"asset SPEECH_FEMALE_MODEL_NAME ==  ", (String)string3);
                        VoiceManager.this.copyFromAssetsToSdcard(false, VoiceManager.SPEECH_FEMALE_MODEL_NAME, string4);
                        if (file2.exists()) {
                            file = new File(string4);
                            string2 = VoiceManager.getFileMD5(file);
                            for (n2 = 0; n2 < 5; ++n2) {
                                if (string2.equals(string3)) {
                                    L.e((String)"asset", (String)"SPEECH_FEMALE_MODEL_NAME \u6821\u9a8c\u6210\u529f");
                                    break block10;
                                }
                                L.e((String)"asset", (String)("SPEECH_FEMALE_MODEL_NAME \u6821\u9a8c\u5931\u8d25,\u6b63\u5728\u91cd\u65b0copy " + n2 + "\u6b21\u6570"));
                                VoiceManager.this.copyFromAssetsToSdcard(true, VoiceManager.SPEECH_FEMALE_MODEL_NAME, string4);
                                string2 = VoiceManager.getFileMD5(file);
                            }
                            break block10;
                        }
                        L.e((String)"desSpeech", (String)"\u4e0d\u5b58\u5728");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    string4 = VoiceManager.this.mSampleDirPath + "/bd_etts_text.dat";
                    string3 = VoiceManager.getAsseFiletMD5(VoiceManager.this.context.getResources().getAssets().open(VoiceManager.TEXT_MODEL_NAME));
                    L.e((String)"asset TEXT_MODEL_NAME ==  ", (String)string3);
                    VoiceManager.this.copyFromAssetsToSdcard(false, VoiceManager.TEXT_MODEL_NAME, string4);
                    if (file2.exists()) {
                        file = new File(string4);
                        string2 = VoiceManager.getFileMD5(file);
                        for (n2 = 0; n2 < 5; ++n2) {
                            if (string2.equals(string3)) {
                                L.e((String)"asset", (String)"TEXT_MODEL_NAME \u6821\u9a8c\u6210\u529f");
                                return;
                            }
                            L.e((String)"asset", (String)("TEXT_MODEL_NAME \u6821\u9a8c\u5931\u8d25,\u6b63\u5728\u91cd\u65b0copy " + n2 + "\u6b21\u6570"));
                            VoiceManager.this.copyFromAssetsToSdcard(true, VoiceManager.TEXT_MODEL_NAME, string4);
                            string2 = VoiceManager.getFileMD5(file);
                        }
                        return;
                    }
                    L.e((String)"desText", (String)"\u4e0d\u5b58\u5728");
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    private static String getFileMD5(File object) throws NoSuchAlgorithmException, IOException {
        int n2;
        if (!((File)object).isFile()) {
            return null;
        }
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        object = new FileInputStream((File)object);
        while ((n2 = ((FileInputStream)object).read(byArray, 0, 1024)) != -1) {
            messageDigest.update(byArray, 0, n2);
        }
        ((FileInputStream)object).close();
        return new BigInteger(1, messageDigest.digest()).toString(16);
    }

    private static String getAsseFiletMD5(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        int n2;
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        while ((n2 = inputStream.read(byArray, 0, 1024)) != -1) {
            messageDigest.update(byArray, 0, n2);
        }
        inputStream.close();
        return new BigInteger(1, messageDigest.digest()).toString(16);
    }

    /*
     * Loose catch block
     */
    private void copyFromAssetsToSdcard(boolean bl2, String object, String string2) {
        Object object2 = new File(string2);
        if (bl2 || !bl2 && !((File)object2).exists()) {
            int n2;
            InputStream inputStream = null;
            object2 = null;
            inputStream = this.context.getResources().getAssets().open((String)object);
            object = string2;
            object2 = new FileOutputStream((String)object);
            object = new byte[1024];
            while ((n2 = inputStream.read((byte[])object, 0, 1024)) >= 0) {
                ((FileOutputStream)object2).write((byte[])object, 0, n2);
            }
            try {
                ((FileOutputStream)object2).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                block29: {
                    fileNotFoundException.printStackTrace();
                    if (object2 == null) break block29;
                    try {
                        ((FileOutputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
            catch (IOException iOException) {
                block30: {
                    iOException.printStackTrace();
                    if (object2 == null) break block30;
                    {
                        catch (Throwable throwable) {
                            if (object2 != null) {
                                try {
                                    ((FileOutputStream)object2).close();
                                }
                                catch (IOException iOException2) {
                                    iOException2.printStackTrace();
                                }
                            }
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException3) {
                                iOException3.printStackTrace();
                            }
                            throw throwable;
                        }
                    }
                    try {
                        ((FileOutputStream)object2).close();
                    }
                    catch (IOException iOException4) {
                        iOException4.printStackTrace();
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    return;
                }
                catch (IOException iOException5) {
                    iOException5.printStackTrace();
                    return;
                }
            }
        }
    }

    private void makeDir(String object) {
        if (!((File)(object = new File((String)object))).exists()) {
            ((File)object).mkdirs();
        }
    }

    @Override
    public void onSynthesizeStart(String string2) {
        this.toPrint("onSynthesizeStart utteranceId=" + string2);
    }

    @Override
    public void onSynthesizeDataArrived(String string2, byte[] byArray, int n2) {
        this.toPrint("onSynthesizeDataArrived");
    }

    @Override
    public void onSynthesizeFinish(String string2) {
        this.toPrint("onSynthesizeFinish utteranceId=" + string2);
    }

    @Override
    public void onSpeechStart(String string2) {
        this.isPlaying = true;
        this.toPrint("onSpeechStart utteranceId=" + string2);
    }

    @Override
    public void onSpeechProgressChanged(String string2, int n2) {
        this.toPrint("onSpeechProgressChanged" + n2);
    }

    @Override
    public void onSpeechFinish(String string2) {
        curentTime = new Date();
        temp = curentTime.getTime();
        this.isPlaying = false;
        this.toPrint("onSpeechFinish utteranceId=" + string2);
    }

    @Override
    public void onError(String string2, SpeechError speechError) {
        curentTime = new Date();
        this.isPlaying = false;
        temp = curentTime.getTime();
        this.toPrint("onSpeechFinish utteranceId=" + speechError.toString());
    }

    private class TimerSpeakTask
    extends TimerTask {
        private TimerSpeakTask() {
        }

        @Override
        public void run() {
            if (!VoiceManager.this.speakList.isEmpty()) {
                VoiceManager.this.kdxfTextToVoice(VoiceManager.this.speakList.remove(0));
            }
        }
    }
}

