/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech.aidl;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.iflytek.speech.SynthesizerListener;

public interface ISpeechSynthesizer
extends IInterface {
    public int synthesizeToUrl(Intent var1, SynthesizerListener var2) throws RemoteException;

    public int startSpeaking(Intent var1, SynthesizerListener var2) throws RemoteException;

    public int pauseSpeaking(SynthesizerListener var1) throws RemoteException;

    public int resumeSpeaking(SynthesizerListener var1) throws RemoteException;

    public int stopSpeaking(SynthesizerListener var1) throws RemoteException;

    public boolean isSpeaking() throws RemoteException;

    public String getLocalSpeakerList() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISpeechSynthesizer {
        private static final String DESCRIPTOR = "com.iflytek.speech.aidl.ISpeechSynthesizer";
        static final int TRANSACTION_synthesizeToUrl = 1;
        static final int TRANSACTION_startSpeaking = 2;
        static final int TRANSACTION_pauseSpeaking = 3;
        static final int TRANSACTION_resumeSpeaking = 4;
        static final int TRANSACTION_stopSpeaking = 5;
        static final int TRANSACTION_isSpeaking = 6;
        static final int TRANSACTION_getLocalSpeakerList = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISpeechSynthesizer asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ISpeechSynthesizer) {
                return (ISpeechSynthesizer)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n2, Parcel object, Parcel parcel, int n3) throws RemoteException {
            switch (n2) {
                case 1598968902: {
                    parcel.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    object.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != object.readInt() ? (Intent)Intent.CREATOR.createFromParcel(object) : null;
                    object = SynthesizerListener.Stub.asInterface(object.readStrongBinder());
                    int n4 = this.synthesizeToUrl(intent, (SynthesizerListener)object);
                    parcel.writeNoException();
                    parcel.writeInt(n4);
                    return true;
                }
                case 2: {
                    object.enforceInterface(DESCRIPTOR);
                    Intent intent = 0 != object.readInt() ? (Intent)Intent.CREATOR.createFromParcel(object) : null;
                    object = SynthesizerListener.Stub.asInterface(object.readStrongBinder());
                    int n5 = this.startSpeaking(intent, (SynthesizerListener)object);
                    parcel.writeNoException();
                    parcel.writeInt(n5);
                    return true;
                }
                case 3: {
                    object.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(object.readStrongBinder());
                    int n6 = this.pauseSpeaking(synthesizerListener);
                    parcel.writeNoException();
                    parcel.writeInt(n6);
                    return true;
                }
                case 4: {
                    object.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(object.readStrongBinder());
                    int n7 = this.resumeSpeaking(synthesizerListener);
                    parcel.writeNoException();
                    parcel.writeInt(n7);
                    return true;
                }
                case 5: {
                    object.enforceInterface(DESCRIPTOR);
                    SynthesizerListener synthesizerListener = SynthesizerListener.Stub.asInterface(object.readStrongBinder());
                    int n8 = this.stopSpeaking(synthesizerListener);
                    parcel.writeNoException();
                    parcel.writeInt(n8);
                    return true;
                }
                case 6: {
                    object.enforceInterface(DESCRIPTOR);
                    n2 = this.isSpeaking() ? 1 : 0;
                    parcel.writeNoException();
                    parcel.writeInt(n2 != 0 ? 1 : 0);
                    return true;
                }
                case 7: {
                    object.enforceInterface(DESCRIPTOR);
                    String string = this.getLocalSpeakerList();
                    parcel.writeNoException();
                    parcel.writeString(string);
                    return true;
                }
            }
            return super.onTransact(n2, object, parcel, n3);
        }

        private static class Proxy
        implements ISpeechSynthesizer {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int synthesizeToUrl(Intent intent, SynthesizerListener synthesizerListener) throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            @Override
            public int startSpeaking(Intent intent, SynthesizerListener synthesizerListener) throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            @Override
            public int pauseSpeaking(SynthesizerListener synthesizerListener) throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            @Override
            public int resumeSpeaking(SynthesizerListener synthesizerListener) throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            @Override
            public int stopSpeaking(SynthesizerListener synthesizerListener) throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(synthesizerListener != null ? synthesizerListener.asBinder() : null);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            @Override
            public boolean isSpeaking() throws RemoteException {
                boolean bl2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    bl2 = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl2;
            }

            @Override
            public String getLocalSpeakerList() throws RemoteException {
                String string;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    string = parcel2.readString();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return string;
            }
        }
    }
}

