package com.shitu.epathmap.ui.item;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.model.bean.AndroidLSRData;
import com.shitu.location.epathmap.utils.L;


public class AndroidLSRDataItem extends BaseRecyclerItemFactory<AndroidLSRDataItem.AndroidLSRDataRecyclerItem> {

    Context context;
    OnItemClickListener onItemClickListener;


    public AndroidLSRDataItem(Context context, OnItemClickListener onItemClickListener) {
        this.context = context;
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof AndroidLSRData;
    }

    @Override
    public AndroidLSRDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new AndroidLSRDataRecyclerItem(parent, this);
    }


    public class AndroidLSRDataRecyclerItem extends BaseRecyclerItem<AndroidLSRData, AndroidLSRDataItem> {


        private TextView tvName;
        private TextView tvBuildingId;
        private TextView btnDownload;
        private TextView tvCreate;
        private AndroidLSRData item;

        protected AndroidLSRDataRecyclerItem(ViewGroup parent, AndroidLSRDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_androidlsr, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvName = (TextView) convertView.findViewById(R.id.tv_name);
            tvBuildingId = (TextView) convertView.findViewById(R.id.tv_building_id);
            btnDownload = (TextView) convertView.findViewById(R.id.btn_download);
            tvCreate = (TextView) convertView.findViewById(R.id.tv_create);
        }

        @Override
        protected void onConfigViews(final Context context) {
            if (onItemClickListener != null) {

                btnDownload.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        onItemClickListener.onClick(item);
                        L.e("ddd", "开始下载文件");
                    }
                });
            }
        }

        @Override
        protected void onSetData(int position, AndroidLSRData item) {
            this.item = item;
            tvName.setText(item.getName());
            tvBuildingId.setText(item.getBuildingId());
            tvCreate.setText(item.getUpdateAt().toString());
        }

    }

    public interface OnItemClickListener {
        void onClick(AndroidLSRData item);
    }

}
