package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.DensityUtils;


/**
 * author:lfei
 */
public class NavPreBottomDialog {

    private PopupWindow popupWindow;
    private View contentView;
    private LinearLayout rlNavHint;
    private FrameLayout llNavHintMulti;
    //    private LinearLayout llEscalator;
//    private LinearLayout llElevator;
//    private TextView tvHint;
    private TextView tvHintFloor;
    private TextView tvHintDistance;
    private TextView tvHintTime;
    private TextView tvCurrent;
    //    private TextView tvNavigation;
    private TextView tvEscalator;
    private TextView tvElevator;
    private TextView tvNavigation;
    private TextView tvBourn;
    private FrameLayout flLocationEmpty;
    //    private ImageView ivEscalator;
//    private ImageView ivElevator;
    private Context context;
    private boolean escalatorMode = false;
    private boolean isMultiFloor = false;

    public NavPreBottomDialog(Context context, OnNavBtnClickListener onNavBtnClickListener,
                              OnFloorModeSelectListener onFloorModeSelectListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_pre_bottom, null);
        rlNavHint = (LinearLayout) contentView.findViewById(R.id.ll_nav_hint);
        llNavHintMulti = (FrameLayout) contentView.findViewById(R.id.ll_nav_hint_multi);
        flLocationEmpty = (FrameLayout) contentView.findViewById(R.id.fl_location_empty);
//        llEscalator = (LinearLayout) contentView.findViewById(R.id.ll_escalator);
//        llElevator = (LinearLayout) contentView.findViewById(R.id.ll_elevator);
//        tvHint = (TextView) contentView.findViewById(R.id.tv_hint);
        tvHintFloor = (TextView) contentView.findViewById(R.id.tv_hint_floor);
        tvBourn = (TextView) contentView.findViewById(R.id.tv_bourn);
        tvCurrent = (TextView) contentView.findViewById(R.id.tv_current);
        tvHintDistance = (TextView) contentView.findViewById(R.id.tv_hint_distance);
        tvHintTime = (TextView) contentView.findViewById(R.id.tv_hint_time);
//        tvNavigation = (TextView) contentView.findViewById(R.id.tv_navigation);
        tvNavigation = (TextView) contentView.findViewById(R.id.tv_navigation);
        tvElevator = (TextView) contentView.findViewById(R.id.tv_elevator);
        tvEscalator = (TextView) contentView.findViewById(R.id.tv_escalator);
//        ivElevator = (ImageView) contentView.findViewById(R.id.iv_elevator);
//        ivEscalator = (ImageView) contentView.findViewById(R.id.iv_escalator);

//        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
//                DensityUtils.dp2px(context, 162), false);

        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
                ViewGroup.LayoutParams.WRAP_CONTENT, false);

        contentView.findViewById(R.id.tv_navigation)
                .setOnClickListener(v -> onNavBtnClickListener.onNavStart());
        contentView.findViewById(R.id.iv_simulation)
                .setOnClickListener(v -> onNavBtnClickListener.onSimStart());

        tvElevator.setOnClickListener(v -> {
            escalatorMode = false;
            changeFloorMode(escalatorMode);
            onFloorModeSelectListener.elevatorMode();
        });
        tvEscalator.setOnClickListener(v -> {
            escalatorMode = true;
            changeFloorMode(escalatorMode);
            onFloorModeSelectListener.escalatorMode();
        });
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
        changeFloorMode(true);
    }

    public void setHintDistance(String hint) {
        tvHintDistance.setText(hint);
    }


    public void setHintTime(String hint) {
        tvHintTime.setText(hint);
    }

    public void setBtnNavEnable(boolean enable) {
        tvNavigation.setEnabled(enable);
        if (enable) {
            tvNavigation.setBackgroundResource(R.drawable.ipsmap_nav_start_enable);
        } else {
            tvNavigation.setBackgroundResource(R.drawable.ipsmap_nav_start_disable);
        }
//        tvNavigation.setEnabled(enable);
    }

    public void isShowNavHint(boolean isShowNavHint) {
        if (isShowNavHint) {
            rlNavHint.setVisibility(View.VISIBLE);
            flLocationEmpty.setVisibility(View.GONE);
        } else {
            rlNavHint.setVisibility(View.GONE);
            flLocationEmpty.setVisibility(View.VISIBLE);
        }
    }

    public void setMultiFloor(boolean multiFloor) {
        isMultiFloor = multiFloor;
        if (isMultiFloor) {
            tvHintFloor.setVisibility(View.GONE);
            llNavHintMulti.setVisibility(View.VISIBLE);
        } else {
            tvHintFloor.setVisibility(View.VISIBLE);
            llNavHintMulti.setVisibility(View.GONE);
        }
    }

    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public boolean isShowing() {
        return popupWindow.isShowing();
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            isShowNavHint(false);
            setBtnNavEnable(false);
            tvHintDistance.setText("");
            tvHintTime.setText("");
            escalatorMode = false;
            changeFloorMode(true);
            popupWindow.dismiss();
        }
    }

    public void gone() {
        if (popupWindow != null && popupWindow.isShowing()) {
            popupWindow.dismiss();
        }
    }


    public void changeFloorMode(boolean escalatorMode) {
        this.escalatorMode = escalatorMode;
        if (escalatorMode) {    //楼梯扶梯
//            llEscalator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_top_org1));
//            ivEscalator.setImageResource(R.drawable.ipsmap_escalator_enable);
//            llElevator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_bottom_grey));
//            ivElevator.setImageResource(R.drawable.ipsmap_elevator_disable);
            Drawable drawable;
            drawable = context.getResources().getDrawable(R.drawable.ipsmap_escalator_enable);
            drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
            tvEscalator.setCompoundDrawables(drawable, null, null, null);
            tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
            tvEscalator.setBackgroundResource(R.drawable.ipsmap_semicircle_full_right);


            tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_colorPrimary));
            tvElevator.setBackgroundResource(R.drawable.ipsmap_semicircle_border_left);
            Drawable drawable1;
            drawable1 = context.getResources().getDrawable(R.drawable.ipsmap_elevator_disable);
            drawable1.setBounds(0, 0, drawable1.getMinimumWidth(), drawable1.getMinimumHeight());
            tvElevator.setCompoundDrawables(drawable1, null, null, null);

        } else {    //电梯

            Drawable drawable;
            drawable = context.getResources().getDrawable(R.drawable.ipsmap_escalator_disable);
            drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
            tvEscalator.setCompoundDrawables(drawable, null, null, null);
            tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_colorPrimary));
            tvEscalator.setBackgroundResource(R.drawable.ipsmap_semicircle_border_right);

            Drawable drawable1;
            drawable1 = context.getResources().getDrawable(R.drawable.ipsmap_elevator_enable);
            drawable1.setBounds(0, 0, drawable1.getMinimumWidth(), drawable1.getMinimumHeight());
            tvElevator.setCompoundDrawables(drawable1, null, null, null);
            tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
            tvElevator.setBackgroundResource(R.drawable.ipsmap_semicircle_full_left);


//            llEscalator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_top_grey));
//            ivEscalator.setImageResource(R.drawable.ipsmap_escalator_disable);
//            tvEscalator.setTextColor(context.getResources().getColor(R.color.ipsmap_tvGrey3));
//            llElevator.setBackground(context.getResources().getDrawable(R.drawable.ipsmap_border_bottom_org1));
//            ivElevator.setImageResource(R.drawable.ipsmap_elevator_enable);
//            tvElevator.setTextColor(context.getResources().getColor(R.color.ipsmap_white));
//            tvEscalator.setBackgroundResource(R.drawable.ipsmap_semicircle_full_left);
        }
    }

    public void setHintFloor(String hintFloor) {
        tvHintFloor.setText(hintFloor);
    }

    public void setBourn(String hintFloor) {
        tvBourn.setText(hintFloor);
    }

    /**
     * 显示当前位置
     * @param hintFloor
     */
    public void setCurrentLocation(String hintFloor) {
        tvCurrent.setText(hintFloor);
    }


    /**
     * onNavStart 导航
     * onSimStart 模拟导航
     */
    public interface OnNavBtnClickListener {
        void onNavStart();

        void onSimStart();
    }

    /**
     * escalatorMode 扶梯
     * elevatorMode 电梯
     */
    public interface OnFloorModeSelectListener {
        void escalatorMode();

        void elevatorMode();
    }

}
