package com.shitu.epathmap.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.utils.StatusBarCompat;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.sails.engine.LocationRegion;


public class NavPreTopDialog {

    private final RelativeLayout rlStartRegion;
    private final RelativeLayout rlTargetRegion;
    private Context context;
    private PopupWindow popupWindow;
    private View contentView;
    private ImageView ivBack;
    private TextView tvStartRegion;
    private TextView tvStartFloor;
    private TextView tvTargetRegion;
    private TextView tvTargetFloor;
    private final ImageView ivExchange;

    public NavPreTopDialog(Context context, View.OnClickListener onStartClickListener,
                           View.OnClickListener onTargetClickListener,
                           View.OnClickListener onBackClickListener,
                           View.OnClickListener onExchangeListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_nav_pre_top, null);
        ivBack = (ImageView) contentView.findViewById(R.id.iv_back);
        tvStartRegion = (TextView) contentView.findViewById(R.id.tv_start_region);
        tvStartFloor = (TextView) contentView.findViewById(R.id.tv_start_floor);
        tvTargetRegion = (TextView) contentView.findViewById(R.id.tv_target_region);
        tvTargetFloor = (TextView) contentView.findViewById(R.id.tv_target_floor);
        ivBack.setOnClickListener(onBackClickListener);
        rlStartRegion = (RelativeLayout) contentView.findViewById(R.id.rl_start_region);
        rlStartRegion.setOnClickListener(onStartClickListener);
        rlTargetRegion = (RelativeLayout) contentView.findViewById(R.id.rl_target_region);
        rlTargetRegion.setOnClickListener(onTargetClickListener);
        ivExchange = (ImageView) contentView.findViewById(R.id.iv_exchange);
        ivExchange.setOnClickListener(onExchangeListener);
        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context), DensityUtils.dp2px(context, 110), false);
        popupWindow.setBackgroundDrawable(new BitmapDrawable());
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogTop);
    }

    public void setStartRegion(LocationRegion startRegion){
        if(startRegion != null ){
            ivExchange.setVisibility(View.VISIBLE);
            tvStartRegion.setText(startRegion.getName());
            if(startRegion.getName().equals("我的位置")){
                ivExchange.setVisibility(View.INVISIBLE);
            }else {
                ivExchange.setVisibility(View.VISIBLE);
            }
            tvStartFloor.setText(startRegion.getFloorDescription());
        }
    }


    public  void setEnableStartRegion(boolean isEnable){
        rlStartRegion.setEnabled(isEnable);
    }

    public void setEnableTargetRegion(boolean isEnable){
        rlTargetRegion.setEnabled(isEnable);
    }

    public void setExchangeVisibel(boolean isVisiable){
        ivExchange.setVisibility(View.INVISIBLE);
    }


    public void setStartRegion(String startRegion){
        if(startRegion.equals("我的位置")){
            ivExchange.setVisibility(View.INVISIBLE);
        }else {
            ivExchange.setVisibility(View.VISIBLE);
        }

        tvStartRegion.setText(startRegion);
    }

    public String getStartRegion(){

        return  tvStartRegion.getText().toString();
    }

    public void setStartFloor(String startFloor){
        tvStartFloor.setText(startFloor);
    }

    public void setTargetRegion(LocationRegion targetRegion){
        if(targetRegion != null){
            tvTargetRegion.setText(targetRegion.getName());
            tvTargetFloor.setText(targetRegion.getFloorDescription());
        }
    }


    public void show(View view) {
        if(popupWindow.isShowing()){
            return;
        }
        popupWindow.showAtLocation(view, Gravity.TOP, 0, 0);
        StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryTranslucent));
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            tvStartFloor.setText("");
            tvStartRegion.setText("");
            tvTargetFloor.setText("");
            tvTargetRegion.setText("");
            popupWindow.dismiss();
            StatusBarCompat.setColor((Activity) context, context.getResources().getColor(R.color.ipsmap_colorPrimaryDark));
        }
    }


}
