package com.shitu.epathmap.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.Nullable;

import com.shitu.epathmap.R;


import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.utils.IpsException;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.epathmap.utils.TUtil;
import com.parse.ParseException;

/**
 * author:lfei
 */
public abstract class BaseIpsMapActivity<P extends BasePresenter> extends BaseActivity implements IBaseView {

    public P presenter;
    public Project project;
    public Vibrator vibrator;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        presenter = TUtil.getT(this, 0);
        presenter.attachView(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onDestroy() {
        presenter.detachView();
        if (vibrator != null) {
            vibrator.cancel();
        }
        super.onDestroy();
    }

    @Override
    public void handleThrowable(IpsException ex) {
        String message = ex.getMsg();
        if (ex.getCode() == ParseException.OBJECT_NOT_FOUND) {
            T.showShort(R.string.ipsmap_no_result);
        } else if (ex.getCode() != ParseException.CACHE_MISS) {
            T.showShort(message);
        }
    }

    public void vibrate() {
        vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        long[] pattern = {0, 200};
        vibrator.vibrate(pattern, -1);
    }


}
