package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;

import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;
import com.shitu.epathmap.utils.ShareHandler;
import com.shitu.location.epathmap.utils.DensityUtils;
import com.shitu.location.epathmap.utils.MixpanelConstants;
import com.shitu.location.epathmap.utils.MixpanelEvent;

public class ShareDialog implements View.OnClickListener {

    private PopupWindow popupWindow;
    private View contentView;
    private Context context;
    private String url, title, description, type;
    private Bitmap bitmap;
    private ShareHandler shareHandler;
    private View.OnClickListener onCloseListener;
    public static final String TYPE_LOC_REGION = "locRegion", TYPE_MY_LOCATION = "myLocation",
            TYPE_LOC_SHARE = "locShare";

    public ShareDialog(Context context, String url, String title, String description, Bitmap bitmap, String type,
                       View.OnClickListener onCloseListener) {
        this.context = context;
        this.url = url;
        this.title = title;
        this.description = description;
        this.bitmap = bitmap;
        this.type = type;
        this.onCloseListener = onCloseListener;
        if (this.bitmap == null && type != null) {
            if (type.equals(TYPE_LOC_SHARE)) {
                this.bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.ipsmap_share_loc_share);
            } else {
                this.bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.ipsmap_share_region);
            }
        }
        shareHandler = new ShareHandler();
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_share, null);
        contentView.findViewById(R.id.ll_wechat).setOnClickListener(this);
        contentView.findViewById(R.id.ll_qq).setOnClickListener(this);
        contentView.findViewById(R.id.ll_msg).setOnClickListener(this);
        contentView.findViewById(R.id.tv_cancel).setOnClickListener(v -> dismiss());

        popupWindow = new PopupWindow(contentView, ViewGroup.LayoutParams.MATCH_PARENT,
                DensityUtils.dp2px(context, 175));

//        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context) -
//                DensityUtils.dp2px(context, 32),
//                DensityUtils.dp2px(context, 135));

//        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context) -
//                DensityUtils.dp2px(context, 32),
//                DensityUtils.dp2px(context, 135));

        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
    }


    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public boolean isShowing() {
        return popupWindow.isShowing();
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            onCloseListener.onClick(contentView.findViewById(R.id.tv_cancel));
            popupWindow.dismiss();
        }
    }


    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.ll_wechat) {
            if (type != null && type.equals(TYPE_LOC_REGION)) {
                MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_WECHAT, MixpanelConstants.LOC_SHARE_TYPE_LOCATION_REGION);
            } else if (type != null && type.equals(TYPE_MY_LOCATION)) {
                MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_WECHAT, MixpanelConstants.LOC_SHARE_TYPE_FRIEND_LOCATION);
            } else if (type != null && type.equals(TYPE_LOC_SHARE)) {
                MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_WECHAT, MixpanelConstants.LOC_SHARE_TYPE_LOC_SHARE);
            }
            if (EpathMapSDK.getShareToWechatListener() != null) {
                if (bitmap == null) {
                    bitmap = BitmapFactory.decodeResource(context.getResources(), R.drawable.ipsmap_logo);
                }
                EpathMapSDK.getShareToWechatListener().shareToWechat(url, title, description, bitmap);
            }
            dismiss();
        } else if (v.getId() == R.id.ll_qq) {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_QQ);
//            shareHandler.shareToQQ((Activity) context, title, description, url, "http://ipsmap.oss-cn-shanghai.aliyuncs.com/logo/ic_boxing_default_image2.jpg");
            dismiss();
        } else if (v.getId() == R.id.ll_msg) {
//            MixpanelEvent.locShare(MixpanelConstants.LOC_SHARE_CLICK_SMS);
            shareHandler.shareToMsg(context, url);
            dismiss();
        }
    }

    public int getHeight() {
        return DensityUtils.dp2px(context, 135);
    }


}


