package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.support.design.widget.BottomSheetDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.shitu.epathmap.EpathMapSDK;
import com.shitu.epathmap.R;
import com.shitu.epathmap.ui.utils.TextViewUtilis;

public class RegionDialog {

    private PopupWindow popupWindow;
    private BottomSheetDialog sheetDialog;
    private View contentView;
    private TextView tvRegionName;
    private TextView tvFloorName;
    private LinearLayout llBottom;
    private Context context;

    public RegionDialog(Context context,
                        View.OnClickListener onNavBtnClickListener,
                        View.OnClickListener sendLocationClickListener,
                        DialogInterface.OnDismissListener onDismissListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_region, null);
        tvRegionName = (TextView) contentView.findViewById(R.id.tv_region_name);
        tvFloorName = (TextView) contentView.findViewById(R.id.tv_floor_name);
        llBottom = (LinearLayout) contentView.findViewById(R.id.ll_bottom);
        contentView.findViewById(R.id.iv_nav).setOnClickListener(onNavBtnClickListener);
        contentView.findViewById(R.id.tv_send_loc).setOnClickListener(sendLocationClickListener);

        sheetDialog = new BottomSheetDialog(context);
        sheetDialog.setContentView(contentView);
        sheetDialog.setOnDismissListener(onDismissListener);
        sheetDialog.getWindow().setDimAmount(0);
//        popupWindow = new PopupWindow(contentView, DensityUtils.getScreenWidth(context),
//                ViewGroup.LayoutParams.WRAP_CONTENT, false);
//        popupWindow.setOutsideTouchable(false);
//        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
    }

    public void setRegionName(String name) {
        if (name.contains("(") && name.contains(")")) {
            tvRegionName.setText(TextViewUtilis.setPartColor(context, name, name.lastIndexOf("("), name.length(), R.color.ipsmap_tvGrey3));
        } else {
            tvRegionName.setText(name);
        }
    }

    public void setFloorName(String name) {
        tvFloorName.setText(name);
    }

    public void show(View view) {
        if (sheetDialog.isShowing()) {
            return;
        }
        if (EpathMapSDK.getShareToWechatListener() == null) {
            llBottom.setVisibility(View.GONE);
        } else {
            llBottom.setVisibility(View.VISIBLE);
        }
        sheetDialog.show();
//        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public void dismiss() {
        if (sheetDialog != null && sheetDialog.isShowing()) {
            sheetDialog.dismiss();
        }
    }

    public void setBottomVisible(boolean visible) {
        if (visible) {
            llBottom.setVisibility(View.VISIBLE);
        } else {
            llBottom.setVisibility(View.GONE);
        }
    }

    public String getRegionName() {
        return tvRegionName.getText().toString();
    }

    public String getFloorName() {
        String name = tvFloorName.getText().toString();
        if (name.startsWith("在")) {
            name = name.substring(1, name.length());
        }
        return name;
    }

}
