package com.shitu.epathmap.ui.item;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.shitu.epathmap.R;
import com.shitu.location.epathmap.model.bean.LocationRegionIconData;
import com.shitu.location.epathmap.utils.DensityUtils;


public class RegionIconDataItem extends BaseRecyclerItemFactory<RegionIconDataItem.LocationRegionDataRecyclerItem> {

    Context context;

    public RegionIconDataItem(Context context) {
        this.context = context;
    }

    @Override
    public boolean isTarget(Object itemObject) {
        return itemObject instanceof LocationRegionIconData;
    }

    @Override
    public LocationRegionDataRecyclerItem createBaseItem(ViewGroup parent) {
        return new LocationRegionDataRecyclerItem(parent, this);
    }

    public class LocationRegionDataRecyclerItem extends BaseRecyclerItem<LocationRegionIconData, RegionIconDataItem> {

        private TextView tvName;
        private ImageView iv;
        private LinearLayout llRoot;

        protected LocationRegionDataRecyclerItem(ViewGroup parent, RegionIconDataItem factory) {
            super(LayoutInflater.from(parent.getContext()).inflate(R.layout.ipsmap_item_region_icon, parent, false), factory);
        }

        @Override
        protected void onFindViews(View convertView) {
            tvName = (TextView) convertView.findViewById(R.id.tv_name);
            iv = (ImageView) convertView.findViewById(R.id.iv);
            llRoot = (LinearLayout) convertView.findViewById(R.id.ll_root);
        }

        @Override
        protected void onConfigViews(final Context context) {
            int width = (DensityUtils.getScreenWidth(context) - 40
                    - DensityUtils.dp2px(context, 16) * 3) / 4;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, width);
            params.setMargins(20, 0, 20, 0);
            llRoot.setLayoutParams(params);

            int width2 = width - DensityUtils.dp2px(context, 32);
            LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(width2, width2);
            iv.setLayoutParams(params2);
        }

        @Override
        protected void onSetData(int position, LocationRegionIconData item) {
            tvName.setText(item.getName());
            Glide.with(context)
                    .load(item.getIconUrl())
                    .crossFade()
                    .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                    .into(iv);
        }

    }


}
