/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import android.content.Context;
import android.os.Looper;
import com.baidu.tts.loopj.AsyncHttpClient$1;
import com.baidu.tts.loopj.AsyncHttpClient$2;
import com.baidu.tts.loopj.AsyncHttpClient$3;
import com.baidu.tts.loopj.AsyncHttpClient$4;
import com.baidu.tts.loopj.AsyncHttpRequest;
import com.baidu.tts.loopj.AsyncHttpResponseHandler;
import com.baidu.tts.loopj.HttpDelete;
import com.baidu.tts.loopj.HttpGet;
import com.baidu.tts.loopj.HttpPatch;
import com.baidu.tts.loopj.LogHandler;
import com.baidu.tts.loopj.LogInterface;
import com.baidu.tts.loopj.MyRedirectHandler;
import com.baidu.tts.loopj.MySSLSocketFactory;
import com.baidu.tts.loopj.PreemptiveAuthorizationHttpRequestInterceptor;
import com.baidu.tts.loopj.RequestHandle;
import com.baidu.tts.loopj.RequestParams;
import com.baidu.tts.loopj.ResponseHandlerInterface;
import com.baidu.tts.loopj.RetryHandler;
import com.baidu.tts.loopj.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClient {
    public static final String LOG_TAG = "AsyncHttpClient";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ENCODING_GZIP = "gzip";
    public static final int DEFAULT_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final int DEFAULT_RETRY_SLEEP_TIME_MILLIS = 1500;
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private int maxConnections = 10;
    private int connectTimeout = 10000;
    private int responseTimeout = 10000;
    private final DefaultHttpClient httpClient;
    private final HttpContext httpContext;
    private ExecutorService threadPool;
    private final Map<Context, List<RequestHandle>> requestMap;
    private final Map<String, String> clientHeaderMap;
    private boolean isUrlEncodingEnabled = true;
    public static LogInterface log = new LogHandler();

    public AsyncHttpClient() {
        this(false, 80, 443);
    }

    public AsyncHttpClient(int n2) {
        this(false, n2, 443);
    }

    public AsyncHttpClient(int n2, int n3) {
        this(false, n2, n3);
    }

    public AsyncHttpClient(boolean bl2, int n2, int n3) {
        this(AsyncHttpClient.getDefaultSchemeRegistry(bl2, n2, n3));
    }

    private static SchemeRegistry getDefaultSchemeRegistry(boolean bl2, int n2, int n3) {
        if (n2 <= 0) {
            n2 = 80;
            log.d(LOG_TAG, "Invalid HTTP port number specified, defaulting to 80");
        }
        if (n3 <= 0) {
            n3 = 443;
            log.d(LOG_TAG, "Invalid HTTPS port number specified, defaulting to 443");
        }
        SSLSocketFactory sSLSocketFactory = bl2 ? MySSLSocketFactory.getFixedSocketFactory() : SSLSocketFactory.getSocketFactory();
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), n2));
        schemeRegistry.register(new Scheme("https", (SocketFactory)sSLSocketFactory, n3));
        return schemeRegistry;
    }

    public AsyncHttpClient(SchemeRegistry schemeRegistry) {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)basicHttpParams, (long)this.connectTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(this.maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)this.responseTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)this.connectTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        schemeRegistry = this.createConnectionManager(schemeRegistry, basicHttpParams);
        Utils.asserts(schemeRegistry != null, "Custom implementation of #createConnectionManager(SchemeRegistry, BasicHttpParams) returned null");
        this.threadPool = this.getDefaultThreadPool();
        this.requestMap = Collections.synchronizedMap(new WeakHashMap());
        this.clientHeaderMap = new HashMap<String, String>();
        this.httpContext = new SyncBasicHttpContext((HttpContext)new BasicHttpContext());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)schemeRegistry, (HttpParams)basicHttpParams);
        this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new AsyncHttpClient$1(this));
        this.httpClient.addResponseInterceptor((HttpResponseInterceptor)new AsyncHttpClient$2(this));
        this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new AsyncHttpClient$3(this), 0);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(5, 1500));
    }

    public static void allowRetryExceptionClass(Class<?> clazz) {
        if (clazz != null) {
            RetryHandler.addClassToWhitelist(clazz);
        }
    }

    public static void blockRetryExceptionClass(Class<?> clazz) {
        if (clazz != null) {
            RetryHandler.addClassToBlacklist(clazz);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setLoggingEnabled(boolean bl2) {
        log.setLoggingEnabled(bl2);
    }

    public boolean isLoggingEnabled() {
        return log.isLoggingEnabled();
    }

    public void setLoggingLevel(int n2) {
        log.setLoggingLevel(n2);
    }

    public int getLoggingLevel() {
        return log.getLoggingLevel();
    }

    public LogInterface getLogInterface() {
        return log;
    }

    public void setLogInterface(LogInterface logInterface) {
        if (logInterface != null) {
            log = logInterface;
        }
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public void setThreadPool(ExecutorService executorService) {
        this.threadPool = executorService;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected ExecutorService getDefaultThreadPool() {
        return Executors.newCachedThreadPool();
    }

    protected ClientConnectionManager createConnectionManager(SchemeRegistry schemeRegistry, BasicHttpParams basicHttpParams) {
        return new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
    }

    public void setEnableRedirects(boolean bl2, boolean bl3, boolean bl4) {
        this.httpClient.getParams().setBooleanParameter("http.protocol.reject-relative-redirect", !bl3);
        this.httpClient.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", bl4);
        this.httpClient.setRedirectHandler((RedirectHandler)new MyRedirectHandler(bl2));
    }

    public void setEnableRedirects(boolean bl2, boolean bl3) {
        this.setEnableRedirects(bl2, bl3, true);
    }

    public void setEnableRedirects(boolean bl2) {
        this.setEnableRedirects(bl2, bl2, bl2);
    }

    public void setRedirectHandler(RedirectHandler redirectHandler) {
        this.httpClient.setRedirectHandler(redirectHandler);
    }

    public void setUserAgent(String string) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)string);
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n2) {
        if (n2 <= 0) {
            n2 = 10;
        }
        this.maxConnections = n2;
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)this.httpClient.getParams(), (ConnPerRoute)new ConnPerRouteBean(this.maxConnections));
    }

    public void setTimeout(int n2) {
        n2 = n2 < 1000 ? 10000 : n2;
        this.setConnectTimeout(n2);
        this.setResponseTimeout(n2);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2 < 1000 ? 10000 : n2;
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)this.connectTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectTimeout);
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(int n2) {
        this.responseTimeout = n2 < 1000 ? 10000 : n2;
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)this.responseTimeout);
    }

    public void setProxy(String string, int n2) {
        string = new HttpHost(string, n2);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)string);
    }

    public void setProxy(String string, int n2, String string2, String string3) {
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(string, n2), (Credentials)new UsernamePasswordCredentials(string2, string3));
        string = new HttpHost(string, n2);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)string);
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sSLSocketFactory, 443));
    }

    public void setMaxRetriesAndTimeout(int n2, int n3) {
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(n2, n3));
    }

    public void removeAllHeaders() {
        this.clientHeaderMap.clear();
    }

    public void addHeader(String string, String string2) {
        this.clientHeaderMap.put(string, string2);
    }

    public void removeHeader(String string) {
        this.clientHeaderMap.remove(string);
    }

    public void setBasicAuth(String string, String string2) {
        this.setBasicAuth(string, string2, false);
    }

    public void setBasicAuth(String string, String string2, boolean bl2) {
        this.setBasicAuth(string, string2, null, bl2);
    }

    public void setBasicAuth(String string, String string2, AuthScope authScope) {
        this.setBasicAuth(string, string2, authScope, false);
    }

    public void setBasicAuth(String string, String string2, AuthScope authScope, boolean bl2) {
        string = new UsernamePasswordCredentials(string, string2);
        this.setCredentials(authScope, (Credentials)string);
        this.setAuthenticationPreemptive(bl2);
    }

    public void setCredentials(AuthScope authScope, Credentials credentials) {
        if (credentials == null) {
            log.d(LOG_TAG, "Provided credentials are null, not setting");
            return;
        }
        this.httpClient.getCredentialsProvider().setCredentials(authScope == null ? AuthScope.ANY : authScope, credentials);
    }

    public void setAuthenticationPreemptive(boolean bl2) {
        if (bl2) {
            this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthorizationHttpRequestInterceptor(), 0);
            return;
        }
        this.httpClient.removeRequestInterceptorByClass(PreemptiveAuthorizationHttpRequestInterceptor.class);
    }

    public void clearCredentialsProvider() {
        this.httpClient.getCredentialsProvider().clear();
    }

    public void cancelRequests(Context object, boolean bl2) {
        if (object == null) {
            log.e(LOG_TAG, "Passed null Context to cancelRequests");
            return;
        }
        List<RequestHandle> list = this.requestMap.get(object);
        this.requestMap.remove(object);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            object = new AsyncHttpClient$4(this, list, bl2);
            this.threadPool.submit((Runnable)object);
            return;
        }
        this.cancelRequests(list, bl2);
    }

    private void cancelRequests(List<RequestHandle> object, boolean bl2) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((RequestHandle)object.next()).cancel(bl2);
            }
        }
    }

    public void cancelAllRequests(boolean bl2) {
        for (List<RequestHandle> list : this.requestMap.values()) {
            if (list == null) continue;
            list = list.iterator();
            while (list.hasNext()) {
                ((RequestHandle)list.next()).cancel(bl2);
            }
        }
        this.requestMap.clear();
    }

    public void cancelRequestsByTAG(Object object, boolean bl2) {
        if (object == null) {
            log.d(LOG_TAG, "cancelRequestsByTAG, passed TAG is null, cannot proceed");
            return;
        }
        for (List<RequestHandle> list : this.requestMap.values()) {
            if (list == null) continue;
            list = list.iterator();
            while (list.hasNext()) {
                RequestHandle requestHandle = (RequestHandle)list.next();
                if (!object.equals(requestHandle.getTag())) continue;
                requestHandle.cancel(bl2);
            }
        }
    }

    public RequestHandle head(String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.head(null, string, null, responseHandlerInterface);
    }

    public RequestHandle head(String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.head(null, string, requestParams, responseHandlerInterface);
    }

    public RequestHandle head(Context context, String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.head(context, string, null, responseHandlerInterface);
    }

    public RequestHandle head(Context context, String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpHead(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, string, requestParams)), null, responseHandlerInterface, context);
    }

    public RequestHandle head(Context context, String string, Header[] headerArray, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        string = new HttpHead(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, string, requestParams));
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, null, responseHandlerInterface, context);
    }

    public RequestHandle get(String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.get(null, string, null, responseHandlerInterface);
    }

    public RequestHandle get(String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.get(null, string, requestParams, responseHandlerInterface);
    }

    public RequestHandle get(Context context, String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.get(context, string, null, responseHandlerInterface);
    }

    public RequestHandle get(Context context, String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpGet(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, string, requestParams)), null, responseHandlerInterface, context);
    }

    public RequestHandle get(Context context, String object, Header[] headerArray, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpGet(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, object, requestParams));
        if (headerArray != null) {
            object.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle get(Context context, String string, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase(new HttpGet(URI.create(string).normalize()), httpEntity), string2, responseHandlerInterface, context);
    }

    public RequestHandle post(String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.post(null, string, null, responseHandlerInterface);
    }

    public RequestHandle post(String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.post(null, string, requestParams, responseHandlerInterface);
    }

    public RequestHandle post(Context context, String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.post(context, string, this.paramsToEntity(requestParams, responseHandlerInterface), null, responseHandlerInterface);
    }

    public RequestHandle post(Context context, String string, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(this.getURI(string)), httpEntity), string2, responseHandlerInterface, context);
    }

    public RequestHandle post(Context context, String string, Header[] headerArray, RequestParams requestParams, String string2, ResponseHandlerInterface responseHandlerInterface) {
        string = new HttpPost(this.getURI(string));
        if (requestParams != null) {
            string.setEntity(this.paramsToEntity(requestParams, responseHandlerInterface));
        }
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, responseHandlerInterface, context);
    }

    public RequestHandle post(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        string = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(this.getURI(string)), httpEntity);
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, responseHandlerInterface, context);
    }

    public RequestHandle put(String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.put(null, string, null, responseHandlerInterface);
    }

    public RequestHandle put(String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.put(null, string, requestParams, responseHandlerInterface);
    }

    public RequestHandle put(Context context, String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.put(context, string, this.paramsToEntity(requestParams, responseHandlerInterface), null, responseHandlerInterface);
    }

    public RequestHandle put(Context context, String string, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(this.getURI(string)), httpEntity), string2, responseHandlerInterface, context);
    }

    public RequestHandle put(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        string = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(this.getURI(string)), httpEntity);
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, responseHandlerInterface, context);
    }

    public RequestHandle patch(String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.patch(null, string, null, responseHandlerInterface);
    }

    public RequestHandle patch(String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.patch(null, string, requestParams, responseHandlerInterface);
    }

    public RequestHandle patch(Context context, String string, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.patch(context, string, this.paramsToEntity(requestParams, responseHandlerInterface), null, responseHandlerInterface);
    }

    public RequestHandle patch(Context context, String string, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase(new HttpPatch(this.getURI(string)), httpEntity), string2, responseHandlerInterface, context);
    }

    public RequestHandle patch(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        string = this.addEntityToRequestBase(new HttpPatch(this.getURI(string)), httpEntity);
        if (headerArray != null) {
            string.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string, string2, responseHandlerInterface, context);
    }

    public RequestHandle delete(String string, ResponseHandlerInterface responseHandlerInterface) {
        return this.delete(null, string, responseHandlerInterface);
    }

    public RequestHandle delete(Context context, String object, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpDelete(this.getURI((String)object));
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle delete(Context context, String object, Header[] headerArray, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpDelete(this.getURI((String)object));
        if (headerArray != null) {
            object.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public void delete(String object, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        object = new HttpDelete(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, object, requestParams));
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, asyncHttpResponseHandler, null);
    }

    public RequestHandle delete(Context context, String object, Header[] headerArray, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpDelete(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, object, requestParams));
        if (headerArray != null) {
            object.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle delete(Context context, String string, HttpEntity httpEntity, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase(new HttpDelete(URI.create(string).normalize()), httpEntity), string2, responseHandlerInterface, context);
    }

    protected AsyncHttpRequest newAsyncHttpRequest(DefaultHttpClient defaultHttpClient, HttpContext httpContext, HttpUriRequest httpUriRequest, String string, ResponseHandlerInterface responseHandlerInterface, Context context) {
        return new AsyncHttpRequest((AbstractHttpClient)defaultHttpClient, httpContext, httpUriRequest, responseHandlerInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestHandle sendRequest(DefaultHttpClient object, HttpContext object2, HttpUriRequest object3, String string, ResponseHandlerInterface responseHandlerInterface, Context context) {
        if (object3 == null) {
            throw new IllegalArgumentException("HttpUriRequest must not be null");
        }
        if (responseHandlerInterface == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (responseHandlerInterface.getUseSynchronousMode() && !responseHandlerInterface.getUsePoolThread()) {
            throw new IllegalArgumentException("Synchronous ResponseHandler used in AsyncHttpClient. You should create your response handler in a looper thread or use SyncHttpClient instead.");
        }
        if (string != null) {
            if (object3 instanceof HttpEntityEnclosingRequestBase && ((HttpEntityEnclosingRequestBase)object3).getEntity() != null && object3.containsHeader(HEADER_CONTENT_TYPE)) {
                log.w(LOG_TAG, "Passed contentType will be ignored because HttpEntity sets content type");
            } else {
                object3.setHeader(HEADER_CONTENT_TYPE, string);
            }
        }
        responseHandlerInterface.setRequestHeaders(object3.getAllHeaders());
        responseHandlerInterface.setRequestURI(object3.getURI());
        object = this.newAsyncHttpRequest((DefaultHttpClient)object, (HttpContext)object2, (HttpUriRequest)object3, string, responseHandlerInterface, context);
        this.threadPool.submit((Runnable)object);
        object = new RequestHandle((AsyncHttpRequest)object);
        if (context != null) {
            object3 = this.requestMap;
            synchronized (object3) {
                object2 = this.requestMap.get(context);
                if (object2 == null) {
                    object2 = Collections.synchronizedList(new LinkedList());
                    this.requestMap.put(context, (List<RequestHandle>)object2);
                }
            }
            object2.add(object);
            object3 = object2.iterator();
            while (object3.hasNext()) {
                if (!((RequestHandle)object3.next()).shouldBeGarbageCollected()) continue;
                object3.remove();
            }
        }
        return object;
    }

    protected URI getURI(String string) {
        return URI.create(string).normalize();
    }

    public void setURLEncodingEnabled(boolean bl2) {
        this.isUrlEncodingEnabled = bl2;
    }

    public static String getUrlWithQueryString(boolean bl2, String string, RequestParams requestParams) {
        String string2;
        if (string == null) {
            return null;
        }
        if (bl2) {
            try {
                Object object = URLDecoder.decode(string, "UTF-8");
                object = new URL((String)object);
                string = new URI(((URL)object).getProtocol(), ((URL)object).getUserInfo(), ((URL)object).getHost(), ((URL)object).getPort(), ((URL)object).getPath(), ((URL)object).getQuery(), ((URL)object).getRef()).toASCIIString();
            }
            catch (Exception exception) {
                log.e(LOG_TAG, "getUrlWithQueryString encoding URL", exception);
            }
        }
        if (requestParams != null && !(string2 = requestParams.getParamString().trim()).equals("") && !string2.equals("?")) {
            string = string + (string.contains("?") ? "&" : "?");
            string = string + string2;
        }
        return string;
    }

    public static boolean isInputStreamGZIPCompressed(PushbackInputStream pushbackInputStream) {
        if (pushbackInputStream == null) {
            return false;
        }
        byte[] byArray = new byte[2];
        int n2 = pushbackInputStream.read(byArray);
        pushbackInputStream.unread(byArray);
        int n3 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00;
        return n2 == 2 && 35615 == n3;
    }

    public static void silentCloseInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            log.w(LOG_TAG, "Cannot close input stream", iOException);
            return;
        }
    }

    public static void silentCloseOutputStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return;
        }
        catch (IOException iOException) {
            log.w(LOG_TAG, "Cannot close output stream", iOException);
            return;
        }
    }

    private HttpEntity paramsToEntity(RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        HttpEntity httpEntity = null;
        try {
            if (requestParams != null) {
                httpEntity = requestParams.getEntity(responseHandlerInterface);
            }
        }
        catch (IOException iOException) {
            if (responseHandlerInterface != null) {
                responseHandlerInterface.sendFailureMessage(0, null, null, iOException);
            }
            iOException.printStackTrace();
        }
        return httpEntity;
    }

    public boolean isUrlEncodingEnabled() {
        return this.isUrlEncodingEnabled;
    }

    private HttpEntityEnclosingRequestBase addEntityToRequestBase(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, HttpEntity httpEntity) {
        if (httpEntity != null) {
            httpEntityEnclosingRequestBase.setEntity(httpEntity);
        }
        return httpEntityEnclosingRequestBase;
    }

    public static void endEntityViaReflection(HttpEntity httpEntity) {
        if (httpEntity instanceof HttpEntityWrapper) {
            try {
                Field field = null;
                for (Field field2 : HttpEntityWrapper.class.getDeclaredFields()) {
                    if (!field2.getName().equals("wrappedEntity")) continue;
                    field = field2;
                    break;
                }
                if (field != null) {
                    field.setAccessible(true);
                    HttpEntity httpEntity2 = (HttpEntity)field.get(httpEntity);
                    if (httpEntity2 != null) {
                        httpEntity2.consumeContent();
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                log.e(LOG_TAG, "wrappedEntity consume", throwable);
            }
        }
    }

    static /* synthetic */ Map access$000(AsyncHttpClient asyncHttpClient) {
        return asyncHttpClient.clientHeaderMap;
    }

    static /* synthetic */ void access$100(AsyncHttpClient asyncHttpClient, List list, boolean bl2) {
        asyncHttpClient.cancelRequests(list, bl2);
    }
}

