package com.shitu.epathmap.ui.widget;

import android.content.Context;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;

import com.shitu.epathmap.R;
import com.shitu.location.epathmap.utils.DensityUtils;

public class LocShareCreateDialog {

    private PopupWindow popupWindow;
    private View contentView;
    private Context context;

    public LocShareCreateDialog(Context context, View.OnClickListener onCreateClickListener,
                                View.OnClickListener onJoinClickListener, PopupWindow.OnDismissListener onDismissListener) {
        this.context = context;
        LayoutInflater inflater = LayoutInflater.from(context);
        contentView = inflater.inflate(R.layout.ipsmap_dialog_loc_share_create, null);
        contentView.findViewById(R.id.ll_create).setOnClickListener(onCreateClickListener);
        contentView.findViewById(R.id.tv_join).setOnClickListener(onJoinClickListener);
        contentView.findViewById(R.id.iv_close).setOnClickListener(v -> dismiss());
        popupWindow = new PopupWindow(contentView, ViewGroup.LayoutParams.MATCH_PARENT,
                DensityUtils.dp2px(context, 180), true);
        popupWindow.setOutsideTouchable(false);
        popupWindow.setAnimationStyle(R.style.IpsmapDialogBottom);
        popupWindow.setOnDismissListener(onDismissListener);
    }

    public void show(View view) {
        if (popupWindow.isShowing()) {
            return;
        }
        popupWindow.showAtLocation(view, Gravity.BOTTOM, 0, 0);
    }

    public void dismiss() {
        if (popupWindow != null && popupWindow.isShowing()) {
            popupWindow.dismiss();
        }
    }


}
