/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.location.epathmap.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class EpUtils {
    private static String[] unitStringsZh = new String[]{"\u5206\u949f", "\u79d2", "\u5206"};
    private static String[] unitStringsEn = new String[]{" minute", " second", " minute"};

    public static String getDistanceTime(double d2) {
        double d3;
        String[] stringArray = unitStringsZh;
        if (!"zh".equals(Locale.getDefault().getLanguage())) {
            stringArray = unitStringsEn;
        }
        if ((d3 = d2 / 1.5 / 60.0) >= 1.0) {
            return (int)d3 + stringArray[0];
        }
        return (int)(d3 * 60.0) + stringArray[1];
    }

    public static String getTimeStr(int n2) {
        String[] stringArray = unitStringsZh;
        if (!"zh".equals(Locale.getDefault().getLanguage())) {
            stringArray = unitStringsEn;
        }
        String string2 = n2 + stringArray[1];
        if (n2 >= 60) {
            string2 = n2 / 60 + stringArray[2] + n2 % 60 + stringArray[1];
        }
        return string2;
    }

    public static String encodeString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return Base64.encodeToString((byte[])string2.getBytes(), (int)0);
    }

    public static String decodeString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return new String(Base64.decode((byte[])string2.getBytes(), (int)0));
    }

    public static String getRadomGroupId() {
        String string2 = "" + (int)(Math.random() * 10000.0);
        while (4 - string2.length() > 0) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public static String getDeviceID() {
        String string2 = "" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
        try {
            String string3 = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(string2.hashCode(), string3.hashCode()).toString();
        }
        catch (Exception exception) {
            String string4 = "serial";
            return new UUID(string2.hashCode(), string4.hashCode()).toString();
        }
    }

    public static void copyToClipboard(Context context, String string2) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)string2);
        clipboardManager.setPrimaryClip(clipData);
    }

    public static String getFirstClipboard(Context context) {
        ClipData.Item item;
        String string2 = "";
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = clipboardManager.getPrimaryClip();
        if (clipData != null && clipData.getItemCount() > 0 && (item = clipData.getItemAt(0)).getText() != null) {
            string2 = item.getText().toString();
        }
        return string2;
    }

    public static void clearClipboard(Context context) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)"");
        clipboardManager.setPrimaryClip(clipData);
    }

    public static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getInstalledPackages(0);
        if (list != null) {
            List list2 = packageManager.queryIntentActivities(intent, 65536);
            return list2.size() > 0;
        }
        return false;
    }

    public static boolean isWeixinAvilible(Context context) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getInstalledPackages(0);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string2 = ((PackageInfo)list.get((int)i2)).packageName;
                if (!string2.equals("com.tencent.mm")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isQQClientAvailable(Context context) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getInstalledPackages(0);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string2 = ((PackageInfo)list.get((int)i2)).packageName;
                if (!string2.equals("com.tencent.mobileqq")) continue;
                return true;
            }
        }
        return false;
    }
}

