package com.shitu.location.epathmap.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;

import java.util.List;
import java.util.Locale;
import java.util.UUID;

/**
 * author:lfei
 */
public class EpUtils {
    private static String[] unitStringsZh = {"分钟","秒","分"};
    private static String[] unitStringsEn = {" minute"," second"," minute"};

    public static String getDistanceTime(double distance) {
        String[] unitStrings = unitStringsZh;
        if(!"zh".equals(Locale.getDefault().getLanguage())){
            unitStrings = unitStringsEn;
        }

        double time = distance / EpConstants.PACE / 60;
        if (time >= 1) {
            return (int) time + unitStrings[0];
        } else {
            return (int) (time * 60) + unitStrings[1];
        }
    }

    public static String getTimeStr(int seconds) {
        String[] unitStrings = unitStringsZh;
        if(!"zh".equals(Locale.getDefault().getLanguage())){
            unitStrings = unitStringsEn;
        }

        String timeStr = seconds + unitStrings[1];
        if (seconds >= 60) {
            timeStr = seconds / 60 + unitStrings[2] + seconds % 60 + unitStrings[1];
        }
        return timeStr;
    }

    public static String encodeString(String pwd) {
        if (TextUtils.isEmpty(pwd)) {
            return null;
        }
        return Base64.encodeToString(pwd.getBytes(), Base64.DEFAULT);
    }

    public static String decodeString(String pwd) {
        if (TextUtils.isEmpty(pwd)) {
            return null;
        }
        return new String(Base64.decode(pwd.getBytes(), Base64.DEFAULT));
    }

    public static String getRadomGroupId() {
        String id = "" +  (int)(Math.random() * 10000);
        while (4 - id.length() > 0) {
            id = "0" + id;
        }
        return id;
    }

    public static String getDeviceID() {
        String m_szDevIDShort = ""  //we make this look like a valid IMEI
                + Build.BOARD.length() % 10
                + Build.BRAND.length() % 10
                + Build.CPU_ABI.length() % 10
                + Build.DEVICE.length() % 10
                + Build.DISPLAY.length() % 10
                + Build.HOST.length() % 10
                + Build.ID.length() % 10
                + Build.MANUFACTURER.length() % 10
                + Build.MODEL.length() % 10
                + Build.PRODUCT.length() % 10
                + Build.TAGS.length() % 10
                + Build.TYPE.length() % 10
                + Build.USER.length() % 10;  //13 digits
        String serial;
        try {
            serial = android.os.Build.class.getField("SERIAL").get(null).toString();
            //API>=9 使用serial号
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        } catch (Exception exception) {
            //serial需要一个初始化
            serial = "serial"; // 随便一个初始化
        }
        return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
    }

    public static void copyToClipboard(Context context, String content){
        ClipboardManager cm = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData mClipData = ClipData.newPlainText("text", content);
        cm.setPrimaryClip(mClipData);
    }

    public static String getFirstClipboard(Context context){
        String text = "";
        ClipboardManager cm = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData mClipData = cm.getPrimaryClip();
        if(mClipData != null && mClipData.getItemCount() > 0){
            ClipData.Item item = mClipData.getItemAt(0);
            if(item.getText() != null){
                text = item.getText().toString();
            }
        }
        return text;
    }

    public static void clearClipboard(Context context){
        ClipboardManager cm = (ClipboardManager) context.getSystemService(Context.CLIPBOARD_SERVICE);
        ClipData mClipData = ClipData.newPlainText("text", "");
        cm.setPrimaryClip(mClipData);
    }

    public static boolean isIntentAvailable(Context context, Intent intent) {
        final PackageManager packageManager = context.getPackageManager();
        List<PackageInfo> pinfo = packageManager.getInstalledPackages(0);// 获取所有已安装程序的包信息
        if (pinfo != null){
            List<ResolveInfo> list =
                    packageManager.queryIntentActivities(intent,
                            PackageManager.MATCH_DEFAULT_ONLY);
            return list.size() > 0;
        }else {
            return false;
        }

    }

    public static boolean isWeixinAvilible(Context context) {
        final PackageManager packageManager = context.getPackageManager();// 获取packagemanager
        List<PackageInfo> pinfo = packageManager.getInstalledPackages(0);// 获取所有已安装程序的包信息
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); i++) {
                String pn = pinfo.get(i).packageName;
                if (pn.equals("com.tencent.mm")) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * 判断qq是否可用
     *
     * @param context
     * @return
     */
    public static boolean isQQClientAvailable(Context context) {
        final PackageManager packageManager = context.getPackageManager();
        List<PackageInfo> pinfo = packageManager.getInstalledPackages(0);
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); i++) {
                String pn = pinfo.get(i).packageName;
                if (pn.equals("com.tencent.mobileqq")) {
                    return true;
                }
            }
        }
        return false;
    }


}
