package com.shitu.location.uploadlocation.impl;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;


import com.shitu.location.R;
import com.shitu.location.epathmap.model.bean.BackgroundData;
import com.shitu.location.epathmap.model.parse.Background;
import com.shitu.location.epathmap.model.parse.BeaconMap;
import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.utils.Constants;
import com.shitu.location.epathmap.utils.EpUtils;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.MixpanelEvent;
import com.shitu.location.epathmap.utils.SpUtils;
import com.shitu.location.uploadlocation.AbsWorkService;
import com.shitu.location.uploadlocation.EpathLocationBackgroundListener;
import com.shitu.location.uploadlocation.engine.BLESourceController;
import com.shitu.location.uploadlocation.engine.SAILSSensorEventListener;
import com.shitu.location.uploadlocation.engine.SensorAdapter;
import com.shitu.location.uploadlocation.engine.model.Satellite;

import com.parse.FindCallback;
import com.parse.GetCallback;
import com.parse.ParseException;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.sails.engine.LocationData;
import com.sails.engine.LocationRegion;
import com.sails.engine.SAILS;
import com.sails.engine.SensorElement;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.shitu.location.epathmap.model.parse.Background.locationRegion;
import static com.shitu.location.epathmap.model.parse.Background.locationRegions;
import static java.lang.System.currentTimeMillis;

public class TraceServiceImpl extends AbsWorkService {
    //是否 任务完成, 不再需要服务运行?
    public static boolean sShouldStopService;
    //    public static Disposable sDisposable;
    private static SensorAdapter sensorAdapter;
    private static boolean isForStop = false;

    private boolean isRunning;
    private static SAILSSensorEventListener sensorEventListener;
    private NotificationManager notifyManager;
    private NotificationCompat.Builder builder;
    private static boolean buildingLoaded=false;
    private SAILS sails=null;
    private static boolean isQuary = false;
    private HashMap<String , Integer> allBeacons = null;
    private int beaconsNumber;
    private int maxNumber = 0;
    private String maxLocationRagion;
    private String projectTaken;
    private String projectBuildingId;
    private String objectId;
    private ParseObject project;
    private String lastMaxLocationRagion;
    private long lastTime = 0;
    private long currentTime;
    private List<LocationRegion> lastLocationDataInRegions;
    private List<LocationRegion> locationDataInRegions;
    private long duratiomTime;
    private long lastScanTime = 0;
    private long scanTime;
    private static int queryBeaconsSpeed = 1;
    private static int hasQueryTime = 7;
    private List<SensorElement.Beacon> beacons;
    private static  Boolean openAutoTurnOnBt = true;
    private static EpathLocationBackgroundListener epathLocationBackgroundListener;

    //    public static void setTargActivity(Activity activity){
//        TraceServiceImpl.activity = activity;
//        isQuary = false;
//        buildingLoaded = false;
//        queryBeaconsSpeed = 1;
//        hasQueryTime = 7;
//    }

    private static int BACK_UPLOAD_FREQUENCY = 10;

    public static void setBackUpFrequency(int frequency){
        BACK_UPLOAD_FREQUENCY = frequency;
    }



    public static void setAutoTurnOnBT(boolean autoTurnOnBT) {
        openAutoTurnOnBt = autoTurnOnBT;
        BLESourceController.setAutoTurnOnBT(openAutoTurnOnBt);
    }
    public static  void registerBackgroundListerner(EpathLocationBackgroundListener backgroundListener) {
        epathLocationBackgroundListener = backgroundListener;
    }

    public static  void stopService() {
//        if()
//        if()
//        T.showShort("停止背景服务！");
        //我们现在不再需要服务运行了, 将标志位置为 true
        L.e("ddd","停止服务!");
        sShouldStopService = true;
        //取消对任务的订阅
//        Intent intent = new Intent();
//        intent.setAction(UploadContants.CANCLE_ACTION);
//        intent.putExtra(UploadContants.START_OR_STOP_SERVICE, false);
//        this.sendBroadcast(intent);
//        if (sDisposable != null) sDisposable.dispose();
//        sDisposable = null;
        //取消 Job / Alarm / Subscription
        cancelJobAlarmSub();
        if (sensorAdapter != null) {
            sensorAdapter.stop();
            sensorEventListener = null;
            sensorAdapter = null;
            isForStop = true;
        }
        epathLocationBackgroundListener = null;
        isQuary = false;
        buildingLoaded = false;
        queryBeaconsSpeed = 1;
        hasQueryTime = 7;
    }

    /**
     * 是否 任务完成, 不再需要服务运行?
     *
     * @return 应当停止服务, true; 应当启动服务, false; 无法判断, 什么也不做, null.
     */
    @Override
    public Boolean shouldStopService(Intent intent, int flags, int startId) {
        return sShouldStopService;
    }

    private void sendNotification() {
        //获取PendingIntent


        // PendingIntent mainPendingIntent = PendingIntent.getActivity(this, 0, mainIntent, PendingIntent.FLAG_UPDATE_CURRENT);
        //获取NotificationManager实例
        notifyManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        //实例化NotificationCompat.Builde并设置相关属性
        //设置小图标
        //设置通知标题
        //设置通知内容
        builder = (NotificationCompat.Builder) new NotificationCompat.Builder(this)
                //设置小图标
                .setSmallIcon(R.drawable.ic_launcher)
                //设置通知标题
                .setContentTitle("您已经进入可以使用室内导航的场域")
//                    .setContentIntent(mainPendingIntent)
                .setDefaults(Notification.DEFAULT_ALL)
                //设置通知内容
                .setContentText("背景定位中。。。");
        //设置通知时间，默认为系统发出通知的时间，通常不用设置
        //.setWhen(System.currentTimeMillis());
        //通过builder.build()方法生成Notification对象,并发送通知,id=1

    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
//        T.showShort("开启背景服务");
        L.e("dddd","开启服务");
        super.onStartCommand(intent, flags, startId);
        if (sensorAdapter != null){
            sensorAdapter.stop();
            sensorEventListener = null;
            sensorAdapter = null;
        }


//        stopService();
        System.out.println("检查磁盘中是否有上次销毁时保存的数据");
        beacons = new ArrayList<>();
//        buildingLoaded=false;
        //所有的allBeacons
        allBeacons = new HashMap<String , Integer>();
        //区域列表
        if (sensorEventListener == null){
            sensorEventListener = new SAILSSensorEventListener() {
                @Override
                public void onBLEScan(List<Satellite> scanResults) {
                    if(scanResults!= null &&!scanResults.isEmpty()){
                        onBeaconProcess(scanResults);
                    }

                }
            };
        }else {
            L.e("ddd","初始化 sensorEventListener");
        }
        if (sensorAdapter == null){

            sensorAdapter = new SensorAdapter(this).setOnSensorEventListner(sensorEventListener).run();
        }else {
            L.e("ddd","初始化 sensorAdapter");
        }

        isRunning = true;
        return START_STICKY;
    }

    private void initSail(String taken ,String buildingId) {
        sendNotification();
        sails = new SAILS(this);
        sails.setServerURL(Constants.CLOUD_SERVER_URL);
        if (TextUtils.isEmpty(taken)){
            projectTaken = "2785017aa2d84dc09e02b6e138b1b1ed";
        }else {
            projectBuildingId = buildingId;
            int guideWhiteList = SpUtils.getNotificationTime(getApplicationContext());
            Date date =  new Date();
            int dayTime = date.getDate();
            if (dayTime != guideWhiteList){
                notifyManager.notify(1, builder.build());
                SpUtils.setNotificationTime(getApplicationContext(),dayTime);
            }

//            new Handler().postDelayed(() ->   notifyManager.notify(1, builder.build()), 5000);
        }
        if (TextUtils.isEmpty(buildingId)){
            projectBuildingId = "58f7006bcba5c23cd9e3008e";
        }else {
            projectTaken = taken;
        }
        sails.loadCloudBuilding(projectTaken, projectBuildingId, new SAILS.OnLoadStatusCallback() {
            @Override
            public void onCacheLoaded() {
                buildingLoaded=true;
                isQuary = false;
                Log.d("sails","cached loaded success");
            }

            @Override
            public void onNetworkLoadingProgress(boolean b, int i) {
                if(b) {
                    buildingLoaded=true;
                    isQuary = false;
                }
                Log.d("sails","download %:"+Integer.toString(i));
            }

            @Override
            public void onNetworkLoadingFailed(String s) {
                Log.d("sails","error:"+s);
                isQuary = false;
//                isQuary = false;
                buildingLoaded = false;
            }
        });
    }

    @Override
    public void startWork(Intent intent, int flags, int startId) {

    }


    private void onBeaconProcess(List<Satellite> scanResults) {
        if (scanResults.size() > 0) {
            beacons.clear();
            for(Satellite s:scanResults) {
                SensorElement.Beacon b = new SensorElement.Beacon();
                b.rssi = s.getRSSI();
                b.id_btle = s.mBP.id_btle;
                beacons.add(b);
//                Log.e("sails", "beacons:" + b.rssi+" "+b.id_btle);
                b = null;
                String mac_btle = s.mBP.mac_btle;
//                long currentTime = System.currentTimeMillis();
                if (!isQuary&&!buildingLoaded ){
                    isQuary = true;
                    //如果第一次扫描,没有下载地图
//                    Log.e("buildingLoaded", mac_btle);
                    //查的次数愈多,查询频率越慢
                    if(queryBeaconsSpeed % (hasQueryTime) == 0){
//                        queryBeaconsSpeed++;
                        initQueryBeacons(mac_btle);
//                        Log.e("ssss1", mac_btle);
                    }else {
                        isQuary = false;
                        queryBeaconsSpeed++;
//                        Log.e("ssss2", ""+queryBeaconsSpeed);
                    }

                }else {
//                    Log.e("buildingLoaded", mac_btle);
                }
            }
            if(!buildingLoaded){
                Log.e("buildingLoaded", "false");
                return;
            }else {
                Log.e("buildingLoaded", "true");
            }
            Log.e("sails", "beacons: size" + beacons.size());
            LocationData locationData = sails.calculateBackgroundLocation(beacons);

            if(locationData!=null) {
                scanTime = System.currentTimeMillis();
                long scanDuratiomTime = scanTime - lastScanTime;
                Log.e("sails", "-----------beaconsNumber-------"+beaconsNumber);
                Log.e("sails", "floorname:" + locationData.floorName);
                Log.e("sails", "longitude:" + Double.toString(locationData.longitude));
                Log.e("sails", "latitude:" + Double.toString(locationData.latitude));
                if (lastScanTime != 0){
                    Log.e("sails", "scanDuration:" + scanDuratiomTime);
                }
                lastScanTime = scanTime;
                if (locationDataInRegions!= null){
                    locationDataInRegions = locationData.getInRegions(sails);
                    if (locationDataInRegions == null){
                        L.e("sails","locationDataInRegions == null");
                        return;
                    }
                }else {
                    //第一次上传的特殊处理
                    locationDataInRegions = locationData.getInRegions(sails);
                    Log.e("sails","第一次特殊处理");
                    lastTime = System.currentTimeMillis();
                    if(locationDataInRegions!=null){
                        lastLocationDataInRegions = new ArrayList<>(locationDataInRegions);
                    }else {
                        L.e("sails","locationDataInRegions == null");
                        return;
                    }
                }
                if (locationDataInRegions !=null && locationDataInRegions.size()>0){
                    LocationRegion locationRegion = locationDataInRegions.get(0);
                    if (locationRegion!= null){
                        //每次对locationDataInRegions.get(0);取出进行添加 10 次处理
                        if (allBeacons.containsKey(locationRegion.label)){
                            allBeacons.put(locationRegion.label,allBeacons.get(locationRegion.label)+1);
                            //     L.e("maxNumber3 ",maxNumber +" maxLocationRagion no detail "+locationRegion.label);
                            beaconsNumber++;
                        }else {
                            allBeacons.put(locationRegion.label,0);
                            //  L.e("maxNumber3 ",maxNumber +" maxLocationRagion no detail "+locationRegion.label);
                            beaconsNumber++;
                        }
                        if (beaconsNumber % BACK_UPLOAD_FREQUENCY ==0){
                            //10s算一次,在哪一个场域,如果相同的场域不上传,在不同的场域上传数据
                            Set<Map.Entry<String, Integer>> entries = allBeacons.entrySet();
                            //防止后期有可能比较低的数字,一定要清零
                         //   maxNumber = 0;
                            for (Map.Entry<String, Integer> entry : entries) {
                                String key = entry.getKey();
                                Integer value = entry.getValue();
                                if (value > maxNumber){
                                    maxNumber = value;
                                    maxLocationRagion = key;
                                }
                            }
                            if (lastMaxLocationRagion== null && maxNumber>BACK_UPLOAD_FREQUENCY/2){
                                lastMaxLocationRagion = maxLocationRagion;

                                L.e("maxNumber1 ",maxNumber +" maxLocationRagion "+maxLocationRagion);

                                if (lastLocationDataInRegions!=null){
                                    uploadData(lastLocationDataInRegions);
                                } else {
                                    L.e("maxNumber1","lastLocationDataInRegions == null");
                                }
                                lastMaxLocationRagion = maxLocationRagion;
                                lastLocationDataInRegions = new ArrayList<>(locationDataInRegions);

                                clearData();
                            } else if (maxNumber>BACK_UPLOAD_FREQUENCY/2){
                                L.e("maxNumber2 ",maxNumber +" maxLocationRagion "+maxLocationRagion);
                                if (lastLocationDataInRegions!=null){
                                    uploadData(lastLocationDataInRegions);
                                }else {
                                    L.e("maxNumber2","lastLocationDataInRegions == null");
                                }
                                lastMaxLocationRagion = maxLocationRagion;
                                lastLocationDataInRegions = new ArrayList<>(locationDataInRegions);
                                clearData();
                            }

//                            if (!maxLocationRagion.equals(lastMaxLocationRagion)&&maxNumber>BACK_UPLOAD_FREQUENCY/2){
//                                L.e("maxNumber2 ",maxNumber +" maxLocationRagion "+maxLocationRagion);
//                                if (lastLocationDataInRegions!=null){
//                                    uploadData(lastLocationDataInRegions);
//                                }
//                                lastMaxLocationRagion = maxLocationRagion;
//                                lastLocationDataInRegions = new ArrayList<>(locationDataInRegions);
//                                clearData();
//                            }else if (maxLocationRagion.equals(lastMaxLocationRagion)){
////                                lastLocationDataInRegions = new ArrayList<>(locationDataInRegions);
//                                //相同的场域
//                                L.e("maxNumber2 ","相同."+maxLocationRagion);
//                                clearData();
//                            }

                        }

//                        Log.e("sails", "locationDataInRegions:" + locationRegion.label + " time :");
                    }
                }

            }else {
                beacons.clear();
                L.e("sails","locationDataInRegions == null");
            }
        }


    }

    private void clearData() {
        allBeacons.clear();
        maxNumber = 0;
        beaconsNumber = 0;
    }

    private void uploadData(List<LocationRegion> locationDataInRegions) {

        Background background = new Background();
        BackgroundData backgroundData = new BackgroundData();
        ArrayList<String> locations = new ArrayList<>();
        for (int i = 0; i < locationDataInRegions.size(); i++) {
            locations.add(locationDataInRegions.get(i).label);
        }
        if (locations.size() == 0){
            return;
        }
        LocationRegion locationRegion1 = locationDataInRegions.get(0);
        double centerLatitude = locationRegion1.getCenterLatitude();
        double centerLongitude = locationRegion1.getCenterLongitude();
        ParseGeoPoint geoPoint = new ParseGeoPoint(centerLatitude, centerLongitude);
        background.put(Background.lonLat,geoPoint);
        backgroundData.setLonLat(geoPoint);
        String name = locations.get(0);
        if (!TextUtils.isEmpty(name)){
            background.put(locationRegion,locations.get(0));
            backgroundData.setLocationRegion(locations.get(0));
        }else {
            background.put(locationRegion,"");
            backgroundData.setLocationRegion("");
        }
        background.put(locationRegions,locations);
        backgroundData.setLocationRegions(locations);
        background.put(Background.deviceId, EpUtils.getDeviceID());
        backgroundData.setDeviceId(EpUtils.getDeviceID());
        background.put(Background.floorName, locationRegion1.getFloorName());
        backgroundData.setFloorName(locationRegion1.getFloorName());
        background.put(Background.phoneNumber, SpUtils.getUserMobile(getBaseContext()));
        backgroundData.setFloorName(SpUtils.getUserMobile(getBaseContext()));
        if (lastTime != 0){
            currentTime = currentTimeMillis();
            duratiomTime = currentTime - lastTime;
            if (duratiomTime/1000 > 9 ){
                background.put(Background.durationTime, duratiomTime/1000);
                background.put(Background.enterAt,new Date(lastTime));
                background.put(Background.leaveAt,new Date(currentTime));
                backgroundData.setDurationTime(duratiomTime/1000);
                backgroundData.setEnterAt(new Date(lastTime));
                backgroundData.setLeaveAt(new Date(currentTime));
                L.e("time1",""+duratiomTime);
                lastTime = currentTime;
            }else {
                L.e("time2",""+duratiomTime);
                return;
            }
        }else {
            currentTime = currentTimeMillis();
            background.put(Background.enterAt,new Date(currentTime));
            background.put(Background.leaveAt,new Date(currentTime));
            background.put(Background.durationTime, 0);
            backgroundData.setDurationTime(0);
            backgroundData.setEnterAt(new Date(currentTime));
            backgroundData.setLeaveAt(new Date(currentTime));
            L.e("time3",""+duratiomTime);
            lastTime = currentTime;
        }
        background.put(Background.project,project);
        backgroundData.setProject(project.toString());
        if (epathLocationBackgroundListener !=null){
            epathLocationBackgroundListener.onReceiveBackGroundLocation(backgroundData);
        }else {
            L.e("ddd","epathLocationBackgroundListener == null");
        }

        L.e("ddd","backgroundData: "+backgroundData.toString());
        background.saveInBackground(e -> {
            if (e != null) {
                e.printStackTrace();
                return;
            }else {
//                background.put(locationRegions,locationDataInRegions.get(0).label);
                L.e("ddd","上传成功"+duratiomTime+" "+locations.get(0));
            }
        });
//        String backGroundJson = JSONUtils.toJson(backgroundData);
//        SpUtils.setBackGroundJson(getBaseContext(),backGroundJson);
//        String backGroundJson1 = SpUtils.getBackGroundJson(getBaseContext());
//        L.e("ddd",backGroundJson1);
        MixpanelEvent.backGroudUploadData(backgroundData);
    }

    private void uploadMyLocation() {

    }

    private void initQueryBeacons(String mac_btle ) {
        hasQueryTime = hasQueryTime + 10;
        if (hasQueryTime > 10007){
            //防止过大
            hasQueryTime = 7;
        }
        ParseQuery.getQuery(BeaconMap.class)
                .whereEqualTo("mac",mac_btle)
//                .setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK)
                .getFirstInBackground(new GetCallback<BeaconMap>() {
                    @Override
                    public void done(BeaconMap beaconMap, ParseException e) {
                        if (e != null) {
                            e.printStackTrace();
                            isQuary = false;
                            return;
                        }
                        if (beaconMap!= null&&beaconMap.getProject()!=null){
                            project = beaconMap.getProject();
                            objectId = project.getObjectId();
                            ParseQuery.getQuery(Project.class)
                                    .whereEqualTo("objectId", project.getObjectId())
                                    .findInBackground(new FindCallback<Project>() {
                                        @Override
                                        public void done(List<Project> objects, ParseException e) {
                                            if (e!= null){
                                                e.printStackTrace();
                                                isQuary = false;
                                                return;
                                            }
                                            if (objects.size() > 0){
                                                L.e("eeee","cishu");
                                                Project project1 = objects.get(0);
                                                if (project1!= null){
                                                    if (!buildingLoaded && project1 != null){
                                                        String buildingId = project1.getBuildingIdBg();
                                                        String token = project1.getTokenBg();

                                                        if (buildingId==null||token == null){
                                                            buildingId = project1.getBuildingId();
                                                             token = project1.getToken();
                                                        }
//                                                        String buildingId = project1.getBuildingId();
//                                                        String token = project1.getToken();
//                                                        if (TextUtils.isEmpty(buildingId)){
//                                                            buildingId = project1.getBuildingId();
//                                                        }
//                                                        if (TextUtils.isEmpty(token)){
//                                                            token =  project1.getToken();
//                                                        }
                                                        String name = project1.getName();
                                                        L.e("sail  ",name);
                                                        L.e("sail  buildingId",buildingId);
                                                        L.e("sail  token",token);
                                                        if (!TextUtils.isEmpty(buildingId)&&!TextUtils.isEmpty(token)){
                                                            initSail(token,buildingId);
                                                        }
                                                    }
                                                }else {
                                                    isQuary = false;
                                                }
                                            }else {
                                                isQuary = false;
                                            }
                                        }
                                    });
                        }else {
                            L.e("sail","没有查询到mac 对应的project");
                            isQuary = false;
                        }
                    }
                });
    }

    @Override
    public void stopWork(Intent intent, int flags, int startId) {
        buildingLoaded=false;
        isQuary = false;
        stopService();
    }

    /**
     * 任务是否正在运行?
     *
     * @return 任务正在运行, true; 任务当前不在运行, false; 无法判断, 什么也不做, null.
     */
    @Override
    public Boolean isWorkRunning(Intent intent, int flags, int startId) {
        //若还没有取消订阅, 就说明任务仍在运行.
        if (isRunning) {
            return true;
        } else {
            return false;
        }
//        return null;
//        return sDisposable != null && !sDisposable.isDisposed();
    }

    @Override
    public IBinder onBind(Intent intent, Void v) {
        return null;
    }

    @Override
    public void onServiceKilled(Intent rootIntent) {
        System.out.println("保存数据到磁盘。");
        isRunning = false;
    }
}
