package com.shitu.location.uploadlocation.engine;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;


import com.shitu.location.epathmap.utils.L;
import com.shitu.location.uploadlocation.engine.model.Beacon;
import com.shitu.location.uploadlocation.engine.model.Satellite;


import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Created by Rocky on 2014/4/17.
 */

/*Replace*/ public class BLESourceController {

    private static final long MAX_HOLD_TIME = 20 * 1000;
    private final Context context;
    private static long BATCH_BEACON_SCAN_PEROID=50;

    private static final String TAG = "BLESourceController";
    private static final float PUSH_BEACOM_IIR_FACTOR = (float) 0.5;
    private static final boolean CONFINE_TO_BUILDING_BTLEAPLIST = true;

    private String[] filterModelist = {"GT-I950","HTC One","SM-G900","X920","901e","F1f"};
    private BluetoothAdapter mBluetoothAdapter=null;
    private boolean isBTLEaval = false;
    private boolean isSourceEnable = false;
    private boolean enablePushSource = false;
    private boolean isInitialStable_fp = false;
    private boolean isInitialStable_tri = false;
    private long addBtleSatelliteTimeStamp_fp;
    private long addBtleSatelliteTimeStamp_tri;

    private List<Satellite> fpScanResultList_nusync = new ArrayList<Satellite>();
    private List<Satellite> fpScanResultList = Collections.synchronizedList(fpScanResultList_nusync);
    private List<Satellite> triScanResultList_nusync =new ArrayList<Satellite>();
    private List<Satellite> triScanResultList = Collections.synchronizedList(triScanResultList_nusync);
    private List<Beacon> btlePushScanList = Collections.synchronizedList(new ArrayList<Beacon>());
    private List<List<Satellite>> triFloorlocatingList = new ArrayList<List<Satellite>>();

    private BTLESwitchScanHandler btleSwitchReceiver = new BTLESwitchScanHandler(this);
    private BTLEReceiver btleReceiver = new BTLEReceiver();
    private BTLESwitchScanHandler21 btleSwitchReceiver21 = new BTLESwitchScanHandler21(this);
    private BTLEReceiver21 btleReceiver21 = new BTLEReceiver21(this);
    private BatchScanHandler batchScanHandler = new BatchScanHandler(this);

    private FPScanResultHandler mFPScanResultHandler = new FPScanResultHandler(this);

    private BluetoothAdapter.LeScanCallback mLeScanCallback = null ;
    private ScanCallback mLeScanCallback21 = null;
    private BluetoothLeScanner mLeScanner21=null;
    private ScanSettings mLeScanSetting21=null;




    private OnSourceUpdateCallback onSourceUpdateCallback = null;

    private int currentScanningMode = ScanSettings.SCAN_MODE_LOW_POWER;

    private static  boolean autoTurnOnBT=true;

    public static void setAutoTurnOnBT(boolean isAutoTurnOnBT) {
        L.e("autoTurnOnBT1:",isAutoTurnOnBT+"");
        autoTurnOnBT = isAutoTurnOnBT;
    }


    private long getBeaconTimeStamp=System.currentTimeMillis();
    private long inFieldTimestamp = 0;
    private int restartCount=0;

    void setOnBTLESourceUpdateCallback(OnSourceUpdateCallback o) {
        onSourceUpdateCallback = o;
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    void setLeScanner(int scanningMode) {
        if(Build.VERSION.SDK_INT < 21)
            return;
        boolean sourceEnable = isSourceEnable;
        if(mLeScanner21!=null) {
            if(isSourceEnable)
                disableSource();

            mLeScanner21 = null;
            mLeScanSetting21 = null;
            mLeScanCallback21 = null;
        }
        mLeScanner21=mBluetoothAdapter.getBluetoothLeScanner();

        mLeScanSetting21 = new ScanSettings.Builder()
                .setScanMode(scanningMode)
                .build();
        currentScanningMode = scanningMode;

        mLeScanCallback21= new ScanCallback() {
            @TargetApi(Build.VERSION_CODES.LOLLIPOP)
            @Override
            public void onBatchScanResults(List<ScanResult> results) {
                super.onBatchScanResults(results);
            }

            @TargetApi(Build.VERSION_CODES.LOLLIPOP)
            @Override
            public void onScanResult(int callbackType, final ScanResult result) {
                super.onScanResult(callbackType, result);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        onLEScanProcedure(result.getDevice(), result.getRssi(), result.getScanRecord().getBytes());
                    }
                }).start();
            }

            @TargetApi(Build.VERSION_CODES.LOLLIPOP)
            @Override
            public void onScanFailed(int errorCode) {
                if(errorCode==ScanCallback.SCAN_FAILED_ALREADY_STARTED)
                    Log.e("ScanFailed", "SCAN_FAILED_ALREADY_STARTED");
                else if(errorCode==ScanCallback.SCAN_FAILED_INTERNAL_ERROR)
                    Log.e("ScanFailed","SCAN_FAILED_INTERNAL_ERROR");
                else if(errorCode==ScanCallback.SCAN_FAILED_APPLICATION_REGISTRATION_FAILED)
                    Log.e("ScanFailed","SCAN_FAILED_APPLICATION_REGISTRATION_FAILED");
                else if(errorCode==ScanCallback.SCAN_FAILED_FEATURE_UNSUPPORTED)
                    Log.e("ScanFailed","SCAN_FAILED_FEATURE_UNSUPPORTED");
            }
        };
        if(sourceEnable) {
            enableSource();
        }

    }

    interface OnSourceUpdateCallback {
        void OnUpdateBegin();
        void OnFPScanUpdated(List<Satellite> sr);
    }
    private static long currentThreadCount=0;
    private static long totalThreadCount=0;

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private class BLEScanRunnable implements  Runnable{
        private final long threadCount;
        private final ScanResult scanResult;
        private long myTimestamp=System.currentTimeMillis();

        BLEScanRunnable(ScanResult scanResult) {
            this.threadCount=totalThreadCount;
            totalThreadCount++;
            this.scanResult=new ScanResult(scanResult.getDevice(),scanResult.getScanRecord(),scanResult.getRssi(),scanResult.getTimestampNanos());
        }
        @TargetApi(Build.VERSION_CODES.LOLLIPOP)
        @Override
        public void run() {
            while(currentThreadCount!=threadCount){
                try {
                    Thread.sleep(10);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            };
            if(SystemClock.elapsedRealtimeNanos()-scanResult.getTimestampNanos()<500*1000*1000) {
                onLEScanProcedure(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
            }
            currentThreadCount++;
        }
    }
    @TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
    BLESourceController(final Context context) {
        this.context = context;

        if (context.getPackageManager() != null)
            isBTLEaval = context.getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE);

        if(!isBTLEaval)
            return;

        final BluetoothManager bluetoothManager = (BluetoothManager) context.getSystemService(Context.BLUETOOTH_SERVICE);
        mBluetoothAdapter = bluetoothManager.getAdapter();

        if ( Build.VERSION.SDK_INT < 21 && Build.VERSION.SDK_INT >= 18) {
            mLeScanCallback = new BluetoothAdapter.LeScanCallback() {
                @Override
                public void onLeScan(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            onLEScanProcedure(device, rssi, scanRecord);
                        }
                    }).start();

                }
            };
        }else if(Build.VERSION.SDK_INT >= 21){
            setLeScanner(currentScanningMode);

        }
    }

    void disableSource() {
        enabled = false;
        stoped = true;
        if (!isBTLEaval || Build.VERSION.SDK_INT < 18)
            return;

        if (isSourceEnable) {
            btleSwitchReceiver.stop();
            btleReceiver.stopScan();
            btleSwitchReceiver21.stop();
            batchScanHandler.stopBatch();
            btleReceiver21.stopScan();
            mFPScanResultHandler.stop();
            isSourceEnable = false;
        }
    }
    boolean stoped = false;
    boolean enabled = false;
    void enableSource() {

        if (!isBTLEaval || Build.VERSION.SDK_INT < 18)
            return;

        if (!isSourceEnable) {
            if (!mBluetoothAdapter.isEnabled() && autoTurnOnBT) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if(stoped) {
                            stoped=false;
                            return;
                        }
                        final BluetoothManager bluetoothManager = (BluetoothManager) context.getSystemService(Context.BLUETOOTH_SERVICE);
                        mBluetoothAdapter = bluetoothManager.getAdapter();
                        if(Build.VERSION.SDK_INT >= 21){
                            mLeScanner21=mBluetoothAdapter.getBluetoothLeScanner();
                        }
                        autoTurnOnBT=true;
                        isSourceEnable=false;
                        Log.d("sails_bt","enablesource");
                        enableSource();

                    }
                },1000);
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if(enabled)
                            return;
                        mBluetoothAdapter.enable();
                        enabled=true;

                    }
                },200);
                return;
            }

            boolean found = false;
            for (int i = 0; i < filterModelist.length; i++) {
                if (Build.MODEL.contains(filterModelist[i])) {
                    found = true;
                    break;
                }
            }

            fpScanResultList.clear();
            triScanResultList.clear();
            triFloorlocatingList.clear();
            btlePushScanList.clear();

            if (Build.VERSION.SDK_INT >= 18 && Build.VERSION.SDK_INT < 21) {
                if (found)
                    btleReceiver.startScan();
                else
                    btleSwitchReceiver.start();

            } else if (Build.VERSION.SDK_INT >= 21) {
                if(mBluetoothAdapter!=null && mBluetoothAdapter.isOffloadedFilteringSupported()) {
                    //using batch scan result

                }
//                if (found)
                Log.d("sails_bt","btleReceiver21");
                btleReceiver21.startScan();



//                batchScanHandler.startBatch();

//                else
//                    btleSwitchReceiver21.start();
            }
            mFPScanResultHandler.start(100);

            isSourceEnable = true;
            isInitialStable_fp = false;
            isInitialStable_tri = false;
            addBtleSatelliteTimeStamp_fp = System.currentTimeMillis();
            addBtleSatelliteTimeStamp_tri = System.currentTimeMillis();
        }
    }
    void switchFloorClearProcedure() {
        isInitialStable_fp = false;
        isInitialStable_tri = false;
        addBtleSatelliteTimeStamp_fp = System.currentTimeMillis()+2000;
        addBtleSatelliteTimeStamp_tri = System.currentTimeMillis()+2000;

    }
    @TargetApi(18)
    class BTLESwitchScanHandler extends Handler {

        WeakReference<BLESourceController> pointer;

        boolean enable = false;
        boolean inScan = false;
        int SCAN_PERIOD = 638;
        int SLEEP_PERIOD = 100;

        void start() {
            enable = true;
            sleep(100);
        }

        void stop() {
            enable = false;
            if (mBluetoothAdapter != null && mLeScanCallback != null)
                mBluetoothAdapter.stopLeScan(mLeScanCallback);
        }

        BTLESwitchScanHandler(BLESourceController input) {
            pointer = new WeakReference<BLESourceController>(input);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!enable)
                return;

            final BLESourceController ap = pointer.get();
            if (ap != null) {
                if (!inScan) {
//                    mLeScanCallback =new BluetoothAdapter.LeScanCallback() {
//                        @Override
//                        public void onLeScan(final BluetoothDevice device, int rssi, byte[] scanRecord) {
//                            onLEScanProcedure(device, rssi, scanRecord);
//                        }
//                    };
                    if (ap.mBluetoothAdapter != null && mLeScanCallback != null&&mBluetoothAdapter.isEnabled())
                        ap.mBluetoothAdapter.startLeScan(mLeScanCallback);
                    inScan = true;
                    sleep(SCAN_PERIOD);
                } else {
                    if (ap.mBluetoothAdapter != null && mLeScanCallback != null&&mBluetoothAdapter.isEnabled())
                        ap.mBluetoothAdapter.stopLeScan(mLeScanCallback);
                    inScan = false;
                    sleep(SLEEP_PERIOD);
                }
            }
        }

        public void sleep(long delayMillis) {
            this.removeMessages(0);
            sendMessageDelayed(obtainMessage(0), delayMillis);
        }
    }


    @TargetApi(21)
    class BTLESwitchScanHandler21 extends Handler {

        WeakReference<BLESourceController> pointer;

        boolean enable = false;
        boolean inScan = false;
        int SCAN_PERIOD = 5000;
        int SLEEP_PERIOD = 600;

        void start() {
            enable = true;
            sleep(100);
        }

        void stop() {
            enable = false;
            if (mLeScanner21 != null && mLeScanCallback21 != null&&mBluetoothAdapter.isEnabled())
                mLeScanner21.stopScan(mLeScanCallback21);
        }

        BTLESwitchScanHandler21(BLESourceController input) {
            pointer = new WeakReference<BLESourceController>(input);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!enable)
                return;

            final BLESourceController ap = pointer.get();
            if (ap != null) {
                if (!inScan) {
                    if (ap.mLeScanner21 != null && mLeScanCallback21 != null&&ap.mBluetoothAdapter.isEnabled())
                        ap.mLeScanner21.startScan(null,mLeScanSetting21,mLeScanCallback21);
                    inScan = true;
                    sleep(SCAN_PERIOD);
                } else {
                    if (ap.mLeScanner21 != null && mLeScanCallback21 != null&&ap.mBluetoothAdapter.isEnabled())
                        ap.mLeScanner21.stopScan(mLeScanCallback21);
                    inScan = false;
                    sleep(SLEEP_PERIOD);
                }
            }
        }

        public void sleep(long delayMillis) {
            this.removeMessages(0);
            sendMessageDelayed(obtainMessage(0), delayMillis);
        }
    }



    @SuppressWarnings("deprecation")
    @TargetApi(18)
    class BTLEReceiver {
        void startScan() {
            if (mBluetoothAdapter != null && mLeScanCallback != null && mBluetoothAdapter.isEnabled())
                mBluetoothAdapter.startLeScan(mLeScanCallback);
        }

        void stopScan() {
            if (mBluetoothAdapter != null && mLeScanCallback != null && mBluetoothAdapter.isEnabled())
                mBluetoothAdapter.stopLeScan(mLeScanCallback);
        }
    }

    @TargetApi(21)
    class BTLEReceiver21 extends Handler {
        boolean inLoop=false;

        void startScan() {
            if (mLeScanner21 != null && mLeScanCallback21 != null && mBluetoothAdapter.isEnabled())
                mLeScanner21.startScan(null,mLeScanSetting21 , mLeScanCallback21);
            inLoop=true;
        }

        void stopScan() {
            if (mLeScanner21 != null && mLeScanCallback21 != null && mBluetoothAdapter.isEnabled())
                mLeScanner21.stopScan(mLeScanCallback21);
            inLoop=false;
        }
        WeakReference<BLESourceController> pointer;

        BTLEReceiver21(BLESourceController input) {
            pointer = new WeakReference<>(input);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!inLoop)
                return;

            final BLESourceController ap = pointer.get();
            if (ap != null&&ap.mLeScanner21!=null&&mLeScanCallback21!=null) {
                ap.mLeScanner21.flushPendingScanResults(mLeScanCallback21);
            }
            sleep(BATCH_BEACON_SCAN_PEROID);
        }

        public void sleep(long delayMillis) {
            this.removeMessages(0);
            sendMessageDelayed(obtainMessage(0), delayMillis);
        }
    }
    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    class BatchScanHandler extends Handler {
        private final WeakReference<BLESourceController> pointer;
        boolean inLoop=false;
        boolean useBatch=false;

        final Map<String,ScanResult> scanResults=new HashMap<>();
        public boolean isUseBatch(){
            return useBatch;
        }
        public void startBatch(){
            useBatch=true;
            inLoop=true;
            sleep(100);
        }
        public void stopBatch(){
            useBatch=false;
            inLoop=false;
        }
        public void save(ScanResult scanResult) {
            synchronized (scanResults) {
                scanResults.put(scanResult.getDevice().getAddress(),scanResult);
//                scanResults.add(scanResult);
            }

        }

        BatchScanHandler(BLESourceController input) {
            pointer = new WeakReference<>(input);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!inLoop)
                return;

            final BLESourceController ap = pointer.get();
            if (ap != null) {
                final List<ScanResult> cloneResults;
                synchronized (scanResults) {
                    cloneResults=new ArrayList<>(scanResults.values());
                    scanResults.clear();
                    ap.mLeScanner21.flushPendingScanResults(mLeScanCallback21);
                }
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        for(ScanResult result:cloneResults) {
                            if(SystemClock.elapsedRealtimeNanos()-result.getTimestampNanos()>500*1000*1000)
                                continue;
                            ap.onLEScanProcedure(result.getDevice(), result.getRssi(), result.getScanRecord().getBytes());
                        }

                    }
                }).start();
//                int i=0;
//                ap.mLeScanner21.flushPendingScanResults(mLeScanCallback21);

            }
            sleep(BATCH_BEACON_SCAN_PEROID);
        }

        public void sleep(long delayMillis) {
            this.removeMessages(0);
            sendMessageDelayed(obtainMessage(0), delayMillis);
        }
    }

    private void onLEScanProcedure(final BluetoothDevice device, final int rssi, final byte[] scanRecord) {
        Beacon b = new Beacon();
        b.updateTimeStamp = System.currentTimeMillis();
        b.id_btle = Beacon.BSSIDStringToLongInt(device.getAddress());
        b.btlePower = rssi;
        if (device!= null){
            b.btleName = device.getName();
            b.mac_btle = device.getAddress();
        }else {
            return;
        }
        String rec_prefix= HexBin.encode(Arrays.copyOfRange(scanRecord, 4, 9));
        if (rec_prefix.equals("FF4C000215")) {
            String iBeacon_prefix = HexBin.encode(Arrays.copyOfRange(scanRecord, 0, 9));
            String iBeacon_uuid = HexBin.encode(Arrays.copyOfRange(scanRecord, 9, 25));
            String iBeacon_major = HexBin.encode(Arrays.copyOfRange(scanRecord, 25, 27));
            String iBeacon_minor = HexBin.encode(Arrays.copyOfRange(scanRecord, 27, 29));
            int iBeacon_txPower = 0;
            try {
                iBeacon_txPower = Integer.parseInt(HexBin.encode(Arrays.copyOfRange(scanRecord, 29, 30)), 16) - 256;
            } catch (NumberFormatException e) {
                Log.e("SAILS", e.toString());
            }
                b.iBeacon = new Beacon.ASEiBeacon(
                        new Beacon.IBeacon(iBeacon_prefix, iBeacon_uuid, iBeacon_major, iBeacon_minor, iBeacon_txPower),
                        (byte)(iBeacon_txPower&0x7));
        }
        if(b.mac_btle.substring(0,10).equalsIgnoreCase("B4:AB:2C:F")) {
            b.iBeacon= new Beacon.ASEiBeacon(new Beacon.IBeacon("1234FF4C000215", "00000000", "000", "000", 10));
            ((Beacon.ASEiBeacon)b.iBeacon).battery=100;
        }
        if(b.mac_btle.substring(0,5).equalsIgnoreCase("B4:AB")){
            inFieldTimestamp = System.currentTimeMillis();
            restartCount=0;
            checkInFPScanResult(b);
        }
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    private void checkScanningModeProcedure() {
        if(currentScanningMode == ScanSettings.SCAN_MODE_LOW_LATENCY) {
            if(System.currentTimeMillis() - inFieldTimestamp > MAX_HOLD_TIME) {
                setLeScanner(ScanSettings.SCAN_MODE_LOW_POWER);
                Log.d("sails_scan","LOW_POWER");
            }
        } else {
            if(System.currentTimeMillis() - inFieldTimestamp < 10 * 1000) {
                setLeScanner(ScanSettings.SCAN_MODE_LOW_LATENCY);
                Log.d("sails_scan","LOW_LATENCY");
            }
        }
    }

    private boolean checkInitial() {
       final int FIRST_WAITING_TIME = 2500;
        if (!isInitialStable_fp) {
            if (System.currentTimeMillis() - addBtleSatelliteTimeStamp_fp > FIRST_WAITING_TIME){// || fpScanResultList.size() > 30) {
                isInitialStable_fp = true;
                if (onSourceUpdateCallback != null)
                    onSourceUpdateCallback.OnUpdateBegin();
                return true;
            }
            return false;
        }
        return true;
    }
    private void checkInFPScanResult(Beacon singleScanResult) {

        checkInitial();
        Satellite node = new Satellite(singleScanResult);
        synchronized (fpScanResultList) {
            int index = Collections.binarySearch(fpScanResultList, node, new Satellite.ComparatorSatelliteBTLEById());
            if (index >= 0) {
                double level = singleScanResult.btlePower;
                fpScanResultList.get(index).checkInRSSI(level);
                getBeaconTimeStamp=System.currentTimeMillis();
            } else {
                double level = singleScanResult.btlePower;
                Satellite node2 = new Satellite(singleScanResult);
                node2.checkInRSSI(level);
                synchronized (fpScanResultList) {
                    fpScanResultList.add(-index - 1, node2);
                }
            }

        }
    }


    static class FPScanResultHandler extends Handler {
        private WeakReference<BLESourceController> mA = null;
        //        int period = 20;
        int period = 100;
        private boolean inLoop = false;
        static int REMOVE_TIME_DURATION = 5000;
        //        static int REMOVE_TIME_DURATION = 15000;
//        static int PICK_SCANRESULT_DURATION = 100;
        static int PICK_SCANRESULT_DURATION = 1000;
        long fpScanUpdateTimeStamp = 0;

        FPScanResultHandler(BLESourceController mA) {
            this.mA = new WeakReference<BLESourceController>(mA);
        }

        public void start(int sleep) {
            inLoop = true;
//            if(mA.get()!=null)
//                if(mA.get().msails.checkMode(SAILS.BACKGROUND)) {
//                    period=1000;
//                }
            sleep(sleep);
        }

        public void stop() {
            inLoop = false;
        }

        @Override
        public void handleMessage(Message msg) {
            if (!inLoop)
                return;

            final BLESourceController sf = mA.get();
            if(sf != null) {
                sf.checkScanningModeProcedure();
            }
            if (sf != null && sf.currentScanningMode == ScanSettings.SCAN_MODE_LOW_LATENCY) {
                //if last receive beacon time is more than 3 second, restart ble
                if(System.currentTimeMillis()-sf.getBeaconTimeStamp>3000) {
                    if(sf.restartCount<3) {
                        sf.restartCount++;
                        Log.d("SAILS","restart BLE scan procedure since there is no beacon scanned!");
                        sf.getBeaconTimeStamp=System.currentTimeMillis();
                        sf.restartBLEScanProcedure();
                    }
                }
                List<Satellite> satelliteList = Collections.synchronizedList(new ArrayList<Satellite>());

                synchronized (sf.fpScanResultList) {
                    for (Satellite sL : sf.fpScanResultList) {
                        sL.refreshRSSI();
                        if (System.currentTimeMillis() - sL.getLastTimeStamp() > REMOVE_TIME_DURATION) {
                            sL.clearRSSI();
                        } else {
                            satelliteList.add(sL);
                        }
                    }

                    sf.fpScanResultList = satelliteList;
                }

                if (sf.onSourceUpdateCallback != null ) {
                    if (sf.checkInitial()) {
                        if (System.currentTimeMillis() - fpScanUpdateTimeStamp > PICK_SCANRESULT_DURATION) {
                            fpScanUpdateTimeStamp = System.currentTimeMillis();
                            List<Satellite> cloneResult = Collections.synchronizedList(new ArrayList<Satellite>());
                            synchronized (sf.fpScanResultList) {
                                for (Satellite sat : sf.fpScanResultList) {
                                    cloneResult.add(sat.clone());
                                }
                            }
                            synchronized (cloneResult) {
                                Collections.sort(cloneResult, new Comparator<Satellite>() {
                                    @Override
                                    public int compare(Satellite t1, Satellite t2) {
                                        if(t1.getRSSI()==t2.getRSSI())
                                            return 0;
                                        return t1.getRSSI()>t2.getRSSI() ? -1:1;
                                    }
                                });

                                sf.onSourceUpdateCallback.OnFPScanUpdated(cloneResult);
                            }

                        }
                    }
                }
            }
            sleep(period);
            return;
        }

        public void sleep(long delayMillis) {
            this.removeMessages(0);
            sendMessageDelayed(obtainMessage(0), delayMillis);
        }
    }


    private void restartBLEScanProcedure() {
        if (Build.VERSION.SDK_INT >= 21) {
            if(isSourceEnable)
                btleReceiver21.stopScan();
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    if(isSourceEnable)
                        btleReceiver21.startScan();
                }
            },300);
        }
    }


    static final class HexBin {
        static private final int BASELENGTH = 128;
        static private final int LOOKUPLENGTH = 16;
        static final private byte[] hexNumberTable = new byte[BASELENGTH];
        static final private char[] lookUpHexAlphabet = new char[LOOKUPLENGTH];

        static {
            for (int i = 0; i < BASELENGTH; i++) {
                hexNumberTable[i] = -1;
            }
            for (int i = '9'; i >= '0'; i--) {
                hexNumberTable[i] = (byte) (i - '0');
            }
            for (int i = 'F'; i >= 'A'; i--) {
                hexNumberTable[i] = (byte) (i - 'A' + 10);
            }
            for (int i = 'f'; i >= 'a'; i--) {
                hexNumberTable[i] = (byte) (i - 'a' + 10);
            }
            for (int i = 0; i < 10; i++) {
                lookUpHexAlphabet[i] = (char) ('0' + i);
            }
            for (int i = 10; i <= 15; i++) {
                lookUpHexAlphabet[i] = (char) ('A' + i - 10);
            }
        }

        /**
         * Encode a byte array to hex string
         *
         * @param binaryData array of byte to encode
         * @return return encoded string
         */
        static public String encode(byte[] binaryData) {
            if (binaryData == null)
                return null;
            int lengthData = binaryData.length;
            int lengthEncode = lengthData * 2;
            char[] encodedData = new char[lengthEncode];
            int temp;
            for (int i = 0; i < lengthData; i++) {
                temp = binaryData[i];
                if (temp < 0)
                    temp += 256;
                encodedData[i * 2] = lookUpHexAlphabet[temp >> 4];
                encodedData[i * 2 + 1] = lookUpHexAlphabet[temp & 0xf];
            }
            return new String(encodedData);
        }

        /**
         * Decode hex string to a byte array
         *
         * @param encoded encoded string
         * @return return array of byte to encode
         */
        static public byte[] decode(String encoded) {
            if (encoded == null)
                return null;
            int lengthData = encoded.length();
            if (lengthData % 2 != 0)
                return null;

            char[] binaryData = encoded.toCharArray();
            int lengthDecode = lengthData / 2;
            byte[] decodedData = new byte[lengthDecode];
            byte temp1, temp2;
            char tempChar;
            for (int i = 0; i < lengthDecode; i++) {
                tempChar = binaryData[i * 2];
                temp1 = (tempChar < BASELENGTH) ? hexNumberTable[tempChar] : -1;
                if (temp1 == -1)
                    return null;
                tempChar = binaryData[i * 2 + 1];
                temp2 = (tempChar < BASELENGTH) ? hexNumberTable[tempChar] : -1;
                if (temp2 == -1)
                    return null;
                decodedData[i] = (byte) ((temp1 << 4) | temp2);
            }
            return decodedData;
        }
    }
}
