package com.shitu.location.epathmap.model.parse;

import com.shitu.location.epathmap.utils.ParseClass;
import com.parse.ParseClassName;
import com.parse.ParseObject;

import java.util.List;

/**
 * author:lfei
 */

@ParseClassName(ParseClass.FeedBack)
public class FeedBack extends ParseObject {
    public static final String SCORE = "score";
    public static final String COMMENTS = "comments";
    public static final String CONTENT = "content";
    public static final String START_NAME = "startName";
    public static final String TARGET_NAME = "targetName";
    public static final String IS_SIMULATION = "isSimulation";
    public static final String PROJECT = "project";

    public String getScore(){
        return getString(SCORE);
    }

    public List<String> getComments(){
        return getList(COMMENTS);
    }

    public String getContent(){
        return getString(CONTENT);
    }

    public String getStartName(){
        return getString(START_NAME);
    }

    public String getTargetName(){
        return getString(TARGET_NAME);
    }

    public boolean isSimulation(){
        return getBoolean(IS_SIMULATION);
    }

    public ParseObject getProject(){
        return getParseObject(PROJECT);
    }
}
