package com.shitu.location.epathmap.model.parse;

import com.shitu.location.epathmap.utils.ParseClass;
import com.parse.ParseClassName;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;

import java.util.Date;
import java.util.List;

/**
 * author:lfei
 */

@ParseClassName(ParseClass.Background)
public class Background extends ParseObject {
    public static final String locationRegions = "locationRegions";
    public static final String locationRegion = "locationRegion";
    public static final String deviceId = "deviceId";
    public static final String userDescription = "userDescription";
    public static final String phoneNumber = "phoneNumber";
    public static final String floorNumber = "floorNumber";
    public static final String enterAt = "enterAt";
    public static final String leaveAt = "leaveAt";
    public static final String floorName = "floorName";
    public static final String project = "project";
    public static final String lonLat = "lonLat";
    public static final String durationTime = "durationTime";

    public List<String> getLocationRegions() {
        return getList(locationRegions);
    }
    public String getLocationRegion() {
        return getString(locationRegion);
    }

    public String getDeviceId() {
        return getString(deviceId);
    }

    public String getUserDescription() {
        return getString(userDescription);
    }
    public String getPhoneNumber() {
        return getString(phoneNumber);
    }

    public int getFloorNumber() {
        return getInt(floorNumber);
    }

    public Date getEnterAt() {
        return getDate(enterAt);
    }

    public Date getLeaveAt() {
        return getDate(leaveAt);
    }


    public String getFloorName() {
        return getString(floorName);
    }


    public  ParseObject getProject() {
        return getParseObject(project);
    }

    public ParseGeoPoint getLonLat() {
        return getParseGeoPoint(lonLat);
    }

    public int getDurationTime() {
        return getInt(durationTime);
    }

}
