/*
 * Decompiled with CFR 0.152.
 */
package com.shitu.location.epathmap;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.sails.engine.LocationRegion;
import com.sails.engine.SAILS;
import com.sails.engine.SAILSMapView;
import com.sails.engine.core.model.GeoPoint;
import com.shitu.location.R;
import com.shitu.location.epathmap.EpathLocation;
import com.shitu.location.epathmap.EpathLocationListener;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.model.parse.App;
import com.shitu.location.epathmap.model.parse.POI;
import com.shitu.location.epathmap.model.parse.Project;
import com.shitu.location.epathmap.model.parse.Punch;
import com.shitu.location.epathmap.utils.Constants;
import com.shitu.location.epathmap.utils.EpUtils;
import com.shitu.location.epathmap.utils.L;
import com.shitu.location.epathmap.utils.T;
import com.shitu.location.uploadlocation.UserAllBackgroundDataListener;
import java.util.ArrayList;
import java.util.List;

public class EpathClient {
    private static final int MSG_START_ENGINE = 0;
    private static final int MSG_LOCATION_WAIT = 1;
    private static final int MSG_SEND_LOCATION = 2;
    private static final int TIME_OUT = 10000;
    private SAILS sails;
    private SAILSMapView sailsMapView;
    private Project project;
    private String mapId;
    private boolean isFirstQueryMap = true;
    private boolean isFirstLocationFix = true;
    private EpathLocationListener epathLocationListener;
    private a handler;
    private String userId;
    private App app;
    private Context context;
    public static UserAllBackgroundDataListener userAllBackgroundDataListener;

    public EpathClient(Context context, String string2) {
        this.mapId = string2;
        this.context = context;
        this.handler = new a();
        this.sails = new SAILS(context);
        this.sails.setServerURL("https://cloud.e-path.cn");
        this.sailsMapView = new SAILSMapView(context);
        this.sailsMapView.setSAILSEngine(this.sails);
    }

    public EpathClient(Context context, String string2, String string3) {
        this.userId = string3;
        this.mapId = string2;
        this.handler = new a();
        this.sails = new SAILS(context);
        this.sails.setServerURL("https://cloud.e-path.cn");
        this.sailsMapView = new SAILSMapView(context);
        this.sailsMapView.setSAILSEngine(this.sails);
    }

    public void registerLocationListener(EpathLocationListener epathLocationListener) {
        this.epathLocationListener = epathLocationListener;
    }

    public void registerUserAllLocationDataListener(UserAllBackgroundDataListener userAllBackgroundDataListener) {
        EpathClient.userAllBackgroundDataListener = userAllBackgroundDataListener;
    }

    public void getUserAllLocationData(String string2, int n2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = "05rQwjfdSO";
        }
        com.shitu.location.uploadlocation.a a2 = new com.shitu.location.uploadlocation.a();
        a2.a(n2);
        a2.a(string3, EpUtils.getDeviceID());
    }

    public void start() {
        if (this.handler.hasMessages(1) || this.handler.hasMessages(2)) {
            return;
        }
        if (this.sails != null && this.project != null && this.sails.isLocationFix() && this.epathLocationListener != null) {
            this.handler.sendEmptyMessageDelayed(2, 500L);
        } else if (this.sails != null && this.project != null && !this.sails.isLocationFix() && this.epathLocationListener != null) {
            this.handler.sendEmptyMessageDelayed(1, 10000L);
        } else {
            this.loadCloudBuilding();
        }
    }

    public void stop() {
        this.stopLocation();
        this.handler.removeMessages(0);
        this.handler.removeMessages(1);
    }

    private void loadCloudBuilding() {
        this.isFirstQueryMap = true;
        if (EpathLocationSDK.app == null) {
            T.showShort(R.string.ep_location_init_epath_fail);
            return;
        }
        this.app = EpathLocationSDK.app;
        ParseQuery parseQuery = EpathLocationSDK.app.getProjects().getQuery();
        parseQuery.whereEqualTo("visible", (Object)true);
        parseQuery.setCachePolicy(ParseQuery.CachePolicy.CACHE_THEN_NETWORK);
        parseQuery.findInBackground((list, parseException) -> {
            if (parseException != null) {
                parseException.printStackTrace();
                if (parseException.getCode() != 120 && this.isFirstQueryMap) {
                    T.showShort(R.string.ep_location_no_permission_read_this_map);
                }
                return;
            }
            if (!this.isFirstQueryMap) {
                return;
            }
            this.isFirstQueryMap = false;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Project project = (Project)((Object)((Object)list.get(i2)));
                if (!project.getObjectId().equals(this.mapId)) continue;
                this.project = project;
                break;
            }
            if (this.project == null) {
                T.showShort(R.string.ep_location_no_permission_read_this_map);
                return;
            }
            if (this.project.getBuildingId().isEmpty() || this.project.getToken().isEmpty()) {
                T.showShort(R.string.ep_lcoation_info_lack);
                return;
            }
            this.sails.setOnLocationChangeEventListener(() -> {
                if (this.sails.isLocationFix() && this.handler.hasMessages(1) && this.epathLocationListener != null) {
                    this.handler.sendEmptyMessageDelayed(2, 500L);
                    this.handler.removeMessages(1);
                    this.isFirstLocationFix = false;
                }
                if (this.sails.isLocationFix() && this.isFirstLocationFix) {
                    this.isFirstLocationFix = false;
                    this.sailsMapView.loadFloorMap(this.project.getGpsFloorlayer() + "");
                    if (this.epathLocationListener != null) {
                        this.handler.sendEmptyMessageDelayed(2, 500L);
                    }
                }
            });
            this.sails.loadCloudBuilding(this.project.getToken(), this.project.getBuildingId(), new SAILS.OnFinishCallback(){

                @Override
                public void onSuccess(String string2) {
                    EpathClient.this.handler.sendEmptyMessage(0);
                }

                @Override
                public void onFailed(String string2) {
                }
            });
        });
    }

    private void startLocation() {
        if (this.sails != null) {
            this.sails.setGPSFloorLayer(this.project.getGpsFloorlayer() + "");
            this.sails.setGPSThresholdParameter(this.project.getInToOut(), this.project.getOutToIn(), this.project.getPowerThreshold());
            this.sails.setEnvironmentIsHighBeaconDensity(true);
            this.sails.setMode(2080);
            this.sails.startLocatingEngine();
            this.handler.sendEmptyMessageDelayed(1, 10000L);
        }
    }

    public void startCheckLocationRange(String string2, String string3) {
        this.startCheckLocationRange(string2, string3, 12);
    }

    public void startCheckLocationRange(String string2, String string3, int n2) {
        ParseObject parseObject = ParseObject.createWithoutData((String)"MappingProject", (String)string2);
        ParseQuery.getQuery(POI.class).whereEqualTo("project", (Object)parseObject).whereEqualTo("link", (Object)string3).orderByAscending("floor").getFirstInBackground((pOI, parseException) -> {
            double d2;
            boolean bl = false;
            if (pOI == null) {
                this.epathLocationListener.onReceiveRange(bl);
                return;
            }
            double d3 = pOI.getLatitude();
            double d4 = pOI.getLongitude();
            String string2 = pOI.getFloorName();
            String string3 = this.sails.getFloor();
            if (string2 != null && string3 != null && string2.equals(string3) && (int)(d2 = this.sails.getMapDistanceByLngLat(d3, d4, this.sails.getLatitude(), this.sails.getLongitude())) < n2) {
                bl = true;
            }
            this.epathLocationListener.onReceiveRange(bl);
        });
    }

    private void stopLocation() {
        if (this.sails != null && this.sails.isLocationEngineStarted()) {
            this.sails.stopLocatingEngine();
        }
    }

    private String getNearestLocationRegion() {
        String string2;
        List<LocationRegion> list = this.sails.getCurrentInRegions();
        if (list != null && list.size() > 0) {
            LocationRegion locationRegion = list.get(0);
            String string3 = locationRegion.type;
            string2 = string3 != null && (string3.equals("freedom") || string3.equals("boundary") || string3.equals("lock")) ? this.getNearestLocationRegionFromAll() : list.get((int)0).label;
        } else {
            string2 = this.getNearestLocationRegionFromAll();
        }
        return string2;
    }

    private String getNearestLocationRegionFromAll() {
        List<LocationRegion> list;
        String string2 = "";
        ArrayList<LocationRegion> arrayList = this.getAllRegionList();
        if (this.sails.isInThisBuilding() && arrayList != null && (list = this.sails.sortLocationRegionsByPathLength(arrayList)) != null && list.size() > 0) {
            string2 = list.get((int)0).label;
        }
        return string2;
    }

    private ArrayList<LocationRegion> getAllRegionList() {
        ArrayList<LocationRegion> arrayList = new ArrayList<LocationRegion>();
        List<String> list = this.sails.getFloorNameList();
        if (list != null) {
            for (String string2 : list) {
                List<LocationRegion> list2 = this.sails.getLocationRegionList(string2);
                if (list2 == null) continue;
                for (LocationRegion locationRegion : list2) {
                    String string3;
                    if (locationRegion.type != null && ((string3 = locationRegion.type).equals("freedom") || string3.equals("boundary") || string3.equals("lock"))) continue;
                    arrayList.add(locationRegion);
                }
            }
        }
        return arrayList;
    }

    private void uploadPunch(String string2, boolean bl) {
        if (bl && this.project != null && this.app != null) {
            Punch punch = new Punch();
            punch.put("floor", this.sails.getFloor());
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                punch.put("locationRegion", string2);
            }
            punch.put("lonlat", new ParseGeoPoint(this.sails.getLatitude(), this.sails.getLongitude()));
            if (this.userId != null) {
                punch.put("userId", this.userId);
            }
            punch.put("project", (Object)this.project);
            punch.put("app", (Object)this.app);
            punch.put("appName", Constants.getAppName(EpathLocationSDK.context));
            punch.saveInBackground(parseException -> {
                if (parseException != null) {
                    L.e("\u4e0a\u4f20\u6253\u5361\u6570\u636e\u5931\u8d25", parseException.getCause() + "  " + parseException.getMessage());
                } else {
                    L.e("\u4e0a\u4f20\u6253\u5361\u6570\u636e\u6210\u529f", "\u4e0a\u4f20\u6253\u5361\u6570\u636e\u6210\u529f");
                }
            });
        }
    }

    private void sendLocation() {
        EpathLocation epathLocation = new EpathLocation();
        epathLocation.setFloor(this.sails.getFloor());
        epathLocation.setFloorDescription(this.sails.getFloorDescription(this.sails.getFloor()));
        boolean bl = this.sailsMapView.isInMap(new GeoPoint(this.sails.getLatitude(), this.sails.getLongitude()));
        epathLocation.setInThisMap(bl);
        String string2 = this.getNearestLocationRegion();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            epathLocation.setNearLocationRegion(string2);
        }
        this.epathLocationListener.onReceiveLocation(epathLocation);
        this.uploadPunch(string2, bl);
    }

    private class a
    extends Handler {
        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 0: {
                    EpathClient.this.startLocation();
                    break;
                }
                case 1: {
                    if (EpathClient.this.epathLocationListener == null || EpathClient.this.sails.isLocationFix()) break;
                    EpathClient.this.epathLocationListener.onReceiveLocation(null);
                    break;
                }
                case 2: {
                    EpathClient.this.sendLocation();
                }
            }
        }
    }
}

