package com.shitu.location.epathmap.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * author:lfei
 */
public class DateUtils {

    public static int daysBetween(Date d1, Date d2) {
        return (int) ((d1.getTime() - d2.getTime()) / 86400000);
    }

    public static int minutesBetween(Date d1, Date d2) {
        return (int) ((d1.getTime() - d2.getTime()) / (60 * 1000));
    }

    public static Date dateDiff(Date d1, int day) {
        return new Date(d1.getTime() + 24 * 60 * 60 * 1000 * day);
    }

    public static Date dateDiff2(Date d1, int minute) {
        return new Date(d1.getTime() + 60 * 1000 * minute);
    }

    public static String getTimeBeforeNow(long timeL) {

        long timeDiff = new Date().getTime() - timeL;
        if(timeDiff < 0){
            return "刚刚";
        }
        long time = timeDiff / 1000;
        StringBuffer sb = new StringBuffer();
        long day = time / (24 * 60 * 60);
        time = time - day * (24 * 60 * 60);
        long hour = time / (60 * 60);
        time = time - hour * (60 * 60);
        long minute = time / 60;
        time = time - minute * 60;
        long second = time;

        if (hour >= 1) {
            sb.append(hour + "小时前");
        } else if (minute >= 1 && minute < 60) {
            sb.append(minute + "分钟前");
        } else if (second >= 0 && second < 60) {
            sb.append("刚刚");
        }
        return sb.toString();
    }

    public static String getSimpleDate(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static String getSimpleDate2(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

}
