package com.shitu.location.epathmap.model.parse;

import com.shitu.location.epathmap.utils.ParseClass;
import com.parse.ParseClassName;
import com.parse.ParseGeoPoint;
import com.parse.ParseObject;
import com.parse.ParseRelation;

import org.json.JSONArray;

/**
 * author:lfei
 */

@ParseClassName(ParseClass.Project)
public class Project extends ParseObject {

    public String getBuildingId() {
        return getString("epath_cloud_building_id");
    }

    public String getToken() {
        return getString("epath_cloud_token");
    }

    public String getBuildingIdBg() {
        return getString("bg_cloud_buildingid");
    }

    public String getTokenBg() {
        return getString("bg_cloud_token");
    }

    public String getName() {
        return getString("name");
    }

    public String getPicture() {
        return getString("picture");
    }

    public double getAngle() {
        return getDouble("angle");
    }

    public int getPowerThreshold() {
        return getInt("powerThreshold");
    }

    public int getInToOut() {
        return getInt("inToOut");
    }

    public int getOutToIn() {
        return getInt("outToIn");
    }

    public double getZoom() {
        return getDouble("zoom");
    }

    public int getFloorNumber() {
        return getInt("floorNumber");
    }

    public String getFloorName() {
        return getString("floorName");
    }


    public int getOrder() {
        return getInt("order");
    }

    public int getGpsFloorlayer() {
        return getInt("gpsFloorlayer");
    }

    public boolean isVisible() {
        return getBoolean("visible");
    }

    public double getNavigationZoom() {
        return getDouble("navigationZoom");
    }

    public ParseRelation<POIGenre> getGenres() {
        return getRelation("genre");
    }

    public boolean isDebug() {
        return getBoolean("isDebug");
    }

    public JSONArray getEscalatorFirst() {
        return getJSONArray("escalatorFirst");
    }

    public boolean isWiFi() {
        return getBoolean("wifi");
    }

    public ParseGeoPoint getCenterPoint() {
        return getParseGeoPoint("centerPoint");
    }

    public ParseObject getDistrict() {
        return getParseObject("district");
    }

    public String getTitle() {
        return getString("title");
    }
}
