/*
 * Decompiled with CFR 0.152.
 */
package com.sails.engine.overlay;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.sails.engine.core.model.BoundingBox;
import com.sails.engine.core.model.GeoPoint;
import com.sails.engine.core.model.Point;
import com.sails.engine.core.util.MercatorProjection;
import com.sails.engine.overlay.OverlayItem;
import com.sails.engine.overlay.ScreenDensity;
import java.util.List;

public class TextOverlay
implements OverlayItem {
    private boolean a = false;
    private boolean b = true;
    private GeoPoint c;
    private Paint d;
    private Paint e;
    private float f;
    private String g;
    private Rect h = new Rect();
    private Rect i = new Rect();
    private String[] j;
    private double k = 5.0;
    public List<TextOverlay> textOverlayList = null;

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("radius must not be negative: " + f2);
        }
    }

    private static double a(double d2, float f2, float f3) {
        double d3 = MercatorProjection.calculateGroundResolution(d2, f3);
        return (double)f2 / d3;
    }

    public TextOverlay(GeoPoint geoPoint, String string, Paint paint, Paint paint2) {
        this.c = geoPoint;
        this.g = string;
        this.d = paint;
        this.e = paint2;
    }

    private static boolean a(Canvas canvas, float f2, float f3, float f4, float f5) {
        return f4 >= 0.0f && f2 <= (float)canvas.getWidth() && f5 >= 0.0f && f3 <= (float)canvas.getHeight();
    }

    @Override
    public synchronized boolean draw(BoundingBox boundingBox, float f2, Canvas canvas, Point point, int n2, int n3, float f3) {
        if (this.c == null || this.e == null && this.d == null) {
            return false;
        }
        double d2 = this.c.latitude;
        double d3 = this.c.longitude;
        float f4 = (float)(MercatorProjection.longitudeToPixelX(d3, f2) - point.x);
        float f5 = (float)(MercatorProjection.latitudeToPixelY(d2, f2) - point.y);
        double d4 = (f4 - (float)n2) * ScreenDensity.density;
        double d5 = (f5 - (float)n3) * ScreenDensity.density;
        double d6 = d4 * Math.cos((double)(-f3) / 180.0 * Math.PI) + d5 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d7 = d5 * Math.cos((double)(-f3) / 180.0 * Math.PI) - d4 * Math.sin((double)(-f3) / 180.0 * Math.PI);
        double d8 = (double)n2 + d6;
        double d9 = (double)n3 + d7;
        f4 = (int)d8;
        f5 = (int)d9;
        if (this.b) {
            int n4;
            this.j = this.g.split(" - ");
            Object object = "";
            for (n4 = 0; n4 < this.j.length; ++n4) {
                if (this.j[n4].length() <= ((String)object).length()) continue;
                object = this.j[n4];
            }
            if (this.e != null) {
                this.e.getTextBounds((String)object, 0, ((String)object).length(), this.i);
            } else if (this.d != null) {
                this.d.getTextBounds((String)object, 0, ((String)object).length(), this.i);
            }
            n4 = this.i.height();
            this.i.bottom = (int)((double)this.i.bottom + ((double)n4 + this.k / 2.0) * (double)this.j.length / 2.0);
            this.i.top = (int)((double)this.i.top - ((double)n4 + this.k / 2.0) * (double)this.j.length / 2.0);
            this.i.right += 20;
            this.b = false;
        }
        this.h = new Rect(this.i);
        this.h.offset((int)f4 - this.i.width() / 2, (int)(f5 + (float)(this.i.height() / 2)));
        if (!TextOverlay.a(canvas, this.h.left, this.h.top, this.h.right, this.h.bottom)) {
            return false;
        }
        this.a = true;
        if (this.textOverlayList != null) {
            for (TextOverlay textOverlay : this.textOverlayList) {
                if (!new Rect(this.h).intersect(textOverlay.h)) continue;
                this.a = false;
                break;
            }
        }
        if (this.a) {
            int n5;
            double d10;
            if (this.e != null) {
                double d11 = (double)(this.j.length - 1) * ((double)(this.e.descent() - this.e.ascent()) + this.k) / 2.0;
                d10 = (double)(f5 - (this.e.descent() + this.e.ascent()) / 2.0f) - d11 / 2.0;
                for (n5 = 0; n5 < this.j.length; ++n5) {
                    canvas.drawText(this.j[n5], f4, (float)(d10 + (double)n5 * ((double)(this.e.descent() - this.e.ascent()) + this.k)), this.e);
                }
            }
            if (this.d != null) {
                double d12 = (double)(this.j.length - 1) * ((double)(this.d.descent() - this.d.ascent()) + this.k) / 2.0;
                d10 = (double)(f5 - (this.d.descent() + this.d.ascent()) / 2.0f) - d12 / 2.0;
                for (n5 = 0; n5 < this.j.length; ++n5) {
                    canvas.drawText(this.j[n5], f4, (float)(d10 + (double)n5 * ((double)(this.d.descent() - this.d.ascent()) + this.k)), this.d);
                }
            }
        }
        return true;
    }

    public synchronized GeoPoint getGeoPoint() {
        return this.c;
    }

    public synchronized Paint getPaintFill() {
        return this.d;
    }

    public synchronized Paint getPaintStroke() {
        return this.e;
    }

    public synchronized float getRadius() {
        return this.f;
    }

    public synchronized void setGeoPoint(GeoPoint geoPoint) {
        this.c = geoPoint;
    }

    public synchronized void setPaintFill(Paint paint) {
        this.d = paint;
    }

    public synchronized void setPaintStroke(Paint paint) {
        this.e = paint;
    }

    public synchronized void setText(String string) {
        this.g = string;
        this.b = true;
    }

    public boolean isDrawed() {
        return this.a;
    }
}

