package com.shitu.location.epathmap.utils;

import android.bluetooth.BluetoothAdapter;
import android.text.TextUtils;


import com.shitu.location.R;
import com.shitu.location.epathmap.EpathLocationSDK;
import com.shitu.location.epathmap.model.bean.BackgroundData;
import com.shitu.location.epathmap.model.parse.Project;

import com.mixpanel.android.mpmetrics.MixpanelAPI;

import java.util.ArrayList;
import java.util.LinkedHashMap;

/**
 * author:lfei
 */
public class MixpanelEvent {

    private static LinkedHashMap<String, Object> params;

    public static void init(){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.APP_NAME, Constants.getAppName(EpathLocationSDK.context));
        params.put(MixpanelConstants.SDK_VERSION_CODE, EpathLocationSDK.context.getString(R.string.ips_location_sdk_version_code));
        params.put(MixpanelConstants.SDK_VERSION_NAME, EpathLocationSDK.context.getString(R.string.ips_location_sdk_version_name));
        params.put(MixpanelConstants.BLUETOOTH_OPEN, BluetoothAdapter.getDefaultAdapter().isEnabled());
        params.put(MixpanelConstants.INTEGRATION_SHARE_MODULE, EpathLocationSDK.hasShareListener);
        mixpanel.registerSuperPropertiesMap(params);
    }

    public static void setProject(Project project){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        if (project != null) {
            params.put(MixpanelConstants.BUILDING_ID, project.getBuildingId());
            params.put(MixpanelConstants.BUILDING_NAME, project.getName());
        }
        mixpanel.registerSuperPropertiesMap(params);
    }

    public static void isInThisMap(boolean isInThisMap){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.IN_THIS_MAP, isInThisMap);
        mixpanel.registerSuperPropertiesMap(params);
    }

    public static MixpanelAPI Mixpanel() {
        return MixpanelAPI.getInstance(EpathLocationSDK.context, Constants.MIXPANEL_PROJECT_TOKEN);
    }

    public static void initSDK(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.track(MixpanelConstants.EVENT_SDK_INIT);
        mixpanel.flush();
    }

    public static void enterSDKMode(String enterSdkMode, String enterSdkTarget,
                                    String enterSdkTargetId){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.ENTER_SDK_MODE, enterSdkMode);
        params.put(MixpanelConstants.ENTER_SDK_TARGET_LOCATION, enterSdkTarget);
        params.put(MixpanelConstants.ENTER_SDK_TARGET_LOCATION_ID, enterSdkTargetId);
        mixpanel.trackMap(MixpanelConstants.EVENT_ENTER_SDK_MODE, params);
    }

    public static void updateFeedBack(int score, ArrayList<String> comments, String content,
                                      boolean navModeSimulation, String startLocation, String tartLocation,
                                      int navDistance, String navTime, boolean isExit){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.FEEDBACK_STAR, score);
        params.put(MixpanelConstants.FEEDBACK_COMMENTS, comments);
        params.put(MixpanelConstants.FEEDBACK_CONTENT, content);
        if (navModeSimulation) {
            params.put(MixpanelConstants.FEEDBACK_NAVIGATION_MODE, MixpanelConstants.FEEDBACK_NAVIGATION_MODE_SIMULATION);
        } else {
            params.put(MixpanelConstants.FEEDBACK_NAVIGATION_MODE, MixpanelConstants.FEEDBACK_NAVIGATION_MODE_REAL);
        }
        params.put(MixpanelConstants.FEEDBACK_NAVIGATION_START_LOCATION, startLocation);
        params.put(MixpanelConstants.FEEDBACK_NAVIGATION_TARGET_LOCATION, tartLocation);
        params.put(MixpanelConstants.FEEDBACK_NAVIGATION_DISTANCE, navDistance);
        params.put(MixpanelConstants.FEEDBACK_NAVIGATION_TIME, navTime);
        if (isExit) {
            params.put(MixpanelConstants.FEEDBACK_CLICK, MixpanelConstants.FEEDBACK_CLICK_EXIT);
        } else {
            params.put(MixpanelConstants.FEEDBACK_CLICK, MixpanelConstants.FEEDBACK_CLICK_SUBMIT);
        }
        mixpanel.trackMap(MixpanelConstants.EVENT_FEEDBACK, params);
    }

    public static void timeKeepSDK(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.timeEvent(MixpanelConstants.EVENT_TIMING_KEEP_SDK);
    }

    public static void timeKeepSDKTrack(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.track(MixpanelConstants.EVENT_TIMING_KEEP_SDK);
    }

    public static void timeLocationFix(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.timeEvent(MixpanelConstants.EVENT_TIMING_LOCATION_FIX);
    }

    public static void timeLocationFixTrack(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.track(MixpanelConstants.EVENT_TIMING_LOCATION_FIX);
    }

    public static void timeLoadMap(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.timeEvent(MixpanelConstants.EVENT_TIMING_LOAD_MAP);
    }

    public static void timeLoadMapTrack(boolean success){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        if(success){
            params.put(MixpanelConstants.RESULT, MixpanelConstants.SUCCESS);
        }else{
            params.put(MixpanelConstants.RESULT, MixpanelConstants.FAIL);
        }
        mixpanel.trackMap(MixpanelConstants.EVENT_TIMING_LOAD_MAP, params);
    }

    public static void clickRegion(String name, String pageStatus){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.REGION_NAME, name);
        params.put(MixpanelConstants.REGION_PAGE_STATUS, pageStatus);
        mixpanel.trackMap(MixpanelConstants.EVENT_CLICK_REGION, params);
    }

    public static void navigation(boolean navModeSimulation, String startLocation,
                                  String targetLocation, int navDistance, String navTime, double percent,
                                  String targetFrom){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        if (navModeSimulation) {
            params.put(MixpanelConstants.NAVIGATION_MODE, MixpanelConstants.NAVIGATION_MODE_SIMULATION);
        } else {
            params.put(MixpanelConstants.NAVIGATION_MODE, MixpanelConstants.NAVIGATION_MODE_REAL);

        }
        params.put(MixpanelConstants.NAVIGATION_START_LOCATION, startLocation);
        params.put(MixpanelConstants.NAVIGATION_TARGET_LOCATION, targetLocation);
        params.put(MixpanelConstants.NAVIGATION_DISTANCE, navDistance);
        params.put(MixpanelConstants.NAVIGATION_TIME, navTime);
        params.put(MixpanelConstants.NAVIGATION_PERCENT, percent);
        params.put(MixpanelConstants.NAVIGATION_TARGET_FROM, targetFrom);
        mixpanel.trackMap(MixpanelConstants.EVENT_NAVIGATION, params);
    }



   public static void backGroudUploadData(BackgroundData backgroundData){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
       ArrayList locationRegions = backgroundData.getLocationRegions();
       String locationRegionsString = "{";
       for (int i = 0; i < locationRegions.size(); i++) {
           String content = (String) locationRegions.get(i);
           locationRegionsString += "'"+content+"'";
       }
       locationRegionsString += "}";
       params.put(MixpanelConstants.LOCATIONREGIONS,locationRegionsString);
        params.put(MixpanelConstants.LOCATIONREGION, backgroundData.getLocationRegion());
        params.put(MixpanelConstants.DEVICEID,backgroundData.getDeviceId() );
        params.put(MixpanelConstants.PHONENUMBER, backgroundData.getPhoneNumber());
        params.put(MixpanelConstants.FLOORNAME, backgroundData.getFloorName());
        params.put(MixpanelConstants.DURATIONTME, backgroundData.getDurationTime());
        mixpanel.trackMap(MixpanelConstants.EVENT_BACKGROUND_DATA, params);
    }



    public static void search(String content, int resultSize, String searchFrom){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.SEARCH_CONTENT, content);
        params.put(MixpanelConstants.SEARCH_RESULT_SIZE, resultSize);
        params.put(MixpanelConstants.SEARCH_FROM, searchFrom);
        mixpanel.trackMap(MixpanelConstants.EVENT_SEARCH, params);
    }

    public static void locShareClick(){
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.track(MixpanelConstants.EVENT_LOC_SHARE_CLICK);
    }

    public static void locShareCreate(String result, String failPage){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.LOC_SHARE_CREATE_RESULT, result);
        if(!TextUtils.isEmpty(failPage)){
            params.put(MixpanelConstants.LOC_SHARE_CREATE_RESULT_FAIL_PAGE, failPage);
        }
        mixpanel.trackMap(MixpanelConstants.EVENT_LOC_SHARE_CREATE, params);
    }

    public static void locShare(String click, String type) {
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.LOC_SHARE_CLICK, click);
        params.put(MixpanelConstants.LOC_SHARE_TYPE, type);
        mixpanel.trackMap(MixpanelConstants.EVENT_LOC_SHARE, params);
    }

    public static void locShareJoin(String from, String type) {
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.LOC_SHARE_JOIN_FROM, from);
        params.put(MixpanelConstants.LOC_SHARE_JOIN_TYPE, type);
        mixpanel.trackMap(MixpanelConstants.EVENT_LOC_SHARE_JOIN, params);
    }

    public static void locShareJoinDialog(String click){
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.LOC_SHARE_JOIN_DIALOG_CLICK, click);
        mixpanel.trackMap(MixpanelConstants.EVENT_LOC_SHARE_JOIN_DIALOG, params);
    }

    public static void locShareMyLocation() {
        MixpanelAPI mixpanel = Mixpanel();
        mixpanel.track(MixpanelConstants.EVENT_LOC_SHARE_MY_LOCATION);
    }

    public static void locShareLocRegion(String name) {
        MixpanelAPI mixpanel = Mixpanel();
        params = new LinkedHashMap<>();
        params.put(MixpanelConstants.LOC_SHARE_NAME, name);
        mixpanel.trackMap(MixpanelConstants.EVENT_LOC_SHARE_LOCATION_REGION, params);
    }
}
