package com.shitu.location.epathmap.model.parse;

import android.text.TextUtils;

import com.shitu.location.epathmap.utils.ParseClass;
import com.parse.ParseClassName;
import com.parse.ParseObject;

/**
 * author:lfei
 */

@ParseClassName(ParseClass.POI)
public class POI extends ParseObject {

    public String getName() {
        return TextUtils.isEmpty(getShowName()) ? getString("name") : getShowName();
    }

    public String getShowName() {
        return getString("showName");
    }

    public ParseObject getGenre() {
        return getParseObject("genre");
    }

    public String getFloorName() {
        return getString("floor");
    }

    public double getLongitude() {
        return getDouble("lon");
    }

    public double getLatitude() {
        return getDouble("lat");
    }
    public String getIconUrl(){return getString("iconUrl");}
    public int getOrder() {
        return getInt("order");
    }

    public String getLink() {
        return getString("link");
    }
}
